/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.svm.core;

import com.oracle.svm.core.VMInspectionOptions;
import com.oracle.svm.core.option.LocatableMultiOptionValue;
import java.util.Iterator;
import java.util.NoSuchElementException;
import org.graalvm.compiler.options.OptionDescriptor;
import org.graalvm.compiler.options.OptionDescriptors;
import org.graalvm.compiler.options.OptionType;

public class VMInspectionOptions_OptionDescriptors
implements OptionDescriptors {
    public OptionDescriptor get(String value) {
        switch (value) {
            case "AllowVMInspection": {
                return OptionDescriptor.create((String)"AllowVMInspection", (OptionType)OptionType.User, Boolean.class, (String)"Enables features that allow the VM to be inspected during run time.", VMInspectionOptions.DeprecatedOptions.class, (String)"AllowVMInspection", VMInspectionOptions.DeprecatedOptions.AllowVMInspection, (boolean)true, (String)"Please use --enable-monitoring");
            }
            case "DumpRuntimeCompilationOnSignal": {
                return OptionDescriptor.create((String)"DumpRuntimeCompilationOnSignal", (OptionType)OptionType.User, Boolean.class, (String)"Dumps all runtime compiled methods on SIGUSR2.", VMInspectionOptions.class, (String)"DumpRuntimeCompilationOnSignal", VMInspectionOptions.DumpRuntimeCompilationOnSignal, (boolean)false, (String)"");
            }
            case "DumpThreadStacksOnSignal": {
                return OptionDescriptor.create((String)"DumpThreadStacksOnSignal", (OptionType)OptionType.User, Boolean.class, (String)"Dumps all thread stacktraces on SIGQUIT/SIGBREAK.", VMInspectionOptions.class, (String)"DumpThreadStacksOnSignal", VMInspectionOptions.DumpThreadStacksOnSignal, (boolean)false, (String)"");
            }
            case "EnableMonitoringFeatures": {
                return OptionDescriptor.create((String)"EnableMonitoringFeatures", (OptionType)OptionType.User, LocatableMultiOptionValue.Strings.class, (String)"Enable monitoring features that allow the VM to be inspected at run time. Comma-separated list can contain 'heapdump', 'jfr', 'jvmstat', or 'all' (defaults to 'all' if no argument is provided). For example: `--enable-monitoring=heapdump,jvmstat`.", VMInspectionOptions.class, (String)"EnableMonitoringFeatures", VMInspectionOptions.EnableMonitoringFeatures, (boolean)false, (String)"");
            }
        }
        return null;
    }

    public Iterator<OptionDescriptor> iterator() {
        return new Iterator<OptionDescriptor>(){
            int i = 0;

            @Override
            public boolean hasNext() {
                return this.i < 4;
            }

            @Override
            public OptionDescriptor next() {
                switch (this.i++) {
                    case 0: {
                        return VMInspectionOptions_OptionDescriptors.this.get("AllowVMInspection");
                    }
                    case 1: {
                        return VMInspectionOptions_OptionDescriptors.this.get("DumpRuntimeCompilationOnSignal");
                    }
                    case 2: {
                        return VMInspectionOptions_OptionDescriptors.this.get("DumpThreadStacksOnSignal");
                    }
                    case 3: {
                        return VMInspectionOptions_OptionDescriptors.this.get("EnableMonitoringFeatures");
                    }
                }
                throw new NoSuchElementException();
            }
        };
    }
}

