/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.graal.reachability;

import com.oracle.graal.pointsto.meta.AnalysisField;
import com.oracle.graal.pointsto.meta.AnalysisMethod;
import com.oracle.graal.pointsto.meta.AnalysisType;
import com.oracle.graal.reachability.MethodSummary;
import com.oracle.graal.reachability.MethodSummaryProvider;
import com.oracle.graal.reachability.ReachabilityAnalysisEngine;
import com.oracle.graal.reachability.ReachabilityAnalysisField;
import com.oracle.graal.reachability.ReachabilityAnalysisMethod;
import com.oracle.graal.reachability.ReachabilityAnalysisType;
import com.oracle.graal.reachability.ReachabilityInvokeInfo;
import com.oracle.svm.util.GuardedAnnotationAccess;
import java.lang.reflect.AnnotatedElement;
import java.lang.reflect.Modifier;
import java.util.Optional;
import jdk.vm.ci.meta.JavaConstant;
import jdk.vm.ci.meta.ResolvedJavaMethod;
import jdk.vm.ci.meta.ResolvedJavaType;
import org.graalvm.collections.EconomicSet;
import org.graalvm.compiler.core.common.spi.ForeignCallDescriptor;
import org.graalvm.compiler.core.common.spi.ForeignCallSignature;
import org.graalvm.compiler.graph.Node;
import org.graalvm.compiler.nodes.CallTargetNode;
import org.graalvm.compiler.nodes.ConstantNode;
import org.graalvm.compiler.nodes.FrameState;
import org.graalvm.compiler.nodes.Invoke;
import org.graalvm.compiler.nodes.StructuredGraph;
import org.graalvm.compiler.nodes.extended.ForeignCall;
import org.graalvm.compiler.nodes.java.InstanceOfNode;
import org.graalvm.compiler.nodes.java.LoadFieldNode;
import org.graalvm.compiler.nodes.java.NewArrayNode;
import org.graalvm.compiler.nodes.java.NewInstanceNode;
import org.graalvm.compiler.nodes.java.NewMultiArrayNode;
import org.graalvm.compiler.nodes.java.StoreFieldNode;
import org.graalvm.compiler.nodes.virtual.VirtualArrayNode;
import org.graalvm.compiler.nodes.virtual.VirtualInstanceNode;
import org.graalvm.compiler.replacements.nodes.BinaryMathIntrinsicNode;
import org.graalvm.compiler.replacements.nodes.MacroInvokable;
import org.graalvm.compiler.replacements.nodes.UnaryMathIntrinsicNode;

public class SimpleInMemoryMethodSummaryProvider
implements MethodSummaryProvider {
    @Override
    public MethodSummary getSummary(ReachabilityAnalysisEngine bb, ReachabilityAnalysisMethod method) {
        StructuredGraph decoded = ReachabilityAnalysisMethod.getDecodedGraph(bb, method);
        return SimpleInMemoryMethodSummaryProvider.createSummaryFromGraph(bb, decoded, method);
    }

    @Override
    public MethodSummary getSummary(ReachabilityAnalysisEngine bb, StructuredGraph graph) {
        return SimpleInMemoryMethodSummaryProvider.createSummaryFromGraph(bb, graph, null);
    }

    private static MethodSummary createSummaryFromGraph(ReachabilityAnalysisEngine bb, StructuredGraph graph, ReachabilityAnalysisMethod method) {
        EconomicSet accessedTypes = EconomicSet.create();
        EconomicSet instantiatedTypes = EconomicSet.create();
        EconomicSet readFields = EconomicSet.create();
        EconomicSet writtenFields = EconomicSet.create();
        EconomicSet invokedMethods = EconomicSet.create();
        EconomicSet implementationInvokedMethods = EconomicSet.create();
        EconomicSet embeddedConstants = EconomicSet.create();
        EconomicSet foreignCallTargets = EconomicSet.create();
        if (method != null) {
            int offset;
            boolean isStatic = Modifier.isStatic(method.getModifiers());
            int parameterCount = method.getSignature().getParameterCount(!isStatic);
            for (int i = offset = isStatic ? 0 : 1; i < parameterCount; ++i) {
                accessedTypes.add((Object)((ReachabilityAnalysisType)method.getSignature().getParameterType(i - offset, (ResolvedJavaType)method.getDeclaringClass())));
            }
            accessedTypes.add((Object)((ReachabilityAnalysisType)method.getSignature().getReturnType((ResolvedJavaType)method.getDeclaringClass())));
        }
        for (Node n : graph.getNodes()) {
            if (n instanceof NewInstanceNode) {
                NewInstanceNode node = (NewInstanceNode)n;
                instantiatedTypes.add((Object)((ReachabilityAnalysisType)node.instanceClass()));
                continue;
            }
            if (n instanceof NewArrayNode) {
                NewArrayNode node = (NewArrayNode)n;
                instantiatedTypes.add((Object)((ReachabilityAnalysisType)node.elementType()).getArrayClass());
                continue;
            }
            if (n instanceof NewMultiArrayNode) {
                NewMultiArrayNode node = (NewMultiArrayNode)n;
                ResolvedJavaType type = node.type();
                for (int i = 0; i < node.dimensionCount(); ++i) {
                    instantiatedTypes.add((Object)((ReachabilityAnalysisType)type));
                    type = type.getComponentType();
                }
                continue;
            }
            if (n instanceof VirtualInstanceNode) {
                VirtualInstanceNode node = (VirtualInstanceNode)n;
                instantiatedTypes.add((Object)((ReachabilityAnalysisType)node.type()));
                continue;
            }
            if (n instanceof VirtualArrayNode) {
                VirtualArrayNode node = (VirtualArrayNode)n;
                instantiatedTypes.add((Object)((ReachabilityAnalysisType)node.componentType()).getArrayClass());
                continue;
            }
            if (n instanceof ConstantNode) {
                ConstantNode node = (ConstantNode)n;
                if (!(node.getValue() instanceof JavaConstant)) continue;
                embeddedConstants.add((Object)((JavaConstant)node.getValue()));
                continue;
            }
            if (n instanceof InstanceOfNode) {
                InstanceOfNode node = (InstanceOfNode)n;
                accessedTypes.add((Object)((ReachabilityAnalysisType)node.type().getType()));
                continue;
            }
            if (n instanceof LoadFieldNode) {
                LoadFieldNode node = (LoadFieldNode)n;
                readFields.add((Object)((ReachabilityAnalysisField)node.field()));
                continue;
            }
            if (n instanceof StoreFieldNode) {
                StoreFieldNode node = (StoreFieldNode)n;
                writtenFields.add((Object)((ReachabilityAnalysisField)node.field()));
                continue;
            }
            if (n instanceof Invoke) {
                Invoke node = (Invoke)n;
                CallTargetNode.InvokeKind kind = node.getInvokeKind();
                ReachabilityAnalysisMethod targetMethod = (ReachabilityAnalysisMethod)node.getTargetMethod();
                if (targetMethod == null || GuardedAnnotationAccess.isAnnotationPresent((AnnotatedElement)((Object)targetMethod), Node.NodeIntrinsic.class)) continue;
                if (method != null) {
                    method.addInvoke(new ReachabilityInvokeInfo(targetMethod, ReachabilityAnalysisMethod.sourcePosition(node, method), kind.isDirect()));
                }
                if (kind.isDirect()) {
                    implementationInvokedMethods.add((Object)targetMethod);
                    continue;
                }
                invokedMethods.add((Object)targetMethod);
                continue;
            }
            if (n instanceof FrameState) {
                FrameState node = (FrameState)n;
                ResolvedJavaMethod frameMethod = node.getMethod();
                if (frameMethod == null) continue;
                ReachabilityAnalysisMethod analysisMethod = (ReachabilityAnalysisMethod)frameMethod;
                accessedTypes.add((Object)analysisMethod.getDeclaringClass());
                continue;
            }
            if (n instanceof MacroInvokable) {
                MacroInvokable node = (MacroInvokable)n;
                ReachabilityAnalysisMethod targetMethod = (ReachabilityAnalysisMethod)node.getTargetMethod();
                if (node.getInvokeKind().isDirect()) {
                    implementationInvokedMethods.add((Object)targetMethod);
                    continue;
                }
                invokedMethods.add((Object)targetMethod);
                continue;
            }
            if (n instanceof ForeignCall) {
                SimpleInMemoryMethodSummaryProvider.handleForeignCall(bb, (EconomicSet<AnalysisMethod>)foreignCallTargets, ((ForeignCall)n).getDescriptor());
                continue;
            }
            if (n instanceof UnaryMathIntrinsicNode) {
                ForeignCallSignature signature = ((UnaryMathIntrinsicNode)n).getOperation().foreignCallSignature;
                SimpleInMemoryMethodSummaryProvider.handleForeignCall(bb, (EconomicSet<AnalysisMethod>)foreignCallTargets, bb.getProviders().getForeignCalls().getDescriptor(signature));
                continue;
            }
            if (!(n instanceof BinaryMathIntrinsicNode)) continue;
            ForeignCallSignature signature = ((BinaryMathIntrinsicNode)n).getOperation().foreignCallSignature;
            SimpleInMemoryMethodSummaryProvider.handleForeignCall(bb, (EconomicSet<AnalysisMethod>)foreignCallTargets, bb.getProviders().getForeignCalls().getDescriptor(signature));
        }
        return new MethodSummary((EconomicSet<AnalysisMethod>)invokedMethods, (EconomicSet<AnalysisMethod>)implementationInvokedMethods, (EconomicSet<AnalysisType>)accessedTypes, (EconomicSet<AnalysisType>)instantiatedTypes, (EconomicSet<AnalysisField>)readFields, (EconomicSet<AnalysisField>)writtenFields, (EconomicSet<JavaConstant>)embeddedConstants, (EconomicSet<AnalysisMethod>)foreignCallTargets);
    }

    private static void handleForeignCall(ReachabilityAnalysisEngine bb, EconomicSet<AnalysisMethod> foreignCallTargets, ForeignCallDescriptor descriptor) {
        Optional targetMethod = bb.getHostVM().handleForeignCall(descriptor, bb.getProviders().getForeignCalls());
        targetMethod.ifPresent(arg_0 -> foreignCallTargets.add(arg_0));
    }
}

