/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.svm.reflect.target;

import com.oracle.svm.core.annotate.Alias;
import com.oracle.svm.core.annotate.RecomputeFieldValue;
import com.oracle.svm.core.annotate.Substitute;
import com.oracle.svm.core.annotate.TargetClass;
import com.oracle.svm.core.annotate.TargetElement;
import com.oracle.svm.core.util.VMError;
import com.oracle.svm.hosted.image.NativeImageCodeCache;
import com.oracle.svm.reflect.hosted.ExecutableAccessorComputer;
import com.oracle.svm.reflect.hosted.ReflectionMetadataComputer;
import com.oracle.svm.reflect.target.Target_jdk_internal_reflect_ConstructorAccessor;
import java.lang.reflect.AccessibleObject;
import java.lang.reflect.Constructor;
import java.lang.reflect.Executable;
import jdk.vm.ci.meta.MetaAccessProvider;
import jdk.vm.ci.meta.ResolvedJavaField;
import org.graalvm.nativeimage.ImageSingletons;

@TargetClass(value=Constructor.class)
public final class Target_java_lang_reflect_Constructor {
    @Alias
    @RecomputeFieldValue(kind=RecomputeFieldValue.Kind.Custom, declClass=AnnotationsComputer.class)
    byte[] annotations;
    @Alias
    @RecomputeFieldValue(kind=RecomputeFieldValue.Kind.Custom, declClass=ParameterAnnotationsComputer.class)
    byte[] parameterAnnotations;
    @Alias
    @RecomputeFieldValue(kind=RecomputeFieldValue.Kind.Custom, declClass=ExecutableAccessorComputer.class)
    Target_jdk_internal_reflect_ConstructorAccessor constructorAccessor;

    @Alias
    @TargetElement(name="<init>")
    public native void constructor(Class<?> var1, Class<?>[] var2, Class<?>[] var3, int var4, int var5, String var6, byte[] var7, byte[] var8);

    @Alias
    native Target_java_lang_reflect_Constructor copy();

    @Substitute
    Target_jdk_internal_reflect_ConstructorAccessor acquireConstructorAccessor() {
        if (this.constructorAccessor == null) {
            throw VMError.unsupportedFeature("Runtime reflection is not supported for " + this);
        }
        return this.constructorAccessor;
    }

    static class ParameterAnnotationsComputer
    extends ReflectionMetadataComputer {
        ParameterAnnotationsComputer() {
        }

        @Override
        public Object compute(MetaAccessProvider metaAccess, ResolvedJavaField original, ResolvedJavaField annotated, Object receiver) {
            return ((NativeImageCodeCache.ReflectionMetadataEncoder)ImageSingletons.lookup(NativeImageCodeCache.ReflectionMetadataEncoder.class)).getParameterAnnotationsEncoding((Executable)receiver);
        }
    }

    static class AnnotationsComputer
    extends ReflectionMetadataComputer {
        AnnotationsComputer() {
        }

        @Override
        public Object compute(MetaAccessProvider metaAccess, ResolvedJavaField original, ResolvedJavaField annotated, Object receiver) {
            return ((NativeImageCodeCache.ReflectionMetadataEncoder)ImageSingletons.lookup(NativeImageCodeCache.ReflectionMetadataEncoder.class)).getAnnotationsEncoding((AccessibleObject)receiver);
        }
    }
}

