/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.svm.reflect.proxy.hosted;

import com.oracle.svm.core.configure.ConditionalElement;
import com.oracle.svm.core.jdk.proxy.DynamicProxyRegistry;
import com.oracle.svm.hosted.ConditionalConfigurationRegistry;
import com.oracle.svm.hosted.ConfigurationTypeResolver;
import com.oracle.svm.hosted.ImageClassLoader;
import java.util.List;
import java.util.function.Consumer;

public class ProxyRegistry
extends ConditionalConfigurationRegistry
implements Consumer<ConditionalElement<List<String>>> {
    private final ConfigurationTypeResolver typeResolver;
    private final DynamicProxyRegistry dynamicProxySupport;
    private final ImageClassLoader imageClassLoader;

    public ProxyRegistry(ConfigurationTypeResolver typeResolver, DynamicProxyRegistry dynamicProxySupport, ImageClassLoader imageClassLoader) {
        this.typeResolver = typeResolver;
        this.dynamicProxySupport = dynamicProxySupport;
        this.imageClassLoader = imageClassLoader;
    }

    @Override
    public void accept(ConditionalElement<List<String>> proxies) {
        if (this.typeResolver.resolveType(proxies.getCondition().getTypeName()) == null) {
            return;
        }
        List<String> interfaceNames = proxies.getElement();
        Class[] interfaces = new Class[interfaceNames.size()];
        for (int i = 0; i < interfaceNames.size(); ++i) {
            Class<?> clazz;
            String className = interfaceNames.get(i);
            if (!ProxyRegistry.checkClass(interfaceNames, className, clazz = this.imageClassLoader.findClass(className).get())) {
                return;
            }
            interfaces[i] = clazz;
        }
        this.registerConditionalConfiguration(proxies.getCondition(), () -> this.dynamicProxySupport.addProxyClass(interfaces));
    }

    private static boolean checkClass(List<String> interfaceNames, String className, Class<?> clazz) {
        if (clazz == null) {
            ProxyRegistry.warning(interfaceNames, "Class " + className + " not found.");
            return false;
        }
        if (!clazz.isInterface()) {
            ProxyRegistry.warning(interfaceNames, "Class " + className + " is not an interface.");
            return false;
        }
        return true;
    }

    private static void warning(List<String> interfaceNames, String reason) {
        System.out.println("WARNING: Cannot register dynamic proxy for interface list: " + String.join((CharSequence)", ", interfaceNames) + ". Reason: " + reason);
    }
}

