/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.svm.reflect.hosted;

import com.oracle.graal.pointsto.meta.AnalysisField;
import com.oracle.graal.pointsto.meta.AnalysisMethod;
import com.oracle.svm.core.annotate.Delete;
import com.oracle.svm.core.code.CodeInfoEncoder;
import com.oracle.svm.core.hub.DynamicHub;
import com.oracle.svm.core.meta.SubstrateObjectConstant;
import com.oracle.svm.core.util.ByteArrayReader;
import com.oracle.svm.core.util.VMError;
import com.oracle.svm.hosted.image.NativeImageCodeCache;
import com.oracle.svm.hosted.meta.HostedField;
import com.oracle.svm.hosted.meta.HostedMetaAccess;
import com.oracle.svm.hosted.meta.HostedMethod;
import com.oracle.svm.hosted.meta.HostedType;
import com.oracle.svm.hosted.substitute.DeletedElementException;
import com.oracle.svm.reflect.hosted.ReflectionMetadata;
import com.oracle.svm.reflect.target.ReflectionMetadataEncoding;
import com.oracle.svm.util.ReflectionUtil;
import java.lang.annotation.Annotation;
import java.lang.reflect.AccessibleObject;
import java.lang.reflect.AnnotatedElement;
import java.lang.reflect.Constructor;
import java.lang.reflect.Executable;
import java.lang.reflect.Field;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.lang.reflect.Parameter;
import java.lang.reflect.Proxy;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeSet;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import jdk.vm.ci.meta.Constant;
import jdk.vm.ci.meta.JavaConstant;
import jdk.vm.ci.meta.MetaAccessProvider;
import org.graalvm.collections.Pair;
import org.graalvm.compiler.core.common.util.TypeConversion;
import org.graalvm.compiler.core.common.util.UnsafeArrayTypeWriter;
import org.graalvm.compiler.debug.GraalError;
import org.graalvm.compiler.serviceprovider.JavaVersionUtil;
import org.graalvm.nativeimage.ImageSingletons;
import org.graalvm.nativeimage.impl.RuntimeReflectionSupport;
import org.graalvm.util.GuardedAnnotationAccess;
import sun.invoke.util.Wrapper;
import sun.reflect.annotation.AnnotationType;
import sun.reflect.annotation.EnumConstantNotPresentExceptionProxy;
import sun.reflect.annotation.ExceptionProxy;
import sun.reflect.annotation.TypeAnnotation;
import sun.reflect.annotation.TypeAnnotationParser;
import sun.reflect.annotation.TypeNotPresentExceptionProxy;

public class ReflectionMetadataEncoderImpl
implements NativeImageCodeCache.ReflectionMetadataEncoder {
    private final CodeInfoEncoder.Encoders encoders;
    private final ReflectionDataAccessors accessors;
    private final Map<Pair<Annotation, String>, JavaConstant> annotationExceptionProxies = new HashMap<Pair<Annotation, String>, JavaConstant>();
    private final TreeSet<HostedType> sortedTypes = new TreeSet<HostedType>(Comparator.comparingLong(t -> t.getHub().getTypeID()));
    private final Map<HostedType, ReflectionMetadata.ClassMetadata> classData = new HashMap<HostedType, ReflectionMetadata.ClassMetadata>();
    private final Map<HostedType, Map<Object, ReflectionMetadata.FieldMetadata>> fieldData = new HashMap<HostedType, Map<Object, ReflectionMetadata.FieldMetadata>>();
    private final Map<HostedType, Map<Object, ReflectionMetadata.MethodMetadata>> methodData = new HashMap<HostedType, Map<Object, ReflectionMetadata.MethodMetadata>>();
    private final Map<HostedType, Map<Object, ReflectionMetadata.ConstructorMetadata>> constructorData = new HashMap<HostedType, Map<Object, ReflectionMetadata.ConstructorMetadata>>();
    private final Set<ReflectionMetadata.AccessibleObjectMetadata> heapData = new HashSet<ReflectionMetadata.AccessibleObjectMetadata>();
    private final Map<AccessibleObject, byte[]> annotationsEncodings = new HashMap<AccessibleObject, byte[]>();
    private final Map<Executable, byte[]> parameterAnnotationsEncodings = new HashMap<Executable, byte[]>();
    private final Map<Method, byte[]> annotationDefaultEncodings = new HashMap<Method, byte[]>();
    private final Map<AccessibleObject, byte[]> typeAnnotationsEncodings = new HashMap<AccessibleObject, byte[]>();
    private final Map<Executable, byte[]> reflectParametersEncodings = new HashMap<Executable, byte[]>();
    private static final Method getEnclosingMethodInfo = ReflectionUtil.lookupMethod(Class.class, (String)"getEnclosingMethod0", (Class[])new Class[0]);
    private static final Method getPermittedSubclasses = ReflectionUtil.lookupMethod((boolean)true, Class.class, (String)"getPermittedSubclasses", (Class[])new Class[0]);
    private static final Method isFieldTrustedFinal = ReflectionUtil.lookupMethod((boolean)true, Field.class, (String)"isTrustedFinal", (Class[])new Class[0]);
    private static final Method getRoot = ReflectionUtil.lookupMethod(AccessibleObject.class, (String)"getRoot", (Class[])new Class[0]);
    private static final Method parseAllTypeAnnotations = ReflectionUtil.lookupMethod(TypeAnnotationParser.class, (String)"parseAllTypeAnnotations", (Class[])new Class[]{AnnotatedElement.class});
    private static final Class<?> recordComponentClass;
    private static final Method getRecordComponentName;
    private static final Method getRecordComponentType;
    private static final Method getRecordComponentSignature;
    private static final Method getRecordComponentAccessor;
    private static final Method getFieldSignature;
    private static final Method getMethodSignature;
    private static final Method getConstructorSignature;
    private static final Method getExecutableParameters;
    private static final Field annotationInvocationHandlerMemberValues;
    private static final byte CLASS_TYPE_PARAMETER = 0;
    private static final byte METHOD_TYPE_PARAMETER = 1;
    private static final byte CLASS_EXTENDS = 16;
    private static final byte CLASS_TYPE_PARAMETER_BOUND = 17;
    private static final byte METHOD_TYPE_PARAMETER_BOUND = 18;
    private static final byte FIELD = 19;
    private static final byte METHOD_RETURN = 20;
    private static final byte METHOD_RECEIVER = 21;
    private static final byte METHOD_FORMAL_PARAMETER = 22;
    private static final byte THROWS = 23;
    private static final Field locationInfoDepth;
    private static final Field locationInfoLocations;

    public ReflectionMetadataEncoderImpl(CodeInfoEncoder.Encoders encoders) {
        this.encoders = encoders;
        this.accessors = new ReflectionDataAccessors();
    }

    private void registerClass(HostedType type, ReflectionMetadata.ClassMetadata metadata) {
        this.sortedTypes.add(type);
        this.classData.put(type, metadata);
    }

    private void registerField(HostedType declaringType, Object field, ReflectionMetadata.FieldMetadata metadata) {
        this.sortedTypes.add(declaringType);
        ReflectionMetadata.FieldMetadata oldData = this.fieldData.computeIfAbsent(declaringType, t -> new HashMap()).put(field, metadata);
        assert (oldData == null);
    }

    private ReflectionMetadata.FieldMetadata[] getFields(HostedType declaringType) {
        Field[] jdkFields = this.accessors.getDeclaredFields(declaringType.getJavaClass());
        Map fieldMetadata = this.fieldData.getOrDefault(declaringType, Collections.emptyMap());
        return ReflectionMetadataEncoderImpl.sortElements(jdkFields, fieldMetadata).toArray(new ReflectionMetadata.FieldMetadata[0]);
    }

    private void registerMethod(HostedType declaringType, Object method, ReflectionMetadata.MethodMetadata metadata) {
        this.sortedTypes.add(declaringType);
        ReflectionMetadata.MethodMetadata oldData = this.methodData.computeIfAbsent(declaringType, t -> new HashMap()).put(method, metadata);
        assert (oldData == null);
    }

    private ReflectionMetadata.MethodMetadata[] getMethods(HostedType declaringType) {
        Method[] jdkMethods = this.accessors.getDeclaredMethods(declaringType.getJavaClass());
        Map methodMetadata = this.methodData.getOrDefault(declaringType, Collections.emptyMap());
        return ReflectionMetadataEncoderImpl.sortElements(jdkMethods, methodMetadata).toArray(new ReflectionMetadata.MethodMetadata[0]);
    }

    private void registerConstructor(HostedType declaringType, Object constructor, ReflectionMetadata.ConstructorMetadata metadata) {
        this.sortedTypes.add(declaringType);
        ReflectionMetadata.ConstructorMetadata oldData = this.constructorData.computeIfAbsent(declaringType, t -> new HashMap()).put(constructor, metadata);
        assert (oldData == null);
    }

    private ReflectionMetadata.ConstructorMetadata[] getConstructors(HostedType declaringType) {
        Constructor<?>[] jdkConstructors = this.accessors.getDeclaredConstructors(declaringType.getJavaClass());
        Map constructorMetadata = this.constructorData.getOrDefault(declaringType, Collections.emptyMap());
        return ReflectionMetadataEncoderImpl.sortElements(jdkConstructors, constructorMetadata).toArray(new ReflectionMetadata.ConstructorMetadata[0]);
    }

    private static <T, M> List<M> sortElements(T[] jdkElements, Map<T, M> metadata) {
        ArrayList<Object> orderedElements = new ArrayList<Object>();
        ArrayList<M> trailingElements = new ArrayList<M>();
        for (T element : jdkElements) {
            if (!metadata.containsKey(element)) continue;
            M elementMetadata = metadata.remove(element);
            if (element instanceof Method && ((Method)element).isBridge()) {
                trailingElements.add(elementMetadata);
                continue;
            }
            orderedElements.add(elementMetadata);
        }
        orderedElements.addAll(metadata.values());
        orderedElements.addAll(trailingElements);
        return orderedElements;
    }

    @Override
    public byte[] getAnnotationsEncoding(AccessibleObject object) {
        return this.annotationsEncodings.get(object);
    }

    @Override
    public byte[] getParameterAnnotationsEncoding(Executable object) {
        return this.parameterAnnotationsEncodings.get(object);
    }

    @Override
    public byte[] getAnnotationDefaultEncoding(Method object) {
        return this.annotationDefaultEncodings.get(object);
    }

    @Override
    public byte[] getTypeAnnotationsEncoding(AccessibleObject object) {
        return this.typeAnnotationsEncodings.get(object);
    }

    @Override
    public byte[] getReflectParametersEncoding(Executable object) {
        return this.reflectParametersEncodings.get(object);
    }

    @Override
    public void addClassMetadata(MetaAccessProvider metaAccess, HostedType type, Class<?>[] innerClasses) {
        Class<?> javaClass = type.getHub().getHostedJavaClass();
        Object[] enclosingMethodInfo = ReflectionMetadataEncoderImpl.getEnclosingMethodInfo(javaClass);
        if (enclosingMethodInfo != null) {
            enclosingMethodInfo[0] = ((HostedMetaAccess)metaAccess).lookupJavaType((Class)enclosingMethodInfo[0]);
        }
        ReflectionMetadata.RecordComponentMetadata[] recordComponents = this.getRecordComponents(metaAccess, type, javaClass);
        Class<?>[] permittedSubclasses = ReflectionMetadataEncoderImpl.getPermittedSubclasses(metaAccess, javaClass);
        Annotation[] annotations = GuardedAnnotationAccess.getDeclaredAnnotations((AnnotatedElement)((Object)type));
        TypeAnnotation[] typeAnnotations = ReflectionMetadataEncoderImpl.getTypeAnnotations(javaClass);
        this.encoders.sourceClasses.addObject(javaClass);
        if (enclosingMethodInfo != null) {
            this.encoders.sourceClasses.addObject(((HostedType)enclosingMethodInfo[0]).getJavaClass());
            this.encoders.sourceMethodNames.addObject((Object)((String)enclosingMethodInfo[1]));
            this.encoders.sourceMethodNames.addObject((Object)((String)enclosingMethodInfo[2]));
        }
        HostedType[] innerTypes = this.registerClassValues(metaAccess, innerClasses);
        HostedType[] permittedSubtypes = permittedSubclasses != null ? this.registerClassValues(metaAccess, permittedSubclasses) : null;
        annotations = this.registerAnnotationValues(metaAccess, annotations);
        typeAnnotations = this.registerTypeAnnotationValues(metaAccess, typeAnnotations);
        this.registerClass(type, new ReflectionMetadata.ClassMetadata(innerTypes, enclosingMethodInfo, recordComponents, permittedSubtypes, annotations, typeAnnotations));
    }

    private static Object[] getEnclosingMethodInfo(Class<?> clazz) {
        try {
            return (Object[])getEnclosingMethodInfo.invoke(clazz, new Object[0]);
        }
        catch (IllegalAccessException | InvocationTargetException e) {
            throw GraalError.shouldNotReachHere((Throwable)e);
        }
    }

    private static Class<?>[] getPermittedSubclasses(MetaAccessProvider metaAccess, Class<?> clazz) {
        if (JavaVersionUtil.JAVA_SPEC < 17) {
            return null;
        }
        try {
            Class[] permittedSubclasses = (Class[])getPermittedSubclasses.invoke(clazz, new Object[0]);
            if (permittedSubclasses == null) {
                return null;
            }
            HashSet<Class> reachablePermittedSubclasses = new HashSet<Class>();
            for (Class permittedSubclass : permittedSubclasses) {
                HostedType hostedType = ((HostedMetaAccess)metaAccess).optionalLookupJavaType(permittedSubclass).orElse(null);
                if (hostedType == null || !hostedType.getWrapped().isReachable()) continue;
                reachablePermittedSubclasses.add(permittedSubclass);
            }
            return reachablePermittedSubclasses.toArray(new Class[0]);
        }
        catch (IllegalAccessException | InvocationTargetException e) {
            throw GraalError.shouldNotReachHere((Throwable)e);
        }
    }

    @Override
    public void addReflectionFieldMetadata(MetaAccessProvider metaAccess, HostedField hostedField, Field reflectField) {
        HostedType declaringType = hostedField.getDeclaringClass();
        String name = hostedField.getName();
        HostedType type = hostedField.getType();
        int modifiers = reflectField.getModifiers();
        boolean trustedFinal = ReflectionMetadataEncoderImpl.isTrustedFinal(reflectField);
        String signature = ReflectionMetadataEncoderImpl.getSignature(reflectField);
        Annotation[] annotations = GuardedAnnotationAccess.getDeclaredAnnotations((AnnotatedElement)((Object)hostedField));
        TypeAnnotation[] typeAnnotations = ReflectionMetadataEncoderImpl.getTypeAnnotations(reflectField);
        int offset = hostedField.wrapped.isUnsafeAccessed() ? hostedField.getOffset() : -1;
        Delete deleteAnnotation = (Delete)GuardedAnnotationAccess.getAnnotation((AnnotatedElement)((Object)hostedField), Delete.class);
        String deletedReason = deleteAnnotation != null ? deleteAnnotation.value() : null;
        this.encoders.sourceMethodNames.addObject((Object)name);
        this.encoders.sourceClasses.addObject(type.getJavaClass());
        this.encoders.sourceMethodNames.addObject((Object)signature);
        this.encoders.sourceMethodNames.addObject((Object)deletedReason);
        annotations = this.registerAnnotationValues(metaAccess, annotations);
        typeAnnotations = this.registerTypeAnnotationValues(metaAccess, typeAnnotations);
        this.registerField(declaringType, reflectField, new ReflectionMetadata.FieldMetadata(declaringType, name, type, modifiers, trustedFinal, signature, annotations, typeAnnotations, offset, deletedReason));
    }

    @Override
    public void addReflectionExecutableMetadata(MetaAccessProvider metaAccess, HostedMethod hostedMethod, Executable reflectMethod, Object accessor) {
        boolean isMethod = !hostedMethod.isConstructor();
        HostedType declaringType = hostedMethod.getDeclaringClass();
        String name = isMethod ? hostedMethod.getName() : null;
        HostedType[] parameterTypes = ReflectionMetadataEncoderImpl.getParameterTypes(hostedMethod);
        int modifiers = reflectMethod.getModifiers();
        HostedType returnType = (HostedType)hostedMethod.getSignature().getReturnType(null);
        HostedType[] exceptionTypes = ReflectionMetadataEncoderImpl.getExceptionTypes(metaAccess, reflectMethod);
        String signature = ReflectionMetadataEncoderImpl.getSignature(reflectMethod);
        Annotation[] annotations = GuardedAnnotationAccess.getDeclaredAnnotations((AnnotatedElement)((Object)hostedMethod));
        Annotation[][] parameterAnnotations = reflectMethod.getParameterAnnotations();
        Object annotationDefault = isMethod ? ((Method)reflectMethod).getDefaultValue() : null;
        TypeAnnotation[] typeAnnotations = ReflectionMetadataEncoderImpl.getTypeAnnotations(reflectMethod);
        ReflectionMetadata.ReflectParameterMetadata[] reflectParameters = ReflectionMetadataEncoderImpl.getReflectParameters(reflectMethod);
        if (isMethod) {
            this.encoders.sourceMethodNames.addObject((Object)name);
            this.encoders.sourceClasses.addObject(returnType.getJavaClass());
        }
        for (HostedType parameterType : parameterTypes) {
            this.encoders.sourceClasses.addObject(parameterType.getJavaClass());
        }
        for (HostedType exceptionType : exceptionTypes) {
            this.encoders.sourceClasses.addObject(exceptionType.getJavaClass());
        }
        this.encoders.sourceMethodNames.addObject((Object)signature);
        annotations = this.registerAnnotationValues(metaAccess, annotations);
        for (int i = 0; i < parameterAnnotations.length; ++i) {
            parameterAnnotations[i] = this.registerAnnotationValues(metaAccess, parameterAnnotations[i]);
        }
        if (isMethod && annotationDefault != null) {
            this.registerAnnotationValue(ReflectionMetadataEncoderImpl.getAnnotationEncodingType(annotationDefault), annotationDefault);
        }
        typeAnnotations = this.registerTypeAnnotationValues(metaAccess, typeAnnotations);
        if (reflectParameters != null) {
            for (ReflectionMetadata.ReflectParameterMetadata parameter : reflectParameters) {
                this.encoders.sourceMethodNames.addObject((Object)parameter.name);
            }
        }
        JavaConstant accessorConstant = null;
        if (accessor != null) {
            accessorConstant = SubstrateObjectConstant.forObject(accessor);
            this.encoders.objectConstants.addObject((Object)accessorConstant);
        }
        if (isMethod) {
            this.registerMethod(declaringType, reflectMethod, new ReflectionMetadata.MethodMetadata(declaringType, name, parameterTypes, modifiers, returnType, exceptionTypes, signature, annotations, parameterAnnotations, annotationDefault, typeAnnotations, reflectParameters, accessorConstant));
        } else {
            this.registerConstructor(declaringType, reflectMethod, new ReflectionMetadata.ConstructorMetadata(declaringType, parameterTypes, modifiers, exceptionTypes, signature, annotations, parameterAnnotations, typeAnnotations, reflectParameters, accessorConstant));
        }
    }

    private static boolean isTrustedFinal(Field field) {
        if (JavaVersionUtil.JAVA_SPEC < 17) {
            return false;
        }
        try {
            return (Boolean)isFieldTrustedFinal.invoke((Object)field, new Object[0]);
        }
        catch (IllegalAccessException | InvocationTargetException e) {
            throw GraalError.shouldNotReachHere((Throwable)e);
        }
    }

    @Override
    public void addHeapAccessibleObjectMetadata(MetaAccessProvider metaAccess, AccessibleObject object, boolean registered) {
        ReflectionMetadata.AccessibleObjectMetadata metadata;
        boolean isExecutable = object instanceof Executable;
        boolean isMethod = object instanceof Method;
        Annotation[] annotations = GuardedAnnotationAccess.getDeclaredAnnotations((AnnotatedElement)object);
        Annotation[][] parameterAnnotations = isExecutable ? ((Executable)object).getParameterAnnotations() : null;
        Object annotationDefault = isMethod ? ((Method)object).getDefaultValue() : null;
        TypeAnnotation[] typeAnnotations = ReflectionMetadataEncoderImpl.getTypeAnnotations(object);
        ReflectionMetadata.ReflectParameterMetadata[] reflectParameters = isExecutable ? ReflectionMetadataEncoderImpl.getReflectParameters((Executable)object) : null;
        annotations = this.registerAnnotationValues(metaAccess, annotations);
        typeAnnotations = this.registerTypeAnnotationValues(metaAccess, typeAnnotations);
        if (isExecutable) {
            for (int i = 0; i < parameterAnnotations.length; ++i) {
                parameterAnnotations[i] = this.registerAnnotationValues(metaAccess, parameterAnnotations[i]);
            }
            if (isMethod && annotationDefault != null) {
                this.registerAnnotationValue(ReflectionMetadataEncoderImpl.getAnnotationEncodingType(annotationDefault), annotationDefault);
            }
            if (reflectParameters != null) {
                for (ReflectionMetadata.ReflectParameterMetadata parameter : reflectParameters) {
                    this.encoders.sourceMethodNames.addObject((Object)parameter.name);
                }
            }
        }
        AccessibleObject holder = ReflectionMetadataEncoderImpl.getHolder(object);
        JavaConstant heapObjectConstant = SubstrateObjectConstant.forObject(holder);
        this.encoders.objectConstants.addObject((Object)heapObjectConstant);
        if (isMethod) {
            metadata = new ReflectionMetadata.MethodMetadata(registered, heapObjectConstant, annotations, parameterAnnotations, annotationDefault, typeAnnotations, reflectParameters);
            this.registerMethod((HostedType)metaAccess.lookupJavaType(((Method)object).getDeclaringClass()), holder, (ReflectionMetadata.MethodMetadata)metadata);
        } else if (isExecutable) {
            metadata = new ReflectionMetadata.ConstructorMetadata(registered, heapObjectConstant, annotations, parameterAnnotations, typeAnnotations, reflectParameters);
            this.registerConstructor((HostedType)metaAccess.lookupJavaType(((Constructor)object).getDeclaringClass()), holder, (ReflectionMetadata.ConstructorMetadata)metadata);
        } else {
            metadata = new ReflectionMetadata.FieldMetadata(registered, heapObjectConstant, annotations, typeAnnotations);
            this.registerField((HostedType)metaAccess.lookupJavaType(((Field)object).getDeclaringClass()), holder, (ReflectionMetadata.FieldMetadata)metadata);
        }
        this.heapData.add(metadata);
    }

    private static AccessibleObject getHolder(AccessibleObject accessibleObject) {
        try {
            AccessibleObject root = (AccessibleObject)getRoot.invoke((Object)accessibleObject, new Object[0]);
            return root == null ? accessibleObject : root;
        }
        catch (IllegalAccessException | InvocationTargetException e) {
            throw GraalError.shouldNotReachHere((Throwable)e);
        }
    }

    static TypeAnnotation[] getTypeAnnotations(AnnotatedElement annotatedElement) {
        try {
            return (TypeAnnotation[])parseAllTypeAnnotations.invoke(null, annotatedElement);
        }
        catch (IllegalAccessException | InvocationTargetException e) {
            throw GraalError.shouldNotReachHere((Throwable)e);
        }
    }

    private HostedType[] registerClassValues(MetaAccessProvider metaAccess, Class<?>[] classes) {
        HashSet<HostedType> includedClasses = new HashSet<HostedType>();
        for (Class<?> clazz : classes) {
            HostedType type;
            try {
                type = ((HostedMetaAccess)metaAccess).optionalLookupJavaType(clazz).orElse(null);
            }
            catch (DeletedElementException e) {
                type = null;
            }
            if (type == null || !type.getWrapped().isReachable()) continue;
            this.encoders.sourceClasses.addObject(type.getJavaClass());
            includedClasses.add(type);
        }
        return includedClasses.toArray(new HostedType[0]);
    }

    private Annotation[] registerAnnotationValues(MetaAccessProvider metaAccess, Annotation ... annotations) {
        HashSet<Annotation> includedAnnotations = new HashSet<Annotation>();
        for (Annotation annotation : annotations) {
            if (annotation == null || !this.registerAnnotation(metaAccess, annotation)) continue;
            includedAnnotations.add(annotation);
        }
        return includedAnnotations.toArray(new Annotation[0]);
    }

    private TypeAnnotation[] registerTypeAnnotationValues(MetaAccessProvider metaAccess, TypeAnnotation ... typeAnnotations) {
        HashSet<TypeAnnotation> includedTypeAnnotations = new HashSet<TypeAnnotation>();
        for (TypeAnnotation typeAnnotation : typeAnnotations) {
            Annotation annotation = typeAnnotation.getAnnotation();
            if (annotation == null || !this.registerAnnotation(metaAccess, annotation)) continue;
            includedTypeAnnotations.add(typeAnnotation);
        }
        return includedTypeAnnotations.toArray(new TypeAnnotation[0]);
    }

    private boolean registerAnnotation(MetaAccessProvider metaAccess, Annotation annotation) {
        HostedType annotationType = ((HostedMetaAccess)metaAccess).optionalLookupJavaType(annotation.annotationType()).orElse(null);
        if (annotationType != null && annotationType.getWrapped().isReachable()) {
            this.encoders.sourceClasses.addObject(annotation.annotationType());
            this.registerAnnotationValue(annotation.annotationType(), annotation);
            return true;
        }
        return false;
    }

    private void registerAnnotationValue(Class<?> type, Object value) {
        if (type.isAnnotation()) {
            Annotation annotation = (Annotation)value;
            AnnotationType annotationType = AnnotationType.getInstance(type);
            this.encoders.sourceClasses.addObject(type);
            for (Map.Entry<String, Class<?>> entry : annotationType.memberTypes().entrySet()) {
                String valueName = entry.getKey();
                Class<?> valueType = entry.getValue();
                this.encoders.sourceMethodNames.addObject((Object)valueName);
                Method getAnnotationValue = annotationType.members().get(valueName);
                getAnnotationValue.setAccessible(true);
                try {
                    Object annotationValue = getAnnotationValue.invoke((Object)annotation, new Object[0]);
                    this.registerAnnotationValue(valueType, annotationValue);
                }
                catch (IllegalAccessException e) {
                    throw GraalError.shouldNotReachHere((Throwable)e);
                }
                catch (InvocationTargetException e) {
                    ExceptionProxy exceptionProxy;
                    Throwable targetException = e.getTargetException();
                    if (targetException instanceof TypeNotPresentException) {
                        exceptionProxy = new TypeNotPresentExceptionProxy(((TypeNotPresentException)targetException).typeName(), targetException.getCause());
                    } else if (targetException instanceof EnumConstantNotPresentException) {
                        EnumConstantNotPresentException enumException = (EnumConstantNotPresentException)targetException;
                        exceptionProxy = new EnumConstantNotPresentExceptionProxy(enumException.enumType(), enumException.constantName());
                    } else {
                        throw GraalError.shouldNotReachHere((Throwable)e);
                    }
                    JavaConstant javaConstant = this.annotationExceptionProxies.computeIfAbsent((Pair<Annotation, String>)Pair.create((Object)annotation, (Object)valueName), ignored -> SubstrateObjectConstant.forObject(exceptionProxy));
                    this.encoders.objectConstants.addObject((Object)javaConstant);
                }
            }
        } else if (type.isArray()) {
            Class<?> componentType = type.getComponentType();
            if (!componentType.isPrimitive()) {
                for (Object val : (Object[])value) {
                    this.registerAnnotationValue(componentType, val);
                }
            }
        } else if (type == Class.class) {
            this.encoders.sourceClasses.addObject((Object)((Class)value));
        } else if (type == String.class) {
            this.encoders.sourceMethodNames.addObject((Object)((String)value));
        } else if (type.isEnum()) {
            this.encoders.sourceClasses.addObject(type);
            this.encoders.sourceMethodNames.addObject((Object)((Enum)value).name());
        }
    }

    @Override
    public void addHidingFieldMetadata(AnalysisField analysisField, HostedType declaringType, String name, HostedType type, int modifiers) {
        this.encoders.sourceMethodNames.addObject((Object)name);
        this.encoders.sourceClasses.addObject(type.getJavaClass());
        this.sortedTypes.add(declaringType);
        this.registerField(declaringType, analysisField, new ReflectionMetadata.FieldMetadata(declaringType, name, type, modifiers));
    }

    @Override
    public void addHidingMethodMetadata(AnalysisMethod analysisMethod, HostedType declaringType, String name, HostedType[] parameterTypes, int modifiers, HostedType returnType) {
        this.encoders.sourceMethodNames.addObject((Object)name);
        for (HostedType parameterType : parameterTypes) {
            this.encoders.sourceClasses.addObject(parameterType.getJavaClass());
        }
        this.encoders.sourceClasses.addObject(returnType.getJavaClass());
        this.sortedTypes.add(declaringType);
        this.registerMethod(declaringType, analysisMethod, new ReflectionMetadata.MethodMetadata(declaringType, name, parameterTypes, modifiers, returnType));
    }

    @Override
    public void addReachableFieldMetadata(HostedField field) {
        HostedType declaringType = field.getDeclaringClass();
        String name = field.getName();
        this.encoders.sourceMethodNames.addObject((Object)name);
        this.registerField(declaringType, field, new ReflectionMetadata.FieldMetadata(declaringType, name));
    }

    @Override
    public void addReachableExecutableMetadata(HostedMethod executable) {
        boolean isMethod = !executable.isConstructor();
        HostedType declaringType = executable.getDeclaringClass();
        String name = isMethod ? executable.getName() : null;
        HostedType[] parameterTypes = ReflectionMetadataEncoderImpl.getParameterTypes(executable);
        if (isMethod) {
            this.encoders.sourceMethodNames.addObject((Object)name);
        }
        for (HostedType parameterType : parameterTypes) {
            this.encoders.sourceClasses.addObject(parameterType.getJavaClass());
        }
        if (isMethod) {
            this.registerMethod(declaringType, executable, new ReflectionMetadata.MethodMetadata(declaringType, name, parameterTypes));
        } else {
            this.registerConstructor(declaringType, executable, new ReflectionMetadata.ConstructorMetadata(declaringType, parameterTypes));
        }
    }

    private static HostedType[] getParameterTypes(HostedMethod method) {
        HostedType[] parameterTypes = new HostedType[method.getSignature().getParameterCount(false)];
        for (int i = 0; i < parameterTypes.length; ++i) {
            parameterTypes[i] = (HostedType)method.getSignature().getParameterType(i, null);
        }
        return parameterTypes;
    }

    private static HostedType[] getExceptionTypes(MetaAccessProvider metaAccess, Executable reflectMethod) {
        Class<?>[] exceptionClasses = reflectMethod.getExceptionTypes();
        HostedType[] exceptionTypes = new HostedType[exceptionClasses.length];
        for (int i = 0; i < exceptionClasses.length; ++i) {
            exceptionTypes[i] = (HostedType)metaAccess.lookupJavaType(exceptionClasses[i]);
        }
        return exceptionTypes;
    }

    private static ReflectionMetadata.ReflectParameterMetadata[] getReflectParameters(Executable reflectMethod) {
        Parameter[] rawParameters = ReflectionMetadataEncoderImpl.getRawParameters(reflectMethod);
        if (rawParameters == null) {
            return null;
        }
        ReflectionMetadata.ReflectParameterMetadata[] reflectParameters = new ReflectionMetadata.ReflectParameterMetadata[rawParameters.length];
        for (int i = 0; i < rawParameters.length; ++i) {
            reflectParameters[i] = new ReflectionMetadata.ReflectParameterMetadata(rawParameters[i].getName(), rawParameters[i].getModifiers());
        }
        return reflectParameters;
    }

    private ReflectionMetadata.RecordComponentMetadata[] getRecordComponents(MetaAccessProvider metaAccess, HostedType declaringType, Class<?> clazz) {
        Object[] recordComponents = ((RuntimeReflectionSupport)ImageSingletons.lookup(RuntimeReflectionSupport.class)).getRecordComponents(clazz);
        if (recordComponents == null) {
            return null;
        }
        ReflectionMetadata.RecordComponentMetadata[] metadata = new ReflectionMetadata.RecordComponentMetadata[recordComponents.length];
        for (int i = 0; i < recordComponents.length; ++i) {
            Object recordComponent = recordComponents[i];
            String name = ReflectionMetadataEncoderImpl.getRecordComponentName(recordComponent);
            HostedType type = (HostedType)metaAccess.lookupJavaType(ReflectionMetadataEncoderImpl.getRecordComponentType(recordComponent));
            String signature = ReflectionMetadataEncoderImpl.getRecordComponentSignature(recordComponent);
            Method accessor = ReflectionMetadataEncoderImpl.getRecordComponentAccessor(recordComponent);
            Annotation[] annotations = GuardedAnnotationAccess.getDeclaredAnnotations((AnnotatedElement)((AnnotatedElement)recordComponent));
            TypeAnnotation[] typeAnnotations = ReflectionMetadataEncoderImpl.getTypeAnnotations((AnnotatedElement)recordComponent);
            this.encoders.sourceMethodNames.addObject((Object)name);
            this.encoders.sourceClasses.addObject(type.getJavaClass());
            this.encoders.sourceMethodNames.addObject((Object)signature);
            annotations = this.registerAnnotationValues(metaAccess, annotations);
            typeAnnotations = this.registerTypeAnnotationValues(metaAccess, typeAnnotations);
            JavaConstant accessorConstant = null;
            if (accessor != null) {
                accessorConstant = SubstrateObjectConstant.forObject(accessor);
                this.encoders.objectConstants.addObject((Object)accessorConstant);
            }
            metadata[i] = new ReflectionMetadata.RecordComponentMetadata(declaringType, name, type, signature, accessorConstant, annotations, typeAnnotations);
        }
        return metadata;
    }

    private static String getRecordComponentName(Object recordComponent) {
        try {
            return (String)getRecordComponentName.invoke(recordComponent, new Object[0]);
        }
        catch (IllegalAccessException | InvocationTargetException e) {
            throw GraalError.shouldNotReachHere((Throwable)e);
        }
    }

    private static Class<?> getRecordComponentType(Object recordComponent) {
        try {
            return (Class)getRecordComponentType.invoke(recordComponent, new Object[0]);
        }
        catch (IllegalAccessException | InvocationTargetException e) {
            throw GraalError.shouldNotReachHere((Throwable)e);
        }
    }

    private static String getRecordComponentSignature(Object recordComponent) {
        try {
            return (String)getRecordComponentSignature.invoke(recordComponent, new Object[0]);
        }
        catch (IllegalAccessException | InvocationTargetException e) {
            throw GraalError.shouldNotReachHere((Throwable)e);
        }
    }

    private static Method getRecordComponentAccessor(Object recordComponent) {
        try {
            return (Method)getRecordComponentAccessor.invoke(recordComponent, new Object[0]);
        }
        catch (IllegalAccessException | InvocationTargetException e) {
            throw GraalError.shouldNotReachHere((Throwable)e);
        }
    }

    @Override
    public void encodeAllAndInstall() {
        UnsafeArrayTypeWriter buf = UnsafeArrayTypeWriter.create((boolean)ByteArrayReader.supportsUnalignedMemoryAccess());
        int typesIndex = ReflectionMetadataEncoderImpl.encodeAndAddCollection(buf, this.sortedTypes.toArray(new HostedType[0]), this::encodeType, false);
        assert (typesIndex == 0);
        for (HostedType declaringType : this.sortedTypes) {
            int recordComponentsIndex;
            int permittedSubclassesIndex;
            DynamicHub hub = declaringType.getHub();
            ReflectionMetadata.ClassMetadata classMetadata = this.classData.get(declaringType);
            int enclosingMethodInfoIndex = ReflectionMetadataEncoderImpl.encodeAndAddElement(buf, classMetadata.enclosingMethodInfo, this::encodeEnclosingMethod);
            int annotationsIndex = ReflectionMetadataEncoderImpl.encodeAndAddEncodedElement(buf, classMetadata.annotations, this::encodeAnnotations);
            int typeAnnotationsIndex = ReflectionMetadataEncoderImpl.encodeAndAddEncodedElement(buf, classMetadata.typeAnnotations, this::encodeTypeAnnotations);
            int classesEncodingIndex = ReflectionMetadataEncoderImpl.encodeAndAddCollection(buf, classMetadata.classes, this::encodeType, false);
            int n = permittedSubclassesIndex = JavaVersionUtil.JAVA_SPEC >= 17 ? ReflectionMetadataEncoderImpl.encodeAndAddCollection(buf, classMetadata.permittedSubclasses, this::encodeType, true) : -1;
            if (ReflectionMetadataEncoderImpl.anySet(enclosingMethodInfoIndex, annotationsIndex, typeAnnotationsIndex, classesEncodingIndex, permittedSubclassesIndex)) {
                hub.setHubMetadata(enclosingMethodInfoIndex, annotationsIndex, typeAnnotationsIndex, classesEncodingIndex, permittedSubclassesIndex);
            }
            int fieldsIndex = ReflectionMetadataEncoderImpl.encodeAndAddCollection(buf, this.getFields(declaringType), this::encodeField, false);
            int methodsIndex = ReflectionMetadataEncoderImpl.encodeAndAddCollection(buf, this.getMethods(declaringType), this::encodeExecutable, false);
            int constructorsIndex = ReflectionMetadataEncoderImpl.encodeAndAddCollection(buf, this.getConstructors(declaringType), this::encodeExecutable, false);
            int n2 = recordComponentsIndex = JavaVersionUtil.JAVA_SPEC >= 17 ? ReflectionMetadataEncoderImpl.encodeAndAddCollection(buf, classMetadata.recordComponents, this::encodeRecordComponent, true) : -1;
            if (!ReflectionMetadataEncoderImpl.anySet(fieldsIndex, methodsIndex, constructorsIndex, recordComponentsIndex)) continue;
            hub.setReflectionMetadata(fieldsIndex, methodsIndex, constructorsIndex, recordComponentsIndex);
        }
        for (ReflectionMetadata.AccessibleObjectMetadata metadata : this.heapData) {
            AccessibleObject heapObject = (AccessibleObject)SubstrateObjectConstant.asObject((Constant)metadata.heapObject);
            this.annotationsEncodings.put(heapObject, this.encodeAnnotations(metadata.annotations));
            this.typeAnnotationsEncodings.put(heapObject, this.encodeTypeAnnotations(metadata.typeAnnotations));
            if (!(metadata instanceof ReflectionMetadata.ExecutableMetadata)) continue;
            this.parameterAnnotationsEncodings.put((Executable)heapObject, this.encodeParameterAnnotations(((ReflectionMetadata.ExecutableMetadata)metadata).parameterAnnotations));
            if (((ReflectionMetadata.ExecutableMetadata)metadata).reflectParameters != null) {
                this.reflectParametersEncodings.put((Executable)heapObject, this.encodeReflectParameters(((ReflectionMetadata.ExecutableMetadata)metadata).reflectParameters));
            }
            if (!(metadata instanceof ReflectionMetadata.MethodMetadata) || !((Method)SubstrateObjectConstant.asObject((Constant)metadata.heapObject)).getDeclaringClass().isAnnotation() || ((ReflectionMetadata.MethodMetadata)metadata).annotationDefault == null) continue;
            this.annotationDefaultEncodings.put((Method)heapObject, this.encodeMemberValue(((ReflectionMetadata.MethodMetadata)metadata).annotationDefault));
        }
        ReflectionMetadataEncoderImpl.install(buf);
        ImageSingletons.add(NativeImageCodeCache.ReflectionMetadataEncoder.class, (Object)this);
    }

    private static <T> int encodeAndAddCollection(UnsafeArrayTypeWriter buf, T[] data, BiConsumer<UnsafeArrayTypeWriter, T> encodeCallback, boolean canBeNull) {
        if (data == null || !canBeNull && data.length == 0) {
            return -1;
        }
        int offset = TypeConversion.asS4((long)buf.getBytesWritten());
        ReflectionMetadataEncoderImpl.encodeArray(buf, data, element -> encodeCallback.accept(buf, element));
        return offset;
    }

    private static <T> int encodeAndAddElement(UnsafeArrayTypeWriter buf, T data, Function<T, byte[]> encodeCallback) {
        byte[] encoding = encodeCallback.apply(data);
        if (encoding == null) {
            return -1;
        }
        int offset = TypeConversion.asS4((long)buf.getBytesWritten());
        ReflectionMetadataEncoderImpl.encodeBytes(buf, encoding);
        return offset;
    }

    private static <T> int encodeAndAddEncodedElement(UnsafeArrayTypeWriter buf, T data, Function<T, byte[]> encodeCallback) {
        byte[] encoding = encodeCallback.apply(data);
        if (encoding == null) {
            return -1;
        }
        int offset = TypeConversion.asS4((long)buf.getBytesWritten());
        ReflectionMetadataEncoderImpl.encodeByteArray(buf, encoding);
        return offset;
    }

    private static void install(UnsafeArrayTypeWriter encodingBuffer) {
        int encodingSize = TypeConversion.asS4((long)encodingBuffer.getBytesWritten());
        byte[] dataEncoding = new byte[encodingSize];
        ((ReflectionMetadataEncoding)ImageSingletons.lookup(ReflectionMetadataEncoding.class)).setEncoding(encodingBuffer.toArray(dataEncoding));
    }

    private static boolean anySet(int ... indices) {
        for (int index : indices) {
            if (index == -1) continue;
            return true;
        }
        return false;
    }

    private void encodeField(UnsafeArrayTypeWriter buf, ReflectionMetadata.FieldMetadata field) {
        assert ((field.modifiers & 0xE0000000) == 0);
        int modifiers = field.modifiers;
        modifiers |= field.complete ? Integer.MIN_VALUE : 0;
        modifiers |= field.heapObject != null ? 0x40000000 : 0;
        buf.putUV((long)(modifiers |= field.hiding ? 0x20000000 : 0));
        if (field.heapObject != null) {
            this.encodeObject(buf, field.heapObject);
        } else {
            this.encodeName(buf, field.name);
            if (field.complete || field.hiding) {
                this.encodeType(buf, field.type);
            }
            if (field.complete) {
                if (JavaVersionUtil.JAVA_SPEC >= 17) {
                    buf.putU1(field.trustedFinal ? 1L : 0L);
                }
                this.encodeName(buf, field.signature);
                ReflectionMetadataEncoderImpl.encodeByteArray(buf, this.encodeAnnotations(field.annotations));
                ReflectionMetadataEncoderImpl.encodeByteArray(buf, this.encodeTypeAnnotations(field.typeAnnotations));
                buf.putSV((long)field.offset);
                this.encodeName(buf, field.deletedReason);
            }
        }
    }

    private void encodeExecutable(UnsafeArrayTypeWriter buf, ReflectionMetadata.ExecutableMetadata executable) {
        boolean isHiding;
        boolean isMethod = executable instanceof ReflectionMetadata.MethodMetadata;
        boolean bl = isHiding = isMethod && ((ReflectionMetadata.MethodMetadata)executable).hiding;
        assert ((executable.modifiers & 0xE0000000) == 0);
        int modifiers = executable.modifiers;
        modifiers |= executable.complete ? Integer.MIN_VALUE : 0;
        modifiers |= executable.heapObject != null ? 0x40000000 : 0;
        buf.putUV((long)(modifiers |= isHiding ? 0x20000000 : 0));
        if (executable.heapObject != null) {
            this.encodeObject(buf, executable.heapObject);
        } else {
            if (isMethod) {
                this.encodeName(buf, ((ReflectionMetadata.MethodMetadata)executable).name);
            }
            ReflectionMetadataEncoderImpl.encodeArray(buf, executable.parameterTypes, parameterType -> this.encodeType(buf, (HostedType)parameterType));
            if (isMethod && (executable.complete || isHiding)) {
                this.encodeType(buf, ((ReflectionMetadata.MethodMetadata)executable).returnType);
            }
            if (executable.complete) {
                ReflectionMetadataEncoderImpl.encodeArray(buf, executable.exceptionTypes, exceptionType -> this.encodeType(buf, (HostedType)exceptionType));
                this.encodeName(buf, executable.signature);
                ReflectionMetadataEncoderImpl.encodeByteArray(buf, this.encodeAnnotations(executable.annotations));
                ReflectionMetadataEncoderImpl.encodeByteArray(buf, this.encodeParameterAnnotations(executable.parameterAnnotations));
                if (isMethod && executable.declaringType.getHub().getHostedJavaClass().isAnnotation()) {
                    ReflectionMetadataEncoderImpl.encodeByteArray(buf, this.encodeMemberValue(((ReflectionMetadata.MethodMetadata)executable).annotationDefault));
                } else assert (!isMethod || ((ReflectionMetadata.MethodMetadata)executable).annotationDefault == null);
                ReflectionMetadataEncoderImpl.encodeByteArray(buf, this.encodeTypeAnnotations(executable.typeAnnotations));
                ReflectionMetadataEncoderImpl.encodeByteArray(buf, this.encodeReflectParameters(executable.reflectParameters));
                this.encodeObject(buf, executable.accessor);
            }
        }
    }

    private void encodeType(UnsafeArrayTypeWriter buf, HostedType type) {
        buf.putSV((long)this.encoders.sourceClasses.getIndex(type.getJavaClass()));
    }

    private void encodeName(UnsafeArrayTypeWriter buf, String name) {
        buf.putSV((long)this.encoders.sourceMethodNames.getIndex((Object)name));
    }

    private void encodeObject(UnsafeArrayTypeWriter buf, JavaConstant object) {
        if (object == null) {
            buf.putSV(-1L);
        } else {
            buf.putSV((long)this.encoders.objectConstants.getIndex((Object)object));
        }
    }

    private static <T> void encodeArray(UnsafeArrayTypeWriter buf, T[] array, Consumer<T> elementEncoder) {
        buf.putUV((long)array.length);
        for (T elem : array) {
            elementEncoder.accept(elem);
        }
    }

    private static void encodeByteArray(UnsafeArrayTypeWriter buf, byte[] array) {
        if (array == null) {
            buf.putUV(-1L);
            return;
        }
        buf.putUV((long)array.length);
        ReflectionMetadataEncoderImpl.encodeBytes(buf, array);
    }

    private static void encodeBytes(UnsafeArrayTypeWriter buf, byte[] bytes) {
        for (byte b : bytes) {
            buf.putS1((long)b);
        }
    }

    private static String getSignature(Field field) {
        try {
            return (String)getFieldSignature.invoke((Object)field, new Object[0]);
        }
        catch (IllegalAccessException | InvocationTargetException e) {
            throw GraalError.shouldNotReachHere((Throwable)e);
        }
    }

    private static String getSignature(Executable executable) {
        try {
            return (String)(executable instanceof Method ? getMethodSignature.invoke((Object)executable, new Object[0]) : getConstructorSignature.invoke((Object)executable, new Object[0]));
        }
        catch (IllegalAccessException | InvocationTargetException e) {
            throw GraalError.shouldNotReachHere((Throwable)e);
        }
    }

    private static Parameter[] getRawParameters(Executable executable) {
        try {
            return (Parameter[])getExecutableParameters.invoke((Object)executable, new Object[0]);
        }
        catch (IllegalAccessException | InvocationTargetException e) {
            throw GraalError.shouldNotReachHere((Throwable)e);
        }
    }

    public byte[] encodeAnnotations(Annotation[] annotations) {
        if (annotations.length == 0) {
            return null;
        }
        UnsafeArrayTypeWriter buf = UnsafeArrayTypeWriter.create((boolean)ByteArrayReader.supportsUnalignedMemoryAccess(), (boolean)true);
        buf.putU2((long)annotations.length);
        for (Annotation annotation : annotations) {
            this.encodeAnnotation(buf, annotation);
        }
        return buf.toArray();
    }

    private byte[] encodeParameterAnnotations(Annotation[][] annotations) {
        if (!ReflectionMetadataEncoderImpl.hasAnnotation(annotations)) {
            return null;
        }
        UnsafeArrayTypeWriter buf = UnsafeArrayTypeWriter.create((boolean)ByteArrayReader.supportsUnalignedMemoryAccess(), (boolean)true);
        buf.putU1((long)annotations.length);
        for (Annotation[] parameterAnnotations : annotations) {
            buf.putU2((long)parameterAnnotations.length);
            for (Annotation parameterAnnotation : parameterAnnotations) {
                this.encodeAnnotation(buf, parameterAnnotation);
            }
        }
        return buf.toArray();
    }

    private static boolean hasAnnotation(Annotation[][] parameterAnnotations) {
        for (Annotation[] annotations : parameterAnnotations) {
            if (annotations.length == 0) continue;
            return true;
        }
        return false;
    }

    private void encodeAnnotation(UnsafeArrayTypeWriter buf, Annotation annotation) {
        buf.putS4((long)this.encoders.sourceClasses.getIndex(annotation.annotationType()));
        AnnotationType type = AnnotationType.getInstance(annotation.annotationType());
        buf.putU2((long)type.members().size());
        for (String memberName : ReflectionMetadataEncoderImpl.orderedAnnotationMemberNames(annotation)) {
            Method valueAccessor = type.members().get(memberName);
            buf.putS4((long)this.encoders.sourceMethodNames.getIndex((Object)memberName));
            try {
                this.encodeValue(buf, valueAccessor.invoke((Object)annotation, new Object[0]), type.memberTypes().get(memberName));
            }
            catch (InvocationTargetException e) {
                this.encodeValue(buf, this.annotationExceptionProxies.get(Pair.create((Object)annotation, (Object)memberName)), Throwable.class);
            }
            catch (IllegalAccessException e) {
                throw GraalError.shouldNotReachHere((Throwable)e);
            }
        }
    }

    private static Set<String> orderedAnnotationMemberNames(Annotation annotation) {
        try {
            Map memberValues = (Map)annotationInvocationHandlerMemberValues.get(Proxy.getInvocationHandler(annotation));
            return memberValues.keySet();
        }
        catch (IllegalAccessException e) {
            throw GraalError.shouldNotReachHere();
        }
    }

    private byte[] encodeMemberValue(Object value) {
        if (value == null) {
            return null;
        }
        UnsafeArrayTypeWriter buf = UnsafeArrayTypeWriter.create((boolean)ByteArrayReader.supportsUnalignedMemoryAccess(), (boolean)true);
        this.encodeValue(buf, value, ReflectionMetadataEncoderImpl.getAnnotationEncodingType(value));
        return buf.toArray();
    }

    private void encodeValue(UnsafeArrayTypeWriter buf, Object value, Class<?> type) {
        buf.putU1((long)ReflectionMetadataEncoderImpl.tag(type));
        if (type.isAnnotation()) {
            this.encodeAnnotation(buf, (Annotation)value);
        } else if (type.isEnum()) {
            buf.putS4((long)this.encoders.sourceClasses.getIndex(type));
            buf.putS4((long)this.encoders.sourceMethodNames.getIndex((Object)((Enum)value).name()));
        } else if (type.isArray()) {
            this.encodeArray(buf, value, type.getComponentType());
        } else if (type == Class.class) {
            buf.putS4((long)this.encoders.sourceClasses.getIndex((Object)((Class)value)));
        } else if (type == String.class) {
            buf.putS4((long)this.encoders.sourceMethodNames.getIndex((Object)((String)value)));
        } else if (type.isPrimitive() || Wrapper.isWrapperType(type)) {
            Wrapper wrapper = type.isPrimitive() ? Wrapper.forPrimitiveType(type) : Wrapper.forWrapperType(type);
            switch (wrapper) {
                case BOOLEAN: {
                    buf.putU1((Boolean)value != false ? 1L : 0L);
                    break;
                }
                case BYTE: {
                    buf.putS1((long)((Byte)value).byteValue());
                    break;
                }
                case SHORT: {
                    buf.putS2((long)((Short)value).shortValue());
                    break;
                }
                case CHAR: {
                    buf.putU2((long)((Character)value).charValue());
                    break;
                }
                case INT: {
                    buf.putS4((long)((Integer)value).intValue());
                    break;
                }
                case LONG: {
                    buf.putS8(((Long)value).longValue());
                    break;
                }
                case FLOAT: {
                    buf.putS4((long)Float.floatToRawIntBits(((Float)value).floatValue()));
                    break;
                }
                case DOUBLE: {
                    buf.putS8(Double.doubleToRawLongBits((Double)value));
                    break;
                }
                default: {
                    throw GraalError.shouldNotReachHere();
                }
            }
        } else if (type == Throwable.class) {
            buf.putS4((long)this.encoders.objectConstants.getIndex((Object)((JavaConstant)value)));
        } else {
            throw GraalError.shouldNotReachHere();
        }
    }

    private void encodeArray(UnsafeArrayTypeWriter buf, Object value, Class<?> componentType) {
        block10: {
            block17: {
                block16: {
                    block15: {
                        block14: {
                            block13: {
                                block12: {
                                    block11: {
                                        block9: {
                                            if (componentType.isPrimitive()) break block9;
                                            Object[] array = (Object[])value;
                                            buf.putU2((long)array.length);
                                            for (Object val : array) {
                                                this.encodeValue(buf, val, componentType);
                                            }
                                            break block10;
                                        }
                                        if (componentType != Boolean.TYPE) break block11;
                                        boolean[] array = (boolean[])value;
                                        buf.putU2((long)array.length);
                                        for (boolean val : array) {
                                            this.encodeValue(buf, val, componentType);
                                        }
                                        break block10;
                                    }
                                    if (componentType != Byte.TYPE) break block12;
                                    byte[] array = (byte[])value;
                                    buf.putU2((long)array.length);
                                    for (byte val : array) {
                                        this.encodeValue(buf, val, componentType);
                                    }
                                    break block10;
                                }
                                if (componentType != Short.TYPE) break block13;
                                short[] array = (short[])value;
                                buf.putU2((long)array.length);
                                for (short val : array) {
                                    this.encodeValue(buf, val, componentType);
                                }
                                break block10;
                            }
                            if (componentType != Character.TYPE) break block14;
                            char[] array = (char[])value;
                            buf.putU2((long)array.length);
                            for (char val : array) {
                                this.encodeValue(buf, Character.valueOf(val), componentType);
                            }
                            break block10;
                        }
                        if (componentType != Integer.TYPE) break block15;
                        int[] array = (int[])value;
                        buf.putU2((long)array.length);
                        for (int val : array) {
                            this.encodeValue(buf, val, componentType);
                        }
                        break block10;
                    }
                    if (componentType != Long.TYPE) break block16;
                    long[] array = (long[])value;
                    buf.putU2((long)array.length);
                    for (long val : array) {
                        this.encodeValue(buf, val, componentType);
                    }
                    break block10;
                }
                if (componentType != Float.TYPE) break block17;
                float[] array = (float[])value;
                buf.putU2((long)array.length);
                for (float val : array) {
                    this.encodeValue(buf, Float.valueOf(val), componentType);
                }
                break block10;
            }
            if (componentType != Double.TYPE) break block10;
            double[] array = (double[])value;
            buf.putU2((long)array.length);
            for (double val : array) {
                this.encodeValue(buf, val, componentType);
            }
        }
    }

    private static byte tag(Class<?> type) {
        if (type.isAnnotation()) {
            return 64;
        }
        if (type.isEnum()) {
            return 101;
        }
        if (type.isArray()) {
            return 91;
        }
        if (type == Class.class) {
            return 99;
        }
        if (type == String.class) {
            return 115;
        }
        if (type.isPrimitive()) {
            return (byte)Wrapper.forPrimitiveType(type).basicTypeChar();
        }
        if (Wrapper.isWrapperType(type)) {
            return (byte)Wrapper.forWrapperType(type).basicTypeChar();
        }
        if (type == Throwable.class) {
            return 69;
        }
        throw GraalError.shouldNotReachHere((String)type.toString());
    }

    static Class<?> getAnnotationEncodingType(Object value) {
        Class<Object> type = value.getClass();
        if (Proxy.isProxyClass(type)) {
            assert (type.getInterfaces().length == 1);
            type = type.getInterfaces()[0];
        } else if (value instanceof Enum) {
            type = ((Enum)value).getDeclaringClass();
        }
        return type;
    }

    private byte[] encodeTypeAnnotations(TypeAnnotation[] annotations) {
        if (annotations.length == 0) {
            return null;
        }
        UnsafeArrayTypeWriter buf = UnsafeArrayTypeWriter.create((boolean)ByteArrayReader.supportsUnalignedMemoryAccess(), (boolean)true);
        buf.putU2((long)annotations.length);
        for (TypeAnnotation typeAnnotation : annotations) {
            this.encodeTypeAnnotation(buf, typeAnnotation);
        }
        return buf.toArray();
    }

    private void encodeTypeAnnotation(UnsafeArrayTypeWriter buf, TypeAnnotation typeAnnotation) {
        ReflectionMetadataEncoderImpl.encodeTargetInfo(buf, typeAnnotation.getTargetInfo());
        ReflectionMetadataEncoderImpl.encodeLocationInfo(buf, typeAnnotation.getLocationInfo());
        this.encodeAnnotation(buf, typeAnnotation.getAnnotation());
    }

    private static void encodeTargetInfo(UnsafeArrayTypeWriter buf, TypeAnnotation.TypeAnnotationTargetInfo targetInfo) {
        switch (targetInfo.getTarget()) {
            case CLASS_TYPE_PARAMETER: {
                buf.putU1(0L);
                buf.putU1((long)targetInfo.getCount());
                break;
            }
            case METHOD_TYPE_PARAMETER: {
                buf.putU1(1L);
                buf.putU1((long)targetInfo.getCount());
                break;
            }
            case CLASS_EXTENDS: {
                buf.putU1(16L);
                buf.putS2(-1L);
                break;
            }
            case CLASS_IMPLEMENTS: {
                buf.putU1(16L);
                buf.putS2((long)targetInfo.getCount());
                break;
            }
            case CLASS_TYPE_PARAMETER_BOUND: {
                buf.putU1(17L);
                buf.putU1((long)targetInfo.getCount());
                buf.putU1((long)targetInfo.getSecondaryIndex());
                break;
            }
            case METHOD_TYPE_PARAMETER_BOUND: {
                buf.putU1(18L);
                buf.putU1((long)targetInfo.getCount());
                buf.putU1((long)targetInfo.getSecondaryIndex());
                break;
            }
            case FIELD: {
                buf.putU1(19L);
                break;
            }
            case METHOD_RETURN: {
                buf.putU1(20L);
                break;
            }
            case METHOD_RECEIVER: {
                buf.putU1(21L);
                break;
            }
            case METHOD_FORMAL_PARAMETER: {
                buf.putU1(22L);
                buf.putU1((long)targetInfo.getCount());
                break;
            }
            case THROWS: {
                buf.putU1(23L);
                buf.putU2((long)targetInfo.getCount());
                break;
            }
            default: {
                throw GraalError.shouldNotReachHere((String)("Unknown type annotation target: " + targetInfo.getTarget()));
            }
        }
    }

    private static void encodeLocationInfo(UnsafeArrayTypeWriter buf, TypeAnnotation.LocationInfo locationInfo) {
        try {
            TypeAnnotation.LocationInfo.Location[] locations;
            int depth = (Integer)locationInfoDepth.get(locationInfo);
            buf.putU1((long)depth);
            for (TypeAnnotation.LocationInfo.Location location : locations = (TypeAnnotation.LocationInfo.Location[])locationInfoLocations.get(locationInfo)) {
                buf.putS1((long)location.tag);
                buf.putU1((long)location.index);
            }
        }
        catch (IllegalAccessException e) {
            throw GraalError.shouldNotReachHere((Throwable)e);
        }
    }

    private byte[] encodeReflectParameters(ReflectionMetadata.ReflectParameterMetadata[] reflectParameters) {
        if (reflectParameters == null) {
            return null;
        }
        UnsafeArrayTypeWriter buf = UnsafeArrayTypeWriter.create((boolean)ByteArrayReader.supportsUnalignedMemoryAccess());
        ReflectionMetadataEncoderImpl.encodeArray(buf, reflectParameters, reflectParameter -> this.encodeReflectParameter(buf, (ReflectionMetadata.ReflectParameterMetadata)reflectParameter));
        return buf.toArray();
    }

    private void encodeReflectParameter(UnsafeArrayTypeWriter buf, ReflectionMetadata.ReflectParameterMetadata reflectParameter) {
        this.encodeName(buf, reflectParameter.name);
        buf.putUV((long)reflectParameter.modifiers);
    }

    private void encodeRecordComponent(UnsafeArrayTypeWriter buf, ReflectionMetadata.RecordComponentMetadata recordComponent) {
        this.encodeName(buf, recordComponent.name);
        this.encodeType(buf, recordComponent.type);
        this.encodeName(buf, recordComponent.signature);
        this.encodeObject(buf, recordComponent.accessor);
        ReflectionMetadataEncoderImpl.encodeByteArray(buf, this.encodeAnnotations(recordComponent.annotations));
        ReflectionMetadataEncoderImpl.encodeByteArray(buf, this.encodeTypeAnnotations(recordComponent.typeAnnotations));
    }

    private byte[] encodeEnclosingMethod(Object[] enclosingMethodInfo) {
        if (enclosingMethodInfo == null) {
            return null;
        }
        assert (enclosingMethodInfo.length == 3);
        UnsafeArrayTypeWriter buf = UnsafeArrayTypeWriter.create((boolean)ByteArrayReader.supportsUnalignedMemoryAccess());
        this.encodeType(buf, (HostedType)enclosingMethodInfo[0]);
        this.encodeName(buf, (String)enclosingMethodInfo[1]);
        this.encodeName(buf, (String)enclosingMethodInfo[2]);
        return buf.toArray();
    }

    static {
        try {
            recordComponentClass = JavaVersionUtil.JAVA_SPEC >= 17 ? Class.forName("java.lang.reflect.RecordComponent") : null;
        }
        catch (ClassNotFoundException e) {
            throw VMError.shouldNotReachHere(e);
        }
        getRecordComponentName = JavaVersionUtil.JAVA_SPEC >= 17 ? ReflectionUtil.lookupMethod(recordComponentClass, (String)"getName", (Class[])new Class[0]) : null;
        getRecordComponentType = JavaVersionUtil.JAVA_SPEC >= 17 ? ReflectionUtil.lookupMethod(recordComponentClass, (String)"getType", (Class[])new Class[0]) : null;
        getRecordComponentSignature = JavaVersionUtil.JAVA_SPEC >= 17 ? ReflectionUtil.lookupMethod(recordComponentClass, (String)"getGenericSignature", (Class[])new Class[0]) : null;
        getRecordComponentAccessor = JavaVersionUtil.JAVA_SPEC >= 17 ? ReflectionUtil.lookupMethod(recordComponentClass, (String)"getAccessor", (Class[])new Class[0]) : null;
        getFieldSignature = ReflectionUtil.lookupMethod(Field.class, (String)"getGenericSignature", (Class[])new Class[0]);
        getMethodSignature = ReflectionUtil.lookupMethod(Method.class, (String)"getGenericSignature", (Class[])new Class[0]);
        getConstructorSignature = ReflectionUtil.lookupMethod(Constructor.class, (String)"getSignature", (Class[])new Class[0]);
        getExecutableParameters = ReflectionUtil.lookupMethod(Executable.class, (String)"getParameters0", (Class[])new Class[0]);
        try {
            annotationInvocationHandlerMemberValues = ReflectionUtil.lookupField(Class.forName("sun.reflect.annotation.AnnotationInvocationHandler"), (String)"memberValues");
        }
        catch (ClassNotFoundException e) {
            throw GraalError.shouldNotReachHere();
        }
        locationInfoDepth = ReflectionUtil.lookupField(TypeAnnotation.LocationInfo.class, (String)"depth");
        locationInfoLocations = ReflectionUtil.lookupField(TypeAnnotation.LocationInfo.class, (String)"locations");
    }

    static final class ReflectionDataAccessors {
        private final Method privateGetDeclaredFields = ReflectionUtil.lookupMethod(Class.class, (String)"privateGetDeclaredFields", (Class[])new Class[]{Boolean.TYPE});
        private final Method privateGetDeclaredMethods = ReflectionUtil.lookupMethod(Class.class, (String)"privateGetDeclaredMethods", (Class[])new Class[]{Boolean.TYPE});
        private final Method privateGetDeclaredConstructors = ReflectionUtil.lookupMethod(Class.class, (String)"privateGetDeclaredConstructors", (Class[])new Class[]{Boolean.TYPE});

        ReflectionDataAccessors() {
        }

        Field[] getDeclaredFields(Object obj) {
            try {
                return (Field[])this.privateGetDeclaredFields.invoke(obj, false);
            }
            catch (IllegalAccessException | InvocationTargetException e) {
                return new Field[0];
            }
        }

        Method[] getDeclaredMethods(Object obj) {
            try {
                return (Method[])this.privateGetDeclaredMethods.invoke(obj, false);
            }
            catch (IllegalAccessException | InvocationTargetException e) {
                return new Method[0];
            }
        }

        Constructor<?>[] getDeclaredConstructors(Object obj) {
            try {
                return (Constructor[])this.privateGetDeclaredConstructors.invoke(obj, false);
            }
            catch (IllegalAccessException | InvocationTargetException e) {
                return new Constructor[0];
            }
        }
    }

    static class Factory
    implements NativeImageCodeCache.ReflectionMetadataEncoderFactory {
        Factory() {
        }

        @Override
        public NativeImageCodeCache.ReflectionMetadataEncoder create(CodeInfoEncoder.Encoders encoders) {
            return new ReflectionMetadataEncoderImpl(encoders);
        }
    }
}

