/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.svm.hosted.jdk;

import com.oracle.svm.core.annotate.AutomaticFeature;
import com.oracle.svm.hosted.FeatureImpl;
import com.oracle.svm.hosted.jdk.JNIRegistrationSupport;
import org.graalvm.nativeimage.Platform;
import org.graalvm.nativeimage.Platforms;
import org.graalvm.nativeimage.hosted.Feature;

@Platforms(value={Platform.WINDOWS.class})
@AutomaticFeature
public class JNIRegistrationAWTSupport
implements Feature {
    public void afterAnalysis(Feature.AfterAnalysisAccess access) {
        JNIRegistrationSupport jniRegistrationSupport = JNIRegistrationSupport.singleton();
        if (jniRegistrationSupport.isRegisteredLibrary("awt")) {
            jniRegistrationSupport.addJvmShimExports("JVM_CurrentTimeMillis", "JVM_RaiseSignal", "jio_snprintf");
            jniRegistrationSupport.addJavaShimExports("JDK_LoadSystemLibrary", "JNU_CallMethodByName", "JNU_CallMethodByNameV", "JNU_CallStaticMethodByName", "JNU_ClassString", "JNU_GetEnv", "JNU_GetFieldByName", "JNU_GetStaticFieldByName", "JNU_IsInstanceOfByName", "JNU_NewObjectByName", "JNU_NewStringPlatform", "JNU_SetFieldByName", "JNU_ThrowArrayIndexOutOfBoundsException", "JNU_ThrowByName", "JNU_ThrowIOException", "JNU_ThrowIllegalArgumentException", "JNU_ThrowInternalError", "JNU_ThrowNullPointerException", "JNU_ThrowOutOfMemoryError", "getEncodingFromLangID", "getJavaIDFromLangID");
        }
        if (jniRegistrationSupport.isRegisteredLibrary("javaaccessbridge")) {
            jniRegistrationSupport.registerLibrary("jawt");
        }
        if (jniRegistrationSupport.isRegisteredLibrary("javajpeg")) {
            jniRegistrationSupport.addJavaShimExports("JNU_GetEnv", "JNU_ThrowByName", "JNU_ThrowNullPointerException", "jio_snprintf");
        }
    }

    public void beforeImageWrite(Feature.BeforeImageWriteAccess access) {
        if (JNIRegistrationSupport.singleton().isRegisteredLibrary("awt")) {
            ((FeatureImpl.BeforeImageWriteAccessImpl)access).registerLinkerInvocationTransformer(linkerInvocation -> {
                linkerInvocation.addNativeLinkerOption("shell32.lib");
                return linkerInvocation;
            });
        }
    }
}

