/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.svm.hosted.code;

import com.oracle.svm.core.annotate.Uninterruptible;
import com.oracle.svm.core.option.HostedOptionKey;
import com.oracle.svm.core.util.UserError;
import com.oracle.svm.hosted.code.RestrictHeapAccessAnnotationChecker;
import com.oracle.svm.hosted.meta.HostedMethod;
import java.util.Collection;
import java.util.Set;
import java.util.TreeSet;
import jdk.vm.ci.meta.ResolvedJavaMethod;
import org.graalvm.compiler.graph.Node;
import org.graalvm.compiler.nodes.FrameState;
import org.graalvm.compiler.nodes.Invoke;
import org.graalvm.compiler.nodes.StructuredGraph;
import org.graalvm.nativeimage.ImageSingletons;
import org.graalvm.nativeimage.c.function.CFunction;
import org.graalvm.nativeimage.c.function.InvokeCFunctionPointer;

public final class UninterruptibleAnnotationChecker {
    private final Set<String> violations = new TreeSet<String>();

    private static UninterruptibleAnnotationChecker singleton() {
        return (UninterruptibleAnnotationChecker)ImageSingletons.lookup(UninterruptibleAnnotationChecker.class);
    }

    UninterruptibleAnnotationChecker() {
    }

    public static void checkAfterParsing(ResolvedJavaMethod method, StructuredGraph graph) {
        UninterruptibleAnnotationChecker.singleton().checkAllocations(method, graph);
    }

    public static void checkBeforeCompilation(Collection<HostedMethod> methods) {
        if (Options.PrintUninterruptibleCalleeDOTGraph.getValue().booleanValue()) {
            System.out.println("/* DOT */ digraph uninterruptible {");
        }
        UninterruptibleAnnotationChecker c = UninterruptibleAnnotationChecker.singleton();
        for (HostedMethod method : methods) {
            Uninterruptible annotation = method.getAnnotation(Uninterruptible.class);
            StructuredGraph graph = method.compilationInfo.getGraph();
            c.checkOverrides(method, annotation);
            c.checkCallees(method, annotation, graph);
            c.checkCallers(method, annotation, graph);
        }
        if (Options.PrintUninterruptibleCalleeDOTGraph.getValue().booleanValue()) {
            System.out.println("/* DOT */ }");
        }
        c.reportViolations();
    }

    private void reportViolations() {
        if (!this.violations.isEmpty()) {
            String message = "Found " + this.violations.size() + " violations of @Uninterruptible usage:";
            for (String violation : this.violations) {
                message = message + System.lineSeparator() + violation;
            }
            throw UserError.abort("%s", message);
        }
    }

    private void checkOverrides(HostedMethod method, Uninterruptible methodAnnotation) {
        if (methodAnnotation == null) {
            return;
        }
        for (HostedMethod impl : method.getImplementations()) {
            Uninterruptible implAnnotation = impl.getAnnotation(Uninterruptible.class);
            if (implAnnotation != null) {
                if (methodAnnotation.callerMustBe() != implAnnotation.callerMustBe()) {
                    this.violations.add("callerMustBe: " + method.format("%H.%n(%p)") + " != " + impl.format("%H.%n(%p)"));
                }
                if (methodAnnotation.calleeMustBe() == implAnnotation.calleeMustBe()) continue;
                this.violations.add("calleeMustBe: " + method.format("%H.%n(%p)") + " != " + impl.format("%H.%n(%p)"));
                continue;
            }
            this.violations.add("method " + method.format("%H.%n(%p)") + " is annotated but " + impl.format("%H.%n(%p) is not"));
        }
    }

    private void checkCallees(HostedMethod caller, Uninterruptible callerAnnotation, StructuredGraph graph) {
        if (callerAnnotation == null || graph == null) {
            return;
        }
        for (Invoke invoke : graph.getInvokes()) {
            Uninterruptible directCallerAnnotation;
            HostedMethod callee = (HostedMethod)invoke.callTarget().targetMethod();
            if (Options.PrintUninterruptibleCalleeDOTGraph.getValue().booleanValue()) {
                UninterruptibleAnnotationChecker.printDotGraphEdge(caller, callee);
            }
            if ((directCallerAnnotation = (Uninterruptible)invoke.stateAfter().getMethod().getAnnotation(Uninterruptible.class)) == null) {
                this.violations.add("Unannotated callee: " + invoke.stateAfter().getMethod().format("%H.%n(%p)") + " inlined into annotated caller " + caller.format("%H.%n(%p)") + System.lineSeparator() + FrameState.toSourcePosition((FrameState)invoke.stateAfter()));
                continue;
            }
            if (!directCallerAnnotation.calleeMustBe() || UninterruptibleAnnotationChecker.isNotInterruptible(callee)) continue;
            this.violations.add("Unannotated callee: " + callee.format("%H.%n(%p)") + " called by annotated caller " + caller.format("%H.%n(%p)") + System.lineSeparator() + FrameState.toSourcePosition((FrameState)invoke.stateAfter()));
        }
    }

    private void checkCallers(HostedMethod caller, Uninterruptible callerAnnotation, StructuredGraph graph) {
        if (callerAnnotation != null || graph == null) {
            return;
        }
        for (Invoke invoke : graph.getInvokes()) {
            HostedMethod callee = (HostedMethod)invoke.callTarget().targetMethod();
            if (!UninterruptibleAnnotationChecker.isCallerMustBe(callee)) continue;
            this.violations.add("Unannotated caller: " + caller.format("%H.%n(%p)") + " calls annotated callee " + callee.format("%H.%n(%p)"));
        }
    }

    private void checkAllocations(ResolvedJavaMethod method, StructuredGraph graph) {
        Uninterruptible methodAnnotation = (Uninterruptible)method.getAnnotation(Uninterruptible.class);
        if (methodAnnotation != null && graph != null) {
            for (Node node : graph.getNodes()) {
                if (!RestrictHeapAccessAnnotationChecker.isAllocationNode(node)) continue;
                this.violations.add("Annotated method: " + method.format("%H.%n(%p)") + " allocates.");
            }
        }
    }

    private static boolean isNotInterruptible(HostedMethod method) {
        return UninterruptibleAnnotationChecker.isUninterruptible(method) || UninterruptibleAnnotationChecker.isNoTransitionCFunction(method);
    }

    private static boolean isUninterruptible(HostedMethod method) {
        return method.getAnnotation(Uninterruptible.class) != null;
    }

    private static boolean isCallerMustBe(HostedMethod method) {
        Uninterruptible uninterruptibleAnnotation = method.getAnnotation(Uninterruptible.class);
        return uninterruptibleAnnotation != null && uninterruptibleAnnotation.callerMustBe();
    }

    private static boolean isCalleeMustBe(HostedMethod method) {
        Uninterruptible uninterruptibleAnnotation = method.getAnnotation(Uninterruptible.class);
        return uninterruptibleAnnotation != null && uninterruptibleAnnotation.calleeMustBe();
    }

    private static boolean isNoTransitionCFunction(HostedMethod method) {
        CFunction cfunctionAnnotation = method.getAnnotation(CFunction.class);
        InvokeCFunctionPointer invokeCFunctionPointerAnnotation = method.getAnnotation(InvokeCFunctionPointer.class);
        return cfunctionAnnotation != null && cfunctionAnnotation.transition() == CFunction.Transition.NO_TRANSITION || invokeCFunctionPointerAnnotation != null && invokeCFunctionPointerAnnotation.transition() == CFunction.Transition.NO_TRANSITION;
    }

    private static void printDotGraphEdge(HostedMethod caller, HostedMethod callee) {
        String calleeColor;
        String callerColor = " [color=black]";
        if (UninterruptibleAnnotationChecker.isUninterruptible(caller)) {
            callerColor = " [color=blue]";
            if (!UninterruptibleAnnotationChecker.isCalleeMustBe(caller)) {
                callerColor = " [color=orange]";
            }
        }
        if (UninterruptibleAnnotationChecker.isUninterruptible(callee)) {
            calleeColor = " [color=blue]";
            if (!UninterruptibleAnnotationChecker.isCalleeMustBe(callee)) {
                calleeColor = " [color=purple]";
            }
        } else {
            calleeColor = " [color=red]";
        }
        if (UninterruptibleAnnotationChecker.isNoTransitionCFunction(callee)) {
            calleeColor = " [color=green]";
        }
        System.out.println("/* DOT */    " + caller.format("<%h.%n>") + callerColor);
        System.out.println("/* DOT */    " + callee.format("<%h.%n>") + calleeColor);
        System.out.println("/* DOT */    " + caller.format("<%h.%n>") + " -> " + callee.format("<%h.%n>") + calleeColor);
    }

    public static class Options {
        public static final HostedOptionKey<Boolean> PrintUninterruptibleCalleeDOTGraph = new HostedOptionKey<Boolean>(false);
    }
}

