/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.svm.hosted.c.query;

import com.oracle.svm.core.config.ConfigurationValues;
import com.oracle.svm.core.util.UserError;
import com.oracle.svm.core.util.VMError;
import com.oracle.svm.hosted.c.CInterfaceError;
import com.oracle.svm.hosted.c.NativeLibraries;
import com.oracle.svm.hosted.c.info.AccessorInfo;
import com.oracle.svm.hosted.c.info.ElementInfo;
import com.oracle.svm.hosted.c.info.NativeCodeInfo;
import com.oracle.svm.hosted.c.info.RawPointerToInfo;
import com.oracle.svm.hosted.c.info.RawStructureInfo;
import com.oracle.svm.hosted.c.info.SizableInfo;
import com.oracle.svm.hosted.c.info.StructBitfieldInfo;
import com.oracle.svm.hosted.c.info.StructFieldInfo;
import com.oracle.svm.hosted.c.query.NativeInfoTreeVisitor;
import com.oracle.svm.util.ReflectionUtil;
import java.lang.reflect.AnnotatedElement;
import java.util.ArrayList;
import java.util.function.IntUnaryOperator;
import jdk.vm.ci.meta.ResolvedJavaType;
import org.graalvm.nativeimage.c.struct.RawStructure;

public final class RawStructureLayoutPlanner
extends NativeInfoTreeVisitor {
    private RawStructureLayoutPlanner(NativeLibraries nativeLibs) {
        super(nativeLibs);
    }

    public static void plan(NativeLibraries nativeLibs, NativeCodeInfo nativeCodeInfo) {
        if (!nativeCodeInfo.isBuiltin()) {
            return;
        }
        RawStructureLayoutPlanner planner = new RawStructureLayoutPlanner(nativeLibs);
        nativeCodeInfo.accept(planner);
    }

    @Override
    protected void visitRawStructureInfo(RawStructureInfo info) {
        if (info.isPlanned()) {
            return;
        }
        ResolvedJavaType type = info.getAnnotatedElement();
        for (ResolvedJavaType t : type.getInterfaces()) {
            if (!this.nativeLibs.isPointerBase(t)) {
                throw UserError.abort("Type %s must not implement %s", type, t);
            }
            if (t.equals(this.nativeLibs.getPointerBaseType())) continue;
            ElementInfo einfo = this.nativeLibs.findElementInfo((AnnotatedElement)t);
            if (!(einfo instanceof RawStructureInfo)) {
                throw UserError.abort(new CInterfaceError("Illegal super type " + t + " found", type).getMessage(), new Object[0]);
            }
            RawStructureInfo rinfo = (RawStructureInfo)einfo;
            rinfo.accept(this);
            assert (rinfo.isPlanned());
            if (info.getParentInfo() != null) {
                throw UserError.abort(new CInterfaceError("Only single inheritance of RawStructure types is supported", type).getMessage(), new Object[0]);
            }
            info.setParentInfo(rinfo);
        }
        for (ElementInfo child : new ArrayList<ElementInfo>(info.getChildren())) {
            if (!(child instanceof StructFieldInfo)) continue;
            StructFieldInfo fieldInfo = (StructFieldInfo)child;
            StructFieldInfo parentFieldInfo = this.findParentFieldInfo(fieldInfo, info.getParentInfo());
            if (parentFieldInfo != null) {
                fieldInfo.mergeChildrenAndDelete(parentFieldInfo);
                continue;
            }
            this.computeSize(fieldInfo);
        }
        this.planLayout(info);
    }

    @Override
    protected void visitRawPointerToInfo(RawPointerToInfo info) {
        info.getSizeInfo().setProperty(this.getSizeInBytes(info.getAnnotatedElement()));
    }

    private void computeSize(StructFieldInfo info) {
        int declaredSize;
        if (info.isObject()) {
            declaredSize = ConfigurationValues.getObjectLayout().getReferenceSize();
        } else {
            ResolvedJavaType fieldType;
            AccessorInfo accessor = info.getAccessorInfoWithSize();
            switch (accessor.getAccessorKind()) {
                case GETTER: {
                    fieldType = accessor.getReturnType();
                    break;
                }
                case SETTER: {
                    fieldType = accessor.getValueParameterType();
                    break;
                }
                default: {
                    throw VMError.shouldNotReachHere("Unexpected accessor kind " + accessor.getAccessorKind());
                }
            }
            if (info.getKind() == SizableInfo.ElementKind.INTEGER) {
                info.getSignednessInfo().setProperty(this.isSigned(fieldType) ? SizableInfo.SignednessValue.SIGNED : SizableInfo.SignednessValue.UNSIGNED);
            }
            declaredSize = this.getSizeInBytes(fieldType);
        }
        info.getSizeInfo().setProperty(declaredSize);
    }

    private void planLayout(RawStructureInfo info) {
        int totalSize;
        int currentOffset = info.getParentInfo() != null ? info.getParentInfo().getSizeInfo().getProperty() : 0;
        ArrayList<StructFieldInfo> fields = new ArrayList<StructFieldInfo>();
        for (ElementInfo child : info.getChildren()) {
            if (child instanceof StructFieldInfo) {
                fields.add((StructFieldInfo)child);
                continue;
            }
            if (!(child instanceof StructBitfieldInfo)) continue;
            throw UserError.abort("StructBitfield is currently not supported by RawStructures!", new Object[0]);
        }
        fields.sort((f1, f2) -> f2.getSizeInfo().getProperty() - f1.getSizeInfo().getProperty());
        for (StructFieldInfo finfo : fields) {
            assert (this.findParentFieldInfo(finfo, info.getParentInfo()) == null);
            int fieldSize = finfo.getSizeInfo().getProperty();
            currentOffset = RawStructureLayoutPlanner.alignOffset(currentOffset, fieldSize);
            assert (currentOffset % fieldSize == 0);
            finfo.getOffsetInfo().setProperty(currentOffset);
            currentOffset += fieldSize;
        }
        Class sizeProviderClass = ((RawStructure)info.getAnnotatedElement().getAnnotation(RawStructure.class)).sizeProvider();
        if (sizeProviderClass == IntUnaryOperator.class) {
            totalSize = currentOffset;
        } else {
            IntUnaryOperator sizeProvider;
            try {
                sizeProvider = (IntUnaryOperator)ReflectionUtil.newInstance((Class)sizeProviderClass);
            }
            catch (ReflectionUtil.ReflectionUtilError ex) {
                throw UserError.abort(ex.getCause(), "The size provider of @%s %s cannot be instantiated via no-argument constructor", RawStructure.class.getSimpleName(), info.getAnnotatedElement().toJavaName(true));
            }
            totalSize = sizeProvider.applyAsInt(currentOffset);
            if (totalSize < currentOffset) {
                throw UserError.abort("The size provider of @%s %s computed size %d which is smaller than the minimum size of %d", RawStructure.class.getSimpleName(), info.getAnnotatedElement().toJavaName(true), totalSize, currentOffset);
            }
        }
        info.getSizeInfo().setProperty(totalSize);
        info.setPlanned();
    }

    private StructFieldInfo findParentFieldInfo(StructFieldInfo fieldInfo, RawStructureInfo parentInfo) {
        StructFieldInfo result;
        if (parentInfo == null) {
            return null;
        }
        if (parentInfo.getParentInfo() != null && (result = this.findParentFieldInfo(fieldInfo, parentInfo.getParentInfo())) != null) {
            return result;
        }
        for (ElementInfo child : parentInfo.getChildren()) {
            if (!(child instanceof StructFieldInfo)) continue;
            StructFieldInfo parentFieldInfo = (StructFieldInfo)child;
            if (!fieldInfo.getName().equals(parentFieldInfo.getName())) continue;
            return parentFieldInfo;
        }
        return null;
    }

    private static int alignOffset(int offset, int fieldSize) {
        if (offset % fieldSize == 0) {
            return offset;
        }
        return (offset / fieldSize + 1) * fieldSize;
    }
}

