/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.svm.hosted;

import com.oracle.graal.pointsto.BigBang;
import com.oracle.graal.pointsto.meta.AnalysisUniverse;
import com.oracle.graal.pointsto.reports.ReportUtils;
import com.oracle.graal.pointsto.util.Timer;
import com.oracle.graal.pointsto.util.TimerCollection;
import com.oracle.svm.core.BuildArtifacts;
import com.oracle.svm.core.OS;
import com.oracle.svm.core.SubstrateOptions;
import com.oracle.svm.core.VM;
import com.oracle.svm.core.annotate.AutomaticFeature;
import com.oracle.svm.core.code.CodeInfoTable;
import com.oracle.svm.core.heap.Heap;
import com.oracle.svm.core.option.HostedOptionValues;
import com.oracle.svm.core.reflect.ReflectionMetadataDecoder;
import com.oracle.svm.core.util.VMError;
import com.oracle.svm.hosted.NativeImageGenerator;
import com.oracle.svm.hosted.NativeImageSystemIOWrappers;
import com.oracle.svm.hosted.ProgressReporterCHelper;
import com.oracle.svm.hosted.c.codegen.CCompilerInvoker;
import com.oracle.svm.hosted.code.CompileQueue;
import com.oracle.svm.hosted.image.AbstractImage;
import com.oracle.svm.hosted.image.NativeImageHeap;
import com.oracle.svm.util.ImageBuildStatistics;
import com.oracle.svm.util.ReflectionUtil;
import java.io.File;
import java.io.PrintWriter;
import java.lang.management.GarbageCollectorMXBean;
import java.lang.management.ManagementFactory;
import java.lang.management.OperatingSystemMXBean;
import java.lang.reflect.Field;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Comparator;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.ScheduledFuture;
import java.util.concurrent.TimeUnit;
import java.util.function.Consumer;
import org.graalvm.compiler.debug.DebugOptions;
import org.graalvm.compiler.options.OptionValues;
import org.graalvm.compiler.serviceprovider.GraalServices;
import org.graalvm.nativeimage.ImageSingletons;
import org.graalvm.nativeimage.hosted.Feature;
import org.graalvm.nativeimage.impl.ImageSingletonsSupport;
import org.graalvm.nativeimage.impl.RuntimeReflectionSupport;

public class ProgressReporter {
    private static final int CHARACTERS_PER_LINE;
    private static final boolean IS_CI;
    private static final boolean IS_DUMB_TERM;
    private static final int MAX_NUM_FEATURES = 50;
    private static final int MAX_NUM_BREAKDOWN = 10;
    private static final String CODE_BREAKDOWN_TITLE;
    private static final String HEAP_BREAKDOWN_TITLE;
    private static final String STAGE_DOCS_URL = "https://github.com/oracle/graal/blob/master/docs/reference-manual/native-image/BuildOutput.md";
    private static final double EXCESSIVE_GC_MIN_THRESHOLD_MILLIS = 15000.0;
    private static final double EXCESSIVE_GC_RATIO = 0.5;
    private static final String BREAKDOWN_BYTE_ARRAY_PREFIX = "byte[] for ";
    private final NativeImageSystemIOWrappers builderIO;
    private final boolean isEnabled;
    private final DirectPrinter linePrinter = new DirectPrinter();
    private final StagePrinter<?> stagePrinter;
    private final ColorStrategy colorStrategy;
    private final LinkStrategy linkStrategy;
    private final boolean usePrefix;
    private final ScheduledExecutorService executor = Executors.newSingleThreadScheduledExecutor();
    private String outputPrefix = "";
    private long lastGCCheckTimeMillis = System.currentTimeMillis();
    private GCStats lastGCStats = GCStats.getCurrent();
    private long numRuntimeCompiledMethods = -1L;
    private long graphEncodingByteLength = 0L;
    private int numJNIClasses = -1;
    private int numJNIFields = -1;
    private int numJNIMethods = -1;
    private Timer debugInfoTimer;
    private boolean creationStageEndCompleted = false;
    private boolean reportStringBytes = true;

    private static boolean isDumbTerm() {
        String term = System.getenv("TERM");
        return term == null || term.equals("") || term.equals("dumb") || term.equals("unknown");
    }

    public static ProgressReporter singleton() {
        return (ProgressReporter)ImageSingletons.lookup(ProgressReporter.class);
    }

    public ProgressReporter(OptionValues options) {
        boolean enableProgress;
        boolean enableColors;
        this.builderIO = NativeImageSystemIOWrappers.singleton();
        this.isEnabled = (Boolean)SubstrateOptions.BuildOutputUseNewStyle.getValue(options);
        if (this.isEnabled) {
            Timer.disablePrinting();
        }
        this.usePrefix = (Boolean)SubstrateOptions.BuildOutputPrefix.getValue(options);
        boolean bl = enableColors = !IS_DUMB_TERM && !IS_CI && OS.getCurrent() != OS.WINDOWS && System.getenv("NO_COLOR") == null;
        if (SubstrateOptions.BuildOutputColorful.hasBeenSet(options)) {
            enableColors = (Boolean)SubstrateOptions.BuildOutputColorful.getValue(options);
        }
        if (enableColors) {
            this.colorStrategy = new ColorfulStrategy();
            try {
                Runtime.getRuntime().addShutdownHook(new Thread(ProgressReporter::resetANSIMode));
            }
            catch (IllegalStateException illegalStateException) {}
        } else {
            this.colorStrategy = new ColorlessStrategy();
        }
        boolean loggingEnabled = DebugOptions.Log.getValue(options) != null;
        boolean bl2 = enableProgress = !IS_DUMB_TERM && !IS_CI && !loggingEnabled;
        if (SubstrateOptions.BuildOutputProgress.hasBeenSet(options)) {
            enableProgress = (Boolean)SubstrateOptions.BuildOutputProgress.getValue(options);
        }
        this.stagePrinter = enableProgress ? new CharacterwiseStagePrinter() : new LinewiseStagePrinter();
        boolean showLinks = enableColors;
        if (SubstrateOptions.BuildOutputLinks.hasBeenSet(options)) {
            showLinks = (Boolean)SubstrateOptions.BuildOutputLinks.getValue(options);
        }
        LinkStrategy linkStrategy = this.linkStrategy = showLinks ? new LinkyStrategy() : new LinklessStrategy();
        if (SubstrateOptions.useEconomyCompilerConfig(options)) {
            ((DirectPrinter)this.l().redBold()).a("You enabled -Ob for this image build. This will configure some optimizations to reduce image build time.").println();
            ((DirectPrinter)((DirectPrinter)this.l().redBold()).a("This feature should only be used during development and never for deployment.").reset()).println();
        }
    }

    public void setNumRuntimeCompiledMethods(int value) {
        this.numRuntimeCompiledMethods = value;
    }

    public void setGraphEncodingByteLength(int value) {
        this.graphEncodingByteLength = value;
    }

    public void setJNIInfo(int numClasses, int numFields, int numMethods) {
        this.numJNIClasses = numClasses;
        this.numJNIFields = numFields;
        this.numJNIMethods = numMethods;
    }

    public void disableStringBytesReporting() {
        this.reportStringBytes = false;
    }

    public void printStart(String imageName, AbstractImage.NativeImageKind imageKind) {
        if (this.usePrefix) {
            this.outputPrefix = String.format("[%s:%s] ", imageName, GraalServices.getExecutionID());
            this.stagePrinter.progressBarStart += this.outputPrefix.length();
        }
        this.l().printHeadlineSeparator();
        String imageKindName = imageKind.name().toLowerCase().replace('_', ' ');
        ((DirectPrinter)((DirectPrinter)((DirectPrinter)((DirectPrinter)((DirectPrinter)((DirectPrinter)this.l().blueBold()).link("GraalVM Native Image", "https://www.graalvm.org/native-image/")).reset()).a(": Generating '").bold()).a(imageName).reset()).a("' (").doclink(imageKindName, "#glossary-imagekind")).a(")...").println();
        this.l().printHeadlineSeparator();
        this.stagePrinter.start(BuildStage.INITIALIZING);
    }

    public void printUnsuccessfulInitializeEnd() {
        if (this.stagePrinter.activeBuildStage != null) {
            this.stagePrinter.end(0.0);
        }
    }

    public void printInitializeEnd(Collection<String> libraries) {
        this.stagePrinter.end(ProgressReporter.getTimer(TimerCollection.Registry.CLASSLIST).getTotalTime() + ProgressReporter.getTimer(TimerCollection.Registry.SETUP).getTotalTime());
        ((DirectPrinter)this.l().a(" ").doclink("Version info", "#glossary-version-info")).a(": '").a(((VM)ImageSingletons.lookup(VM.class)).version).a("'").println();
        if (ImageSingletons.contains(CCompilerInvoker.class)) {
            ((DirectPrinter)this.l().a(" ").doclink("C compiler", "#glossary-ccompiler")).a(": ").a(((CCompilerInvoker)ImageSingletons.lookup(CCompilerInvoker.class)).compilerInfo.getShortDescription()).println();
        }
        ((DirectPrinter)this.l().a(" ").doclink("Garbage collector", "#glossary-gc")).a(": ").a(Heap.getHeap().getGC().getName()).println();
        this.printNativeLibraries(libraries);
    }

    private void printNativeLibraries(Collection<String> libraries) {
        int numLibraries = libraries.size();
        if (numLibraries > 0) {
            if (numLibraries == 1) {
                this.l().a(" 1 native library: ").a(libraries.iterator().next()).println();
            } else {
                ((DirectPrinter)this.l().a(" ").a(numLibraries)).a(" native libraries: ").a(String.join((CharSequence)", ", libraries)).println();
            }
        }
    }

    public void printFeatures(List<String> list) {
        int numUserFeatures = list.size();
        if (numUserFeatures > 0) {
            ((DirectPrinter)((DirectPrinter)this.l().a(" ").a(numUserFeatures)).a(" ").doclink("user-provided feature(s)", "#glossary-user-provided-features")).println();
            if (numUserFeatures <= 50) {
                for (String name : list) {
                    this.l().a("  - ").a(name).println();
                }
            } else {
                for (int i = 0; i < 50; ++i) {
                    this.l().a("  - ").a(list.get(i)).println();
                }
                ((DirectPrinter)this.l().a("  ... ").a(numUserFeatures - 50)).a(" more").println();
            }
        }
    }

    public ReporterClosable printAnalysis(final BigBang bb) {
        final Timer timer = ProgressReporter.getTimer(TimerCollection.Registry.ANALYSIS);
        timer.start();
        this.stagePrinter.start(BuildStage.ANALYSIS);
        return new ReporterClosable(){

            @Override
            public void closeAction() {
                timer.stop();
                ProgressReporter.this.stagePrinter.end(timer);
                ProgressReporter.this.printAnalysisStatistics(bb.getUniverse());
            }
        };
    }

    private void printAnalysisStatistics(AnalysisUniverse universe) {
        String actualVsTotalFormat = "%,8d (%5.2f%%) of %,6d";
        long reachableClasses = universe.getTypes().stream().filter(t -> t.isReachable()).count();
        long totalClasses = universe.getTypes().size();
        ((DirectPrinter)((DirectPrinter)this.l().a(actualVsTotalFormat, reachableClasses, (double)reachableClasses / (double)totalClasses * 100.0, totalClasses)).a(" classes ").doclink("reachable", "#glossary-reachability")).println();
        Collection fields = universe.getFields();
        long reachableFields = fields.stream().filter(f -> f.isAccessed()).count();
        int totalFields = fields.size();
        ((DirectPrinter)((DirectPrinter)this.l().a(actualVsTotalFormat, reachableFields, (double)reachableFields / (double)totalFields * 100.0, totalFields)).a(" fields ").doclink("reachable", "#glossary-reachability")).println();
        Collection methods = universe.getMethods();
        long reachableMethods = methods.stream().filter(m -> m.isReachable()).count();
        int totalMethods = methods.size();
        ((DirectPrinter)((DirectPrinter)this.l().a(actualVsTotalFormat, reachableMethods, (double)reachableMethods / (double)totalMethods * 100.0, totalMethods)).a(" methods ").doclink("reachable", "#glossary-reachability")).println();
        if (this.numRuntimeCompiledMethods >= 0L) {
            ((DirectPrinter)((DirectPrinter)this.l().a(actualVsTotalFormat, this.numRuntimeCompiledMethods, (double)this.numRuntimeCompiledMethods / (double)totalMethods * 100.0, totalMethods)).a(" methods included for ").doclink("runtime compilation", "#glossary-runtime-methods")).println();
        }
        String classesFieldsMethodFormat = "%,8d classes, %,5d fields, and %,5d methods ";
        RuntimeReflectionSupport rs = (RuntimeReflectionSupport)ImageSingletons.lookup(RuntimeReflectionSupport.class);
        ((DirectPrinter)((DirectPrinter)this.l().a(classesFieldsMethodFormat, rs.getReflectionClassesCount(), rs.getReflectionFieldsCount(), rs.getReflectionMethodsCount())).doclink("registered for reflection", "#glossary-reflection-registrations")).println();
        if (this.numJNIClasses > 0) {
            ((DirectPrinter)((DirectPrinter)this.l().a(classesFieldsMethodFormat, this.numJNIClasses, this.numJNIFields, this.numJNIMethods)).doclink("registered for JNI access", "#glossary-jni-access-registrations")).println();
        }
    }

    public ReporterClosable printUniverse() {
        final Timer timer = ProgressReporter.getTimer(TimerCollection.Registry.UNIVERSE);
        timer.start();
        this.stagePrinter.start(BuildStage.UNIVERSE);
        return new ReporterClosable(){

            @Override
            public void closeAction() {
                timer.stop();
                ProgressReporter.this.stagePrinter.end(timer);
            }
        };
    }

    public ReporterClosable printParsing() {
        final Timer timer = ProgressReporter.getTimer(TimerCollection.Registry.PARSE);
        timer.start();
        this.stagePrinter.start(BuildStage.PARSING);
        return new ReporterClosable(){

            @Override
            public void closeAction() {
                timer.stop();
                ProgressReporter.this.stagePrinter.end(timer);
            }
        };
    }

    public ReporterClosable printInlining() {
        final Timer timer = ProgressReporter.getTimer(TimerCollection.Registry.INLINE);
        timer.start();
        this.stagePrinter.start(BuildStage.INLINING);
        return new ReporterClosable(){

            @Override
            public void closeAction() {
                timer.stop();
                ProgressReporter.this.stagePrinter.end(timer);
            }
        };
    }

    public ReporterClosable printCompiling() {
        final Timer timer = ProgressReporter.getTimer(TimerCollection.Registry.COMPILE);
        timer.start();
        this.stagePrinter.start(BuildStage.COMPILING);
        return new ReporterClosable(){

            @Override
            public void closeAction() {
                timer.stop();
                ProgressReporter.this.stagePrinter.end(timer);
            }
        };
    }

    public void printCreationStart() {
        this.stagePrinter.start(BuildStage.CREATING);
    }

    public void setDebugInfoTimer(Timer timer) {
        this.debugInfoTimer = timer;
    }

    public void printCreationEnd(int imageSize, AnalysisUniverse universe, int numHeapObjects, long imageHeapSize, int codeCacheSize, int numCompilations, int debugInfoSize) {
        Timer imageTimer = ProgressReporter.getTimer(TimerCollection.Registry.IMAGE);
        Timer writeTimer = ProgressReporter.getTimer(TimerCollection.Registry.WRITE);
        this.stagePrinter.end(imageTimer.getTotalTime() + writeTimer.getTotalTime());
        this.creationStageEndCompleted = true;
        String format = "%9s (%5.2f%%) for ";
        ((DirectPrinter)((DirectPrinter)((DirectPrinter)this.l().a(format, Utils.bytesToHuman(codeCacheSize), (double)codeCacheSize / (double)imageSize * 100.0)).doclink("code area", "#glossary-code-area")).a(":%,9d compilation units", numCompilations)).println();
        long numInstantiatedClasses = universe.getTypes().stream().filter(t -> t.isInstantiated()).count();
        ((DirectPrinter)((DirectPrinter)((DirectPrinter)this.l().a(format, Utils.bytesToHuman(imageHeapSize), (double)imageHeapSize / (double)imageSize * 100.0)).doclink("image heap", "#glossary-image-heap")).a(":%,8d classes and %,d objects", numInstantiatedClasses, numHeapObjects)).println();
        if (debugInfoSize > 0) {
            DirectPrinter l = (DirectPrinter)((DirectPrinter)this.l().a(format, Utils.bytesToHuman(debugInfoSize), (double)debugInfoSize / (double)imageSize * 100.0)).doclink("debug info", "#glossary-debug-info");
            if (this.debugInfoTimer != null) {
                l.a(" generated in %.1fs", Utils.millisToSeconds(this.debugInfoTimer.getTotalTime()));
            }
            l.println();
        }
        long otherBytes = (long)(imageSize - codeCacheSize) - imageHeapSize - (long)debugInfoSize;
        ((DirectPrinter)((DirectPrinter)this.l().a(format, Utils.bytesToHuman(otherBytes), (double)otherBytes / (double)imageSize * 100.0)).doclink("other data", "#glossary-other-data")).println();
        ((DirectPrinter)this.l().a("%9s in total", Utils.bytesToHuman(imageSize))).println();
    }

    public void ensureCreationStageEndCompleted() {
        if (!this.creationStageEndCompleted) {
            this.println();
        }
    }

    public void printBreakdowns(Collection<CompileQueue.CompileTask> compilationTasks, Collection<NativeImageHeap.ObjectInfo> heapObjects) {
        Map<String, Long> codeBreakdown = ProgressReporter.calculateCodeBreakdown(compilationTasks);
        Map<String, Long> heapBreakdown = this.calculateHeapBreakdown(heapObjects);
        this.l().printLineSeparator();
        int numCodeBreakdownItems = codeBreakdown.size();
        int numHeapBreakdownItems = heapBreakdown.size();
        Iterator packagesBySize = codeBreakdown.entrySet().stream().sorted(Map.Entry.comparingByValue(Comparator.reverseOrder())).iterator();
        Iterator typesBySizeInHeap = heapBreakdown.entrySet().stream().sorted(Map.Entry.comparingByValue(Comparator.reverseOrder())).iterator();
        TwoColumnPrinter p = new TwoColumnPrinter();
        ((TwoColumnPrinter)((TwoColumnPrinter)((TwoColumnPrinter)p.l()).yellowBold()).a(CODE_BREAKDOWN_TITLE).jumpToMiddle().a(HEAP_BREAKDOWN_TITLE).reset()).flushln();
        ArrayList<Map.Entry> printedCodeSizeEntries = new ArrayList<Map.Entry>();
        ArrayList<Map.Entry> printedHeapSizeEntries = new ArrayList<Map.Entry>();
        for (int i = 0; i < 10; ++i) {
            String codeSizePart = "";
            if (packagesBySize.hasNext()) {
                Map.Entry e = (Map.Entry)packagesBySize.next();
                String className = Utils.truncateClassOrPackageName((String)e.getKey());
                codeSizePart = String.format("%9s %s", Utils.bytesToHuman((Long)e.getValue()), className);
                printedCodeSizeEntries.add(e);
            }
            String heapSizePart = "";
            if (typesBySizeInHeap.hasNext()) {
                Map.Entry e = (Map.Entry)typesBySizeInHeap.next();
                String className = (String)e.getKey();
                if (!className.startsWith(BREAKDOWN_BYTE_ARRAY_PREFIX)) {
                    className = Utils.truncateClassOrPackageName(className);
                }
                heapSizePart = String.format("%9s %s", Utils.bytesToHuman((Long)e.getValue()), className);
                printedHeapSizeEntries.add(e);
            }
            if (codeSizePart.isEmpty() && heapSizePart.isEmpty()) break;
            ((TwoColumnPrinter)p.l()).a(codeSizePart).jumpToMiddle().a(heapSizePart).flushln();
        }
        ((TwoColumnPrinter)((TwoColumnPrinter)((TwoColumnPrinter)p.l()).a("      ... ").a(numCodeBreakdownItems - printedHeapSizeEntries.size())).a(" additional packages").jumpToMiddle().a("      ... ").a(numHeapBreakdownItems - printedCodeSizeEntries.size())).a(" additional object types").flushln();
        ((CenteredTextPrinter)((CenteredTextPrinter)((CenteredTextPrinter)((CenteredTextPrinter)((CenteredTextPrinter)new CenteredTextPrinter().dim()).a("(use ")).link("GraalVM Dashboard", "https://www.graalvm.org/dashboard/?ojr=help%3Btopic%3Dgetting-started.md")).a(" to see all)")).reset()).flushln();
    }

    private static Map<String, Long> calculateCodeBreakdown(Collection<CompileQueue.CompileTask> compilationTasks) {
        HashMap<String, Long> classNameToCodeSize = new HashMap<String, Long>();
        for (CompileQueue.CompileTask task : compilationTasks) {
            String classOrPackageName = task.method.format("%H");
            int lastDotIndex = classOrPackageName.lastIndexOf(46);
            if (lastDotIndex > 0) {
                classOrPackageName = classOrPackageName.substring(0, lastDotIndex);
            }
            classNameToCodeSize.merge(classOrPackageName, Long.valueOf(task.result.getTargetCodeSize()), Long::sum);
        }
        return classNameToCodeSize;
    }

    private Map<String, Long> calculateHeapBreakdown(Collection<NativeImageHeap.ObjectInfo> heapObjects) {
        HashMap<String, Long> classNameToSize = new HashMap<String, Long>();
        long stringByteLength = 0L;
        for (NativeImageHeap.ObjectInfo o : heapObjects) {
            classNameToSize.merge(o.getClazz().toJavaName(true), o.getSize(), Long::sum);
            Object javaObject = o.getObject();
            if (!this.reportStringBytes || !(javaObject instanceof String)) continue;
            stringByteLength += (long)Utils.getInternalByteArrayLength((String)javaObject);
        }
        Long byteArraySize = (Long)classNameToSize.remove("byte[]");
        if (byteArraySize != null) {
            long metadataByteLength;
            long codeInfoSize;
            long remainingBytes = byteArraySize;
            if (stringByteLength > 0L) {
                classNameToSize.put("byte[] for java.lang.String", stringByteLength);
                remainingBytes -= stringByteLength;
            }
            if ((codeInfoSize = CodeInfoTable.getImageCodeCache().getTotalByteArraySize()) > 0L) {
                classNameToSize.put(BREAKDOWN_BYTE_ARRAY_PREFIX + this.linkStrategy.asDocLink("code metadata", "#glossary-code-metadata"), codeInfoSize);
                remainingBytes -= codeInfoSize;
            }
            if ((metadataByteLength = ((ReflectionMetadataDecoder)ImageSingletons.lookup(ReflectionMetadataDecoder.class)).getMetadataByteLength()) > 0L) {
                classNameToSize.put(BREAKDOWN_BYTE_ARRAY_PREFIX + this.linkStrategy.asDocLink("reflection metadata", "#glossary-reflection-metadata"), metadataByteLength);
                remainingBytes -= metadataByteLength;
            }
            if (this.graphEncodingByteLength > 0L) {
                classNameToSize.put(BREAKDOWN_BYTE_ARRAY_PREFIX + this.linkStrategy.asDocLink("graph encodings", "#glossary-graph-encodings"), this.graphEncodingByteLength);
                remainingBytes -= this.graphEncodingByteLength;
            }
            assert (remainingBytes >= 0L);
            classNameToSize.put(BREAKDOWN_BYTE_ARRAY_PREFIX + this.linkStrategy.asDocLink("general heap data", "#glossary-general-heap-data"), remainingBytes);
        }
        return classNameToSize;
    }

    public void printEpilog(String imageName, NativeImageGenerator generator, boolean wasSuccessfulBuild, OptionValues parsedHostedOptions) {
        this.l().printLineSeparator();
        this.printResourceStatistics();
        Map<BuildArtifacts.ArtifactType, List<Path>> artifacts = generator.getBuildArtifacts();
        if (!artifacts.isEmpty()) {
            this.l().printLineSeparator();
            this.printArtifacts(imageName, generator, parsedHostedOptions, artifacts);
        }
        this.l().printHeadlineSeparator();
        double totalSeconds = Utils.millisToSeconds(ProgressReporter.getTimer(TimerCollection.Registry.TOTAL).getTotalTime());
        String timeStats = totalSeconds < 60.0 ? String.format("%.1fs", totalSeconds) : String.format("%dm %ds", (int)totalSeconds / 60, (int)totalSeconds % 60);
        ((DirectPrinter)((DirectPrinter)this.l().a(wasSuccessfulBuild ? "Finished" : "Failed").a(" generating '").bold()).a(imageName).reset()).a("' ").a(wasSuccessfulBuild ? "in" : "after").a(" ").a(timeStats).a(".").println();
        this.executor.shutdown();
    }

    private void printArtifacts(String imageName, NativeImageGenerator generator, OptionValues parsedHostedOptions, Map<BuildArtifacts.ArtifactType, List<Path>> artifacts) {
        ((DirectPrinter)((DirectPrinter)this.l().yellowBold()).a("Produced artifacts:").reset()).println();
        artifacts.forEach((artifactType, paths) -> {
            for (Path p : paths) {
                ((DirectPrinter)((DirectPrinter)((DirectPrinter)this.l().a(" ").link(p)).dim()).a(" (").a(artifactType.name().toLowerCase()).a(")").reset()).println();
            }
        });
        if (generator.getBigbang() != null && ((Boolean)ImageBuildStatistics.Options.CollectImageBuildStatistics.getValue(parsedHostedOptions)).booleanValue()) {
            ((DirectPrinter)this.l().a(" ").link(this.reportImageBuildStatistics(imageName, generator.getBigbang()))).println();
        }
        ((DirectPrinter)this.l().a(" ").link(this.reportBuildArtifacts(imageName, artifacts))).println();
    }

    private Path reportImageBuildStatistics(String imageName, BigBang bb) {
        Consumer statsReporter = ((ImageBuildStatistics)ImageSingletons.lookup(ImageBuildStatistics.class)).getReporter();
        String description = "image build statistics";
        if (ImageBuildStatistics.Options.ImageBuildStatisticsFile.hasBeenSet(bb.getOptions())) {
            File file = new File((String)ImageBuildStatistics.Options.ImageBuildStatisticsFile.getValue(bb.getOptions()));
            return ReportUtils.report((String)description, (Path)file.getAbsoluteFile().toPath(), (Consumer)statsReporter, (!this.isEnabled ? 1 : 0) != 0);
        }
        String name = "image_build_statistics_" + ReportUtils.extractImageName((String)imageName);
        String path = SubstrateOptions.Path.getValue() + File.separatorChar + "reports";
        return ReportUtils.report((String)description, (String)path, (String)name, (String)"json", (Consumer)statsReporter, (!this.isEnabled ? 1 : 0) != 0);
    }

    private Path reportBuildArtifacts(String imageName, Map<BuildArtifacts.ArtifactType, List<Path>> buildArtifacts) {
        Path buildDir = NativeImageGenerator.generatedFiles(HostedOptionValues.singleton());
        Consumer<PrintWriter> writerConsumer = writer -> buildArtifacts.forEach((artifactType, paths) -> {
            writer.println("[" + artifactType + "]");
            if (artifactType == BuildArtifacts.ArtifactType.JDK_LIB_SHIM) {
                writer.println("# Note that shim JDK libraries depend on this");
                writer.println("# particular native image (including its name)");
                writer.println("# and therefore cannot be used with others.");
            }
            paths.stream().map(Path::toAbsolutePath).map(buildDir::relativize).forEach(writer::println);
            writer.println();
        });
        return ReportUtils.report((String)"build artifacts", (Path)buildDir.resolve(imageName + ".build_artifacts.txt"), writerConsumer, (!this.isEnabled ? 1 : 0) != 0);
    }

    private void printResourceStatistics() {
        OperatingSystemMXBean osMXBean;
        long processCPUTime;
        double totalProcessTimeSeconds = Utils.millisToSeconds(System.currentTimeMillis() - ManagementFactory.getRuntimeMXBean().getStartTime());
        GCStats gcStats = GCStats.getCurrent();
        double gcSeconds = Utils.millisToSeconds(gcStats.totalTimeMillis);
        CenteredTextPrinter p = new CenteredTextPrinter();
        ((CenteredTextPrinter)p.a("%.1fs (%.1f%% of total time) in %d ", gcSeconds, gcSeconds / totalProcessTimeSeconds * 100.0, gcStats.totalCount)).doclink("GCs", "#glossary-garbage-collections");
        long peakRSS = ProgressReporterCHelper.getPeakRSS();
        if (peakRSS >= 0L) {
            ((CenteredTextPrinter)((CenteredTextPrinter)((CenteredTextPrinter)p.a(" | ")).doclink("Peak RSS", "#glossary-peak-rss")).a(": ")).a("%.2fGB", Utils.bytesToGiB(peakRSS));
        }
        if ((processCPUTime = ((com.sun.management.OperatingSystemMXBean)(osMXBean = ManagementFactory.getOperatingSystemMXBean())).getProcessCpuTime()) > 0L) {
            ((CenteredTextPrinter)((CenteredTextPrinter)((CenteredTextPrinter)p.a(" | ")).doclink("CPU load", "#glossary-cpu-load")).a(": ")).a("%.2f", Utils.nanosToSeconds(processCPUTime) / totalProcessTimeSeconds);
        }
        p.flushln();
    }

    private void checkForExcessiveGarbageCollection() {
        long current = System.currentTimeMillis();
        long timeDeltaMillis = current - this.lastGCCheckTimeMillis;
        this.lastGCCheckTimeMillis = current;
        GCStats currentGCStats = GCStats.getCurrent();
        long gcTimeDeltaMillis = currentGCStats.totalTimeMillis - this.lastGCStats.totalTimeMillis;
        double ratio = (double)gcTimeDeltaMillis / (double)timeDeltaMillis;
        if ((double)gcTimeDeltaMillis > 15000.0 && ratio > 0.5) {
            ((DirectPrinter)((DirectPrinter)((DirectPrinter)this.l().redBold()).a("GC warning").reset()).a(": %.1fs spent in %d GCs during the last stage, taking up %.2f%% of the time.", Utils.millisToSeconds(gcTimeDeltaMillis), currentGCStats.totalCount - this.lastGCStats.totalCount, ratio * 100.0)).println();
            ((DirectPrinter)this.l().a("            Please ensure more than %.2fGB of memory is available for Native Image", Utils.bytesToGiB(ProgressReporterCHelper.getPeakRSS()))).println();
            this.l().a("            to reduce GC overhead and improve image build time.").println();
        }
        this.lastGCStats = currentGCStats;
    }

    private static Timer getTimer(TimerCollection.Registry type) {
        return TimerCollection.singleton().get(type);
    }

    private static void resetANSIMode() {
        NativeImageSystemIOWrappers.singleton().getOut().print("\u001b[0m");
    }

    private void print(char text) {
        if (this.isEnabled) {
            this.builderIO.getOut().print(text);
        }
    }

    private void print(String text) {
        if (this.isEnabled) {
            this.builderIO.getOut().print(text);
        }
    }

    private void println() {
        if (this.isEnabled) {
            this.builderIO.getOut().println();
        }
    }

    private DirectPrinter l() {
        return this.linePrinter.a(this.outputPrefix);
    }

    public void reportStageProgress() {
        this.stagePrinter.reportProgress();
    }

    public void beforeNextStdioWrite() {
        this.stagePrinter.beforeNextStdioWrite();
    }

    static {
        IS_CI = System.console() == null || System.getenv("CI") != null;
        IS_DUMB_TERM = ProgressReporter.isDumbTerm();
        CODE_BREAKDOWN_TITLE = String.format("Top %d packages in code area:", 10);
        HEAP_BREAKDOWN_TITLE = String.format("Top %d object types in image heap:", 10);
        CHARACTERS_PER_LINE = IS_CI ? 120 : ProgressReporterCHelper.getTerminalWindowColumnsClamped();
    }

    private static class ANSI {
        static final String ESCAPE = "\u001b";
        static final String RESET = "\u001b[0m";
        static final String BOLD = "\u001b[1m";
        static final String DIM = "\u001b[2m";
        static final String LINK_START = "\u001b]8;;";
        static final String LINK_TEXT = "\u001b\\";
        static final String LINK_END = "\u001b]8;;\u001b\\";
        static final String LINK_FORMAT = "\u001b]8;;%s\u001b\\%s\u001b]8;;\u001b\\";
        static final String BLUE = "\u001b[0;34m";
        static final String RED_BOLD = "\u001b[1;31m";
        static final String YELLOW_BOLD = "\u001b[1;33m";
        static final String BLUE_BOLD = "\u001b[1;34m";

        private ANSI() {
        }
    }

    final class LinkyStrategy
    implements LinkStrategy {
        LinkyStrategy() {
        }

        @Override
        public void link(AbstractPrinter<?> printer, String text, String url) {
            ((AbstractPrinter)((AbstractPrinter)((AbstractPrinter)printer.a("\u001b]8;;" + url)).a("\u001b\\")).a(text)).a("\u001b]8;;\u001b\\");
        }

        @Override
        public String asDocLink(String text, String htmlAnchor) {
            return String.format("\u001b]8;;%s\u001b\\%s\u001b]8;;\u001b\\", ProgressReporter.STAGE_DOCS_URL + htmlAnchor, text);
        }
    }

    final class LinklessStrategy
    implements LinkStrategy {
        LinklessStrategy() {
        }

        @Override
        public void link(AbstractPrinter<?> printer, String text, String url) {
            printer.a(text);
        }

        @Override
        public String asDocLink(String text, String htmlAnchor) {
            return text;
        }
    }

    private static interface LinkStrategy {
        public void link(AbstractPrinter<?> var1, String var2, String var3);

        public String asDocLink(String var1, String var2);

        default public void link(AbstractPrinter<?> printer, Path path) {
            Path normalized = path.normalize();
            this.link(printer, normalized.toString(), normalized.toUri().toString());
        }

        default public void doclink(AbstractPrinter<?> printer, String text, String htmlAnchor) {
            this.link(printer, text, ProgressReporter.STAGE_DOCS_URL + htmlAnchor);
        }
    }

    final class ColorfulStrategy
    implements ColorStrategy {
        ColorfulStrategy() {
        }

        @Override
        public void bold(AbstractPrinter<?> printer) {
            printer.a("\u001b[1m");
        }

        @Override
        public void blue(AbstractPrinter<?> printer) {
            printer.a("\u001b[0;34m");
        }

        @Override
        public void blueBold(AbstractPrinter<?> printer) {
            printer.a("\u001b[1;34m");
        }

        @Override
        public void redBold(AbstractPrinter<?> printer) {
            printer.a("\u001b[1;31m");
        }

        @Override
        public void yellowBold(AbstractPrinter<?> printer) {
            printer.a("\u001b[1;33m");
        }

        @Override
        public void dim(AbstractPrinter<?> printer) {
            printer.a("\u001b[2m");
        }

        @Override
        public void reset(AbstractPrinter<?> printer) {
            printer.a("\u001b[0m");
        }

        @Override
        public void reset() {
            ProgressReporter.this.print("\u001b[0m");
        }
    }

    final class ColorlessStrategy
    implements ColorStrategy {
        ColorlessStrategy() {
        }
    }

    private static interface ColorStrategy {
        default public void bold(AbstractPrinter<?> printer) {
        }

        default public void blue(AbstractPrinter<?> printer) {
        }

        default public void blueBold(AbstractPrinter<?> printer) {
        }

        default public void redBold(AbstractPrinter<?> printer) {
        }

        default public void yellowBold(AbstractPrinter<?> printer) {
        }

        default public void dim(AbstractPrinter<?> printer) {
        }

        default public void reset(AbstractPrinter<?> printer) {
        }

        default public void reset() {
        }
    }

    final class CenteredTextPrinter
    extends LinePrinter<CenteredTextPrinter> {
        CenteredTextPrinter() {
        }

        @Override
        CenteredTextPrinter getThis() {
            return this;
        }

        @Override
        void flushln() {
            ProgressReporter.this.print(ProgressReporter.this.outputPrefix);
            String padding = Utils.stringFilledWith(Math.max(0, CHARACTERS_PER_LINE - this.getCurrentTextLength()) / 2, " ");
            ProgressReporter.this.print(padding);
            super.flushln();
        }
    }

    final class TwoColumnPrinter
    extends LinePrinter<TwoColumnPrinter> {
        TwoColumnPrinter() {
        }

        @Override
        TwoColumnPrinter getThis() {
            return this;
        }

        @Override
        TwoColumnPrinter a(String value) {
            super.a(value);
            return this;
        }

        TwoColumnPrinter jumpToMiddle() {
            int remaining = CHARACTERS_PER_LINE / 2 - this.getCurrentTextLength();
            assert (remaining >= 0) : "Column text too wide";
            this.a(Utils.stringFilledWith(remaining, " "));
            assert (!ProgressReporter.this.isEnabled || this.getCurrentTextLength() == CHARACTERS_PER_LINE / 2);
            return this;
        }

        @Override
        void flushln() {
            ProgressReporter.this.print(ProgressReporter.this.outputPrefix);
            super.flushln();
        }
    }

    final class CharacterwiseStagePrinter
    extends StagePrinter<CharacterwiseStagePrinter> {
        CharacterwiseStagePrinter() {
        }

        @Override
        CharacterwiseStagePrinter getThis() {
            return this;
        }

        @Override
        CharacterwiseStagePrinter a(String value) {
            ProgressReporter.this.print(value);
            return (CharacterwiseStagePrinter)super.a(value);
        }

        @Override
        CharacterwiseStagePrinter start(BuildStage stage) {
            super.start(stage);
            ProgressReporter.this.builderIO.progressReporter = ProgressReporter.this;
            return this.getThis();
        }

        @Override
        void reportProgress() {
            this.reprintLineIfNecessary();
            ProgressReporter.this.builderIO.progressReporter = null;
            super.reportProgress();
            ProgressReporter.this.builderIO.progressReporter = ProgressReporter.this;
        }

        @Override
        void end(double totalTime) {
            this.reprintLineIfNecessary();
            ProgressReporter.this.builderIO.progressReporter = null;
            super.end(totalTime);
        }

        void reprintLineIfNecessary() {
            if (ProgressReporter.this.builderIO.progressReporter == null) {
                this.printLineParts();
            }
        }

        @Override
        void flushln() {
            this.lineParts.clear();
            ProgressReporter.this.println();
        }

        @Override
        void beforeNextStdioWrite() {
            ProgressReporter.this.colorStrategy.reset();
            ProgressReporter.this.print('\r');
            int textLength = this.getCurrentTextLength();
            assert (textLength > 0) : "linePrinter expected to hold current line content";
            for (int i = 0; i <= textLength; ++i) {
                ProgressReporter.this.print(' ');
            }
            ProgressReporter.this.print('\r');
        }
    }

    final class LinewiseStagePrinter
    extends StagePrinter<LinewiseStagePrinter> {
        LinewiseStagePrinter() {
        }

        @Override
        LinewiseStagePrinter getThis() {
            return this;
        }

        @Override
        void beforeNextStdioWrite() {
            throw VMError.shouldNotReachHere("LinewiseStagePrinter not allowed to set builderIO.listenForNextStdioWrite");
        }
    }

    abstract class StagePrinter<T extends StagePrinter<T>>
    extends LinePrinter<T> {
        private int progressBarStart;
        private BuildStage activeBuildStage;
        private ScheduledFuture<?> periodicPrintingTask;

        StagePrinter() {
            this.progressBarStart = 30;
            this.activeBuildStage = null;
        }

        T start(BuildStage stage) {
            assert (this.activeBuildStage == null);
            this.activeBuildStage = stage;
            this.appendStageStart();
            if (this.activeBuildStage.hasProgressBar) {
                ((StagePrinter)((StagePrinter)this.a(this.progressBarStartPadding())).dim()).a("[");
            }
            if (this.activeBuildStage.hasPeriodicProgress) {
                this.startPeriodicProgress();
            }
            return (T)((StagePrinter)this.getThis());
        }

        private void startPeriodicProgress() {
            this.periodicPrintingTask = ProgressReporter.this.executor.scheduleAtFixedRate(new Runnable(){
                int countdown;
                int numPrints;

                @Override
                public void run() {
                    if (--this.countdown < 0) {
                        StagePrinter.this.reportProgress();
                        this.countdown = ++this.numPrints > 2 ? this.numPrints * 2 : this.numPrints;
                    }
                }
            }, 0L, 1L, TimeUnit.SECONDS);
        }

        final void skipped(BuildStage stage) {
            assert (this.activeBuildStage == null);
            this.activeBuildStage = stage;
            this.appendStageStart();
            ((StagePrinter)((StagePrinter)((StagePrinter)((StagePrinter)this.a(this.progressBarStartPadding())).dim()).a("(skipped)")).reset()).flushln();
            this.activeBuildStage = null;
        }

        private void appendStageStart() {
            ((StagePrinter)((StagePrinter)((StagePrinter)((StagePrinter)((StagePrinter)((StagePrinter)((StagePrinter)this.a(ProgressReporter.this.outputPrefix)).blue()).a(String.format("[%s/%s] ", 1 + this.activeBuildStage.ordinal(), BuildStage.NUM_STAGES))).reset()).blueBold()).doclink(this.activeBuildStage.message, "#stage-" + this.activeBuildStage.name().toLowerCase())).a("...")).reset();
        }

        final String progressBarStartPadding() {
            return Utils.stringFilledWith(this.progressBarStart - this.getCurrentTextLength(), " ");
        }

        void reportProgress() {
            this.a("*");
        }

        final void end(Timer timer) {
            this.end(timer.getTotalTime());
        }

        void end(double totalTime) {
            boolean optionsAvailable;
            if (this.activeBuildStage.hasPeriodicProgress) {
                this.periodicPrintingTask.cancel(false);
            }
            if (this.activeBuildStage.hasProgressBar) {
                ((StagePrinter)this.a("]")).reset();
            }
            String suffix = String.format("(%.1fs @ %.2fGB)", Utils.millisToSeconds(totalTime), Utils.getUsedMemory());
            int textLength = this.getCurrentTextLength();
            String padding = Utils.stringFilledWith(Math.max(0, CHARACTERS_PER_LINE - textLength - suffix.length()), " ");
            ((StagePrinter)((StagePrinter)((StagePrinter)((StagePrinter)this.a(padding)).dim()).a(suffix)).reset()).flushln();
            this.activeBuildStage = null;
            boolean bl = optionsAvailable = ImageSingletonsSupport.isInstalled() && ImageSingletons.contains(HostedOptionValues.class);
            if (optionsAvailable && SubstrateOptions.BuildOutputGCWarnings.getValue().booleanValue()) {
                ProgressReporter.this.checkForExcessiveGarbageCollection();
            }
        }

        abstract void beforeNextStdioWrite();
    }

    abstract class LinePrinter<T extends LinePrinter<T>>
    extends AbstractPrinter<T> {
        protected final List<String> lineParts;

        LinePrinter() {
            this.lineParts = new ArrayList<String>();
        }

        @Override
        T a(String value) {
            this.lineParts.add(value);
            return (T)((LinePrinter)this.getThis());
        }

        T l() {
            assert (this.lineParts.isEmpty());
            return (T)((LinePrinter)this.getThis());
        }

        final int getCurrentTextLength() {
            int textLength = 0;
            for (String text : this.lineParts) {
                if (text.startsWith("\u001b")) continue;
                textLength += text.length();
            }
            return textLength;
        }

        final void printLineParts() {
            this.lineParts.forEach(x$0 -> ProgressReporter.this.print((String)x$0));
        }

        void flushln() {
            this.printLineParts();
            this.lineParts.clear();
            ProgressReporter.this.println();
        }
    }

    final class DirectPrinter
    extends AbstractPrinter<DirectPrinter> {
        private final String headlineSeparator;
        private final String lineSeparator;

        DirectPrinter() {
            this.headlineSeparator = Utils.stringFilledWith(CHARACTERS_PER_LINE, "=");
            this.lineSeparator = Utils.stringFilledWith(CHARACTERS_PER_LINE, "-");
        }

        @Override
        DirectPrinter getThis() {
            return this;
        }

        @Override
        DirectPrinter a(String text) {
            ProgressReporter.this.print(text);
            return this;
        }

        void println() {
            ProgressReporter.this.println();
        }

        void printHeadlineSeparator() {
            ((DirectPrinter)((DirectPrinter)this.dim()).a(this.headlineSeparator).reset()).println();
        }

        void printLineSeparator() {
            ((DirectPrinter)((DirectPrinter)this.dim()).a(this.lineSeparator).reset()).println();
        }
    }

    abstract class AbstractPrinter<T extends AbstractPrinter<T>> {
        AbstractPrinter() {
        }

        abstract T getThis();

        abstract T a(String var1);

        final T a(String text, Object ... args) {
            return this.a(String.format(text, args));
        }

        final T a(int i) {
            return this.a(String.valueOf(i));
        }

        final T a(long i) {
            return this.a(String.valueOf(i));
        }

        final T bold() {
            ProgressReporter.this.colorStrategy.bold(this);
            return this.getThis();
        }

        final T blue() {
            ProgressReporter.this.colorStrategy.blue(this);
            return this.getThis();
        }

        final T blueBold() {
            ProgressReporter.this.colorStrategy.blueBold(this);
            return this.getThis();
        }

        final T redBold() {
            ProgressReporter.this.colorStrategy.redBold(this);
            return this.getThis();
        }

        final T yellowBold() {
            ProgressReporter.this.colorStrategy.yellowBold(this);
            return this.getThis();
        }

        final T dim() {
            ProgressReporter.this.colorStrategy.dim(this);
            return this.getThis();
        }

        final T reset() {
            ProgressReporter.this.colorStrategy.reset(this);
            return this.getThis();
        }

        final T link(String text, String url) {
            ProgressReporter.this.linkStrategy.link(this, text, url);
            return this.getThis();
        }

        final T link(Path path) {
            ProgressReporter.this.linkStrategy.link(this, path);
            return this.getThis();
        }

        final T doclink(String text, String htmlAnchor) {
            ProgressReporter.this.linkStrategy.doclink(this, text, htmlAnchor);
            return this.getThis();
        }
    }

    public static abstract class ReporterClosable
    implements AutoCloseable {
        @Override
        public void close() {
            this.closeAction();
        }

        abstract void closeAction();
    }

    @AutomaticFeature
    public static class ProgressReporterFeature
    implements Feature {
        private final ProgressReporter reporter = ProgressReporter.singleton();

        public void duringAnalysis(Feature.DuringAnalysisAccess access) {
            this.reporter.reportStageProgress();
        }
    }

    private static class GCStats {
        private final long totalCount;
        private final long totalTimeMillis;

        private static GCStats getCurrent() {
            long totalCount = 0L;
            long totalTime = 0L;
            for (GarbageCollectorMXBean bean : ManagementFactory.getGarbageCollectorMXBeans()) {
                long collectionTime;
                long collectionCount = bean.getCollectionCount();
                if (collectionCount > 0L) {
                    totalCount += collectionCount;
                }
                if ((collectionTime = bean.getCollectionTime()) <= 0L) continue;
                totalTime += collectionTime;
            }
            return new GCStats(totalCount, totalTime);
        }

        GCStats(long totalCount, long totalTime) {
            this.totalCount = totalCount;
            this.totalTimeMillis = totalTime;
        }
    }

    private static class Utils {
        private static final double MILLIS_TO_SECONDS = 1000.0;
        private static final double NANOS_TO_SECONDS = 1.0E9;
        private static final double BYTES_TO_KiB = 1024.0;
        private static final double BYTES_TO_MiB = 1048576.0;
        private static final double BYTES_TO_GiB = 1.073741824E9;
        private static final Field STRING_VALUE = ReflectionUtil.lookupField(String.class, (String)"value");

        private Utils() {
        }

        private static String bytesToHuman(long bytes) {
            return Utils.bytesToHuman("%4.2f", bytes);
        }

        private static String bytesToHuman(String format, long bytes) {
            if ((double)bytes < 1024.0) {
                return String.format(format, bytes) + "B";
            }
            if ((double)bytes < 1048576.0) {
                return String.format(format, Utils.bytesToKiB(bytes)) + "KB";
            }
            if ((double)bytes < 1.073741824E9) {
                return String.format(format, Utils.bytesToMiB(bytes)) + "MB";
            }
            return String.format(format, Utils.bytesToGiB(bytes)) + "GB";
        }

        private static double bytesToKiB(long bytes) {
            return (double)bytes / 1024.0;
        }

        private static double bytesToGiB(long bytes) {
            return (double)bytes / 1.073741824E9;
        }

        private static double bytesToMiB(long bytes) {
            return (double)bytes / 1048576.0;
        }

        private static double millisToSeconds(double millis) {
            return millis / 1000.0;
        }

        private static double nanosToSeconds(double nanos) {
            return nanos / 1.0E9;
        }

        private static int getInternalByteArrayLength(String string) {
            try {
                return ((byte[])STRING_VALUE.get(string)).length;
            }
            catch (ReflectiveOperationException ex) {
                throw VMError.shouldNotReachHere(ex);
            }
        }

        private static double getUsedMemory() {
            return Utils.bytesToGiB(Runtime.getRuntime().totalMemory() - Runtime.getRuntime().freeMemory());
        }

        private static String stringFilledWith(int size, String fill) {
            return new String(new char[size]).replace("\u0000", fill);
        }

        private static String truncateClassOrPackageName(String classOrPackageName) {
            int maxLength;
            int classNameLength = classOrPackageName.length();
            if (classNameLength <= (maxLength = CHARACTERS_PER_LINE / 2 - 10)) {
                return classOrPackageName;
            }
            StringBuilder sb = new StringBuilder();
            int currentDot = -1;
            while (true) {
                int nextDot;
                if ((nextDot = classOrPackageName.indexOf(46, currentDot + 1)) < 0) {
                    int restLength;
                    String rest = classOrPackageName.substring(currentDot + 1);
                    int sbLength = sb.length();
                    if (sbLength + (restLength = rest.length()) <= maxLength) {
                        sb.append(rest);
                        break;
                    }
                    int remainingSpaceDivBy2 = (maxLength - sbLength) / 2;
                    sb.append(rest.substring(0, remainingSpaceDivBy2 - 1) + "~" + rest.substring(restLength - remainingSpaceDivBy2, restLength));
                    break;
                }
                sb.append(classOrPackageName.charAt(currentDot + 1)).append('.');
                if (sb.length() + (classNameLength - nextDot) <= maxLength) {
                    sb.append(classOrPackageName.substring(nextDot + 1));
                    break;
                }
                currentDot = nextDot;
            }
            return sb.toString();
        }
    }

    private static enum BuildStage {
        INITIALIZING("Initializing"),
        ANALYSIS("Performing analysis", true, false),
        UNIVERSE("Building universe"),
        PARSING("Parsing methods", true, true),
        INLINING("Inlining methods", true, false),
        COMPILING("Compiling methods", true, true),
        CREATING("Creating image");

        private static final int NUM_STAGES;
        private final String message;
        private final boolean hasProgressBar;
        private final boolean hasPeriodicProgress;

        private BuildStage(String message) {
            this(message, false, false);
        }

        private BuildStage(String message, boolean hasProgressBar, boolean hasPeriodicProgress) {
            this.message = message;
            this.hasProgressBar = hasProgressBar;
            this.hasPeriodicProgress = hasPeriodicProgress;
        }

        static {
            NUM_STAGES = BuildStage.values().length;
        }
    }
}

