/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.svm.graal.meta;

import com.oracle.svm.graal.meta.SubstrateField;
import com.oracle.svm.graal.meta.SubstrateNodeFieldAccessor;
import com.oracle.svm.graal.meta.SubstrateNodeFieldIterator;
import com.oracle.svm.graal.meta.SubstrateType;
import com.oracle.truffle.api.nodes.Node;
import java.util.Iterator;
import java.util.NoSuchElementException;
import jdk.internal.misc.Unsafe;

class SubstrateNodeIterator
implements Iterator<Node> {
    private final Node node;
    private final SubstrateType type;
    private int nextFieldInType;
    private Object[] children;
    private int nextChildInChildren;
    private Node next;

    protected SubstrateNodeIterator(Node node, SubstrateType type) {
        this.node = node;
        this.type = type;
        this.computeNext();
    }

    private void computeNext() {
        if (this.computeNextFromChildren()) {
            return;
        }
        SubstrateField[] rawAllInstanceFields = this.type.rawAllInstanceFields;
        if (rawAllInstanceFields == null) {
            throw SubstrateNodeFieldIterator.noFieldsError(this.type);
        }
        SubstrateField[] fields = rawAllInstanceFields;
        while (this.nextFieldInType < fields.length) {
            SubstrateField field = fields[this.nextFieldInType];
            ++this.nextFieldInType;
            if (!this.computeNextFromField(field)) continue;
            return;
        }
        this.next = null;
    }

    private boolean computeNextFromField(SubstrateField field) {
        if (SubstrateNodeFieldAccessor.isChildField(field)) {
            long offset = field.getLocation();
            this.next = (Node)Unsafe.getUnsafe().getObject(this.node, offset);
            if (this.next != null) {
                return true;
            }
        } else if (SubstrateNodeFieldAccessor.isChildrenField(field)) {
            long offset = field.getLocation();
            this.children = (Object[])Unsafe.getUnsafe().getObject(this.node, offset);
            this.nextChildInChildren = 0;
            return this.computeNextFromChildren();
        }
        return false;
    }

    private boolean computeNextFromChildren() {
        if (this.children == null) {
            return false;
        }
        while (this.nextChildInChildren < this.children.length) {
            this.next = (Node)this.children[this.nextChildInChildren];
            ++this.nextChildInChildren;
            if (this.next == null) continue;
            return true;
        }
        this.children = null;
        this.nextChildInChildren = 0;
        return false;
    }

    @Override
    public boolean hasNext() {
        return this.next != null;
    }

    @Override
    public Node next() {
        Node result = this.next;
        if (result == null) {
            throw new NoSuchElementException();
        }
        this.computeNext();
        return result;
    }
}

