/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.svm.graal.hosted;

import com.oracle.graal.pointsto.meta.AnalysisField;
import com.oracle.graal.pointsto.meta.AnalysisMethod;
import com.oracle.graal.pointsto.meta.AnalysisType;
import com.oracle.svm.graal.hosted.GraalObjectReplacer;
import com.oracle.svm.hosted.meta.HostedField;
import com.oracle.svm.hosted.meta.HostedMethod;
import com.oracle.svm.hosted.meta.HostedType;
import com.oracle.svm.hosted.meta.HostedUniverse;
import com.oracle.svm.hosted.phases.StrengthenStampsPhase;
import jdk.vm.ci.meta.JavaField;
import jdk.vm.ci.meta.JavaMethod;
import jdk.vm.ci.meta.JavaType;
import jdk.vm.ci.meta.ResolvedJavaField;
import jdk.vm.ci.meta.ResolvedJavaMethod;
import jdk.vm.ci.meta.ResolvedJavaType;

class RuntimeStrengthenStampsPhase
extends StrengthenStampsPhase {
    private final HostedUniverse hUniverse;
    private final GraalObjectReplacer objectReplacer;

    RuntimeStrengthenStampsPhase(HostedUniverse hUniverse, GraalObjectReplacer objectReplacer) {
        this.hUniverse = hUniverse;
        this.objectReplacer = objectReplacer;
    }

    @Override
    protected HostedType toHosted(ResolvedJavaType type) {
        if (type == null) {
            return null;
        }
        assert (type instanceof AnalysisType);
        return this.hUniverse.lookup((JavaType)type);
    }

    @Override
    protected HostedMethod toHosted(ResolvedJavaMethod method) {
        if (method == null) {
            return null;
        }
        assert (method instanceof AnalysisMethod);
        return this.hUniverse.lookup((JavaMethod)method);
    }

    @Override
    protected HostedField toHosted(ResolvedJavaField field) {
        if (field == null) {
            return null;
        }
        assert (field instanceof AnalysisField);
        return this.hUniverse.lookup((JavaField)field);
    }

    @Override
    protected ResolvedJavaType toTarget(ResolvedJavaType type) {
        AnalysisType result = ((HostedType)type).getWrapped();
        if (!this.objectReplacer.typeCreated((JavaType)result)) {
            return null;
        }
        return result;
    }
}

