/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.svm.core.thread;

import com.oracle.svm.core.RuntimeAssertionsSupport;
import com.oracle.svm.core.thread.SubstrateVirtualThread;
import com.oracle.svm.core.thread.VirtualThreads;
import com.oracle.svm.core.util.VMError;
import java.util.concurrent.Executor;
import java.util.concurrent.ForkJoinPool;
import java.util.concurrent.ForkJoinWorkerThread;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.TimeUnit;
import org.graalvm.compiler.api.replacements.Fold;

final class SubstrateVirtualThreads
implements VirtualThreads {
    private static final Thread.UncaughtExceptionHandler UNCAUGHT_EXCEPTION_HANDLER = (t, e) -> {
        if (SubstrateVirtualThreads.haveAssertions()) {
            throw VMError.shouldNotReachHere("Exception in continuation or virtual thread code", e);
        }
    };
    static final ForkJoinPool SCHEDULER = new ForkJoinPool(Short.MAX_VALUE, CarrierThread::new, UNCAUGHT_EXCEPTION_HANDLER, true);

    SubstrateVirtualThreads() {
    }

    @Fold
    static boolean haveAssertions() {
        return RuntimeAssertionsSupport.singleton().desiredAssertionStatus(SubstrateVirtualThreads.class);
    }

    private static SubstrateVirtualThread cast(Thread thread) {
        return (SubstrateVirtualThread)thread;
    }

    private static SubstrateVirtualThread current() {
        return (SubstrateVirtualThread)Thread.currentThread();
    }

    @Override
    public ThreadFactory createFactory() {
        return task -> new SubstrateVirtualThread(null, task);
    }

    @Override
    public boolean isVirtual(Thread thread) {
        return thread instanceof SubstrateVirtualThread;
    }

    @Override
    public boolean getAndClearInterrupt(Thread thread) {
        return SubstrateVirtualThreads.cast(thread).getAndClearInterrupt();
    }

    @Override
    public void join(Thread thread, long millis) throws InterruptedException {
        if (thread.isAlive()) {
            long nanos = TimeUnit.MILLISECONDS.toNanos(millis);
            ((SubstrateVirtualThread)thread).joinNanos(nanos);
        }
    }

    @Override
    public void yield() {
        SubstrateVirtualThreads.current().tryYield();
    }

    @Override
    public void sleepMillis(long millis) throws InterruptedException {
        long nanos = TimeUnit.NANOSECONDS.convert(millis, TimeUnit.MILLISECONDS);
        SubstrateVirtualThreads.current().sleepNanos(nanos);
    }

    @Override
    public boolean isAlive(Thread thread) {
        Thread.State state = thread.getState();
        return state != Thread.State.NEW && state != Thread.State.TERMINATED;
    }

    @Override
    public void unpark(Thread thread) {
        SubstrateVirtualThreads.cast(thread).unpark();
    }

    @Override
    public void park() {
        SubstrateVirtualThreads.current().park();
    }

    @Override
    public void parkNanos(long nanos) {
        SubstrateVirtualThreads.current().parkNanos(nanos);
    }

    @Override
    public void parkUntil(long deadline) {
        SubstrateVirtualThreads.current().parkUntil(deadline);
    }

    @Override
    public void pinCurrent() {
        SubstrateVirtualThreads.current().pin();
    }

    @Override
    public void unpinCurrent() {
        SubstrateVirtualThreads.current().unpin();
    }

    @Override
    public Executor getScheduler(Thread thread) {
        return SubstrateVirtualThreads.cast(thread).getScheduler();
    }

    private static final class CarrierThread
    extends ForkJoinWorkerThread {
        CarrierThread(ForkJoinPool pool) {
            super(pool);
        }

        @Override
        public void setUncaughtExceptionHandler(Thread.UncaughtExceptionHandler eh) {
        }

        @Override
        protected void onTermination(Throwable exception) {
            if (exception != null) {
                throw VMError.shouldNotReachHere("Carrier thread must not terminate abnormally because it cancels pending tasks which can result in virtual threads never being scheduled again.", exception);
            }
        }
    }
}

