/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.svm.core.thread;

import com.oracle.svm.core.monitor.MonitorSupport;
import com.oracle.svm.core.stack.JavaFrameAnchor;
import com.oracle.svm.core.stack.JavaFrameAnchors;
import com.oracle.svm.core.thread.Continuation;
import com.oracle.svm.core.thread.JavaThreads;
import com.oracle.svm.core.thread.PlatformThreads;
import com.oracle.svm.core.thread.SubstrateVirtualThreads;
import com.oracle.svm.core.thread.Target_jdk_internal_misc_InnocuousThread;
import java.util.Locale;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.Executor;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.ScheduledFuture;
import java.util.concurrent.ScheduledThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import jdk.internal.misc.Unsafe;
import org.graalvm.word.UnsignedWord;

final class SubstrateVirtualThread
extends Thread {
    private static final Unsafe U = Unsafe.getUnsafe();
    private static final ScheduledExecutorService UNPARKER = SubstrateVirtualThread.createDelayedTaskScheduler();
    private static final long STATE = U.objectFieldOffset(SubstrateVirtualThread.class, "state");
    private static final long PARK_PERMIT = U.objectFieldOffset(SubstrateVirtualThread.class, "parkPermit");
    private static final long CARRIER_THREAD = U.objectFieldOffset(SubstrateVirtualThread.class, "carrierThread");
    private static final long TERMINATION = U.objectFieldOffset(SubstrateVirtualThread.class, "termination");
    private final Executor scheduler;
    private final Continuation cont;
    private final Runnable runContinuation;
    private volatile int state;
    private static final int NEW = 0;
    private static final int STARTED = 1;
    private static final int RUNNABLE = 2;
    private static final int RUNNING = 3;
    private static final int PARKING = 4;
    private static final int PARKED = 5;
    private static final int PINNED = 6;
    private static final int YIELDING = 7;
    private static final int TERMINATED = 99;
    private static final int SUSPENDED = 256;
    private static final int RUNNABLE_SUSPENDED = 258;
    private static final int PARKED_SUSPENDED = 261;
    private volatile boolean parkPermit;
    private volatile Thread carrierThread;
    private volatile CountDownLatch termination;
    private short pins;

    SubstrateVirtualThread(Executor scheduler, Runnable task) {
        super(task);
        Thread parent;
        this.scheduler = scheduler == null ? ((parent = Thread.currentThread()) instanceof SubstrateVirtualThread ? ((SubstrateVirtualThread)parent).scheduler : SubstrateVirtualThreads.SCHEDULER) : scheduler;
        this.cont = new Continuation(() -> this.run(task));
        this.runContinuation = this::runContinuation;
    }

    private void runContinuation() {
        if (Thread.currentThread() instanceof SubstrateVirtualThread) {
            throw new RuntimeException("Virtual thread was scheduled on another virtual thread");
        }
        int initialState = this.state();
        if (initialState != 1 || !this.compareAndSetState(1, 3)) {
            if (initialState == 2 && this.compareAndSetState(2, 3)) {
                this.setParkPermit(false);
            } else {
                return;
            }
        }
        try {
            this.cont.enter();
        }
        finally {
            if (this.cont.isDone()) {
                this.afterTerminate();
            } else {
                this.afterYield();
            }
        }
    }

    private void submitRunContinuation() {
        this.scheduler.execute(this.runContinuation);
    }

    private void run(Runnable task) {
        assert (this.state == 3);
        this.mount();
        try {
            task.run();
        }
        catch (Throwable exc) {
            this.dispatchUncaughtException(exc);
        }
        finally {
            this.unmount();
            this.setState(99);
        }
    }

    private void mount() {
        Thread carrier = PlatformThreads.currentThread.get();
        this.setCarrierThread(carrier);
        if (JavaThreads.isInterrupted(this)) {
            PlatformThreads.setInterrupt(carrier);
        } else if (JavaThreads.isInterrupted(carrier)) {
            Object token = this.switchToCarrierAndAcquireInterruptLock();
            try {
                if (!JavaThreads.isInterrupted(this)) {
                    JavaThreads.getAndClearInterruptedFlag(carrier);
                }
            }
            finally {
                this.releaseInterruptLockAndSwitchBack(token);
            }
        }
        PlatformThreads.setCurrentThread(carrier, this);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void unmount() {
        Thread carrier = this.carrierThread;
        PlatformThreads.setCurrentThread(carrier, carrier);
        Object object = this.interruptLock();
        synchronized (object) {
            this.setCarrierThread(null);
        }
        JavaThreads.getAndClearInterruptedFlag(carrier);
    }

    private boolean yieldContinuation() {
        assert (this == Thread.currentThread());
        if (this.pins > 0) {
            return false;
        }
        JavaFrameAnchor anchor = JavaFrameAnchors.getFrameAnchor();
        if (anchor.isNonNull() && this.cont.getBottomSP().aboveThan((UnsignedWord)anchor.getLastJavaSP())) {
            return false;
        }
        this.unmount();
        try {
            boolean bl = this.cont.yield() == 0;
            return bl;
        }
        finally {
            this.mount();
        }
    }

    private void afterYield() {
        int s = this.state();
        assert ((s == 4 || s == 7) && this.carrierThread == null);
        if (s == 4) {
            this.setState(5);
            if (this.parkPermit && this.compareAndSetState(5, 2)) {
                this.submitRunContinuation();
            }
        } else if (s == 7) {
            this.setState(2);
            this.submitRunContinuation();
        }
    }

    private void afterTerminate() {
        assert (this.state() == 99 && this.carrierThread == null);
        CountDownLatch termination = this.termination;
        if (termination != null) {
            assert (termination.getCount() == 1L);
            termination.countDown();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void parkOnCarrierThread(boolean timed, long nanos) {
        assert (this.state() == 4);
        this.setState(6);
        try {
            if (!this.parkPermit) {
                if (!timed) {
                    U.park(false, 0L);
                } else if (nanos > 0L) {
                    U.park(false, nanos);
                }
            }
        }
        finally {
            this.setState(3);
        }
        this.setParkPermit(false);
    }

    @Override
    public void start() {
        if (!this.compareAndSetState(0, 1)) {
            throw new IllegalThreadStateException("Already started");
        }
        boolean started = false;
        try {
            this.submitRunContinuation();
            started = true;
        }
        finally {
            if (!started) {
                this.setState(99);
                this.afterTerminate();
            }
        }
    }

    void park() {
        assert (Thread.currentThread() == this);
        if (this.getAndSetParkPermit(false) || this.isInterrupted()) {
            return;
        }
        this.setState(4);
        try {
            if (!this.yieldContinuation()) {
                this.parkOnCarrierThread(false, 0L);
            }
        }
        finally {
            assert (Thread.currentThread() == this && this.state() == 3);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void parkNanos(long nanos) {
        assert (Thread.currentThread() == this);
        if (this.getAndSetParkPermit(false) || this.isInterrupted()) {
            return;
        }
        if (nanos > 0L) {
            boolean yielded;
            long startTime = System.nanoTime();
            Future<?> unparker = this.scheduleUnpark(nanos);
            this.setState(4);
            try {
                yielded = this.yieldContinuation();
            }
            finally {
                assert (Thread.currentThread() == this && (this.state() == 3 || this.state() == 4));
                this.cancel(unparker);
            }
            if (!yielded) {
                long deadline = startTime + nanos;
                if (deadline < 0L) {
                    deadline = Long.MAX_VALUE;
                }
                this.parkOnCarrierThread(true, deadline - System.nanoTime());
            }
        }
    }

    void parkUntil(long deadline) {
        long millis = deadline - System.currentTimeMillis();
        long nanos = TimeUnit.NANOSECONDS.convert(millis, TimeUnit.MILLISECONDS);
        this.parkNanos(nanos);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Future<?> scheduleUnpark(long nanos) {
        Thread carrier = this.carrierThread;
        PlatformThreads.setCurrentThread(carrier, carrier);
        try {
            ScheduledFuture<?> scheduledFuture = UNPARKER.schedule(this::unpark, nanos, TimeUnit.NANOSECONDS);
            return scheduledFuture;
        }
        finally {
            PlatformThreads.setCurrentThread(carrier, this);
        }
    }

    private void cancel(Future<?> future) {
        if (!future.isDone()) {
            Thread carrier = this.carrierThread;
            PlatformThreads.setCurrentThread(carrier, carrier);
            try {
                future.cancel(false);
            }
            finally {
                PlatformThreads.setCurrentThread(carrier, this);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void unpark() {
        Thread currentThread = Thread.currentThread();
        if (!this.getAndSetParkPermit(true) && currentThread != this) {
            int s = this.state();
            if (s == 5 && this.compareAndSetState(5, 2)) {
                if (currentThread instanceof SubstrateVirtualThread) {
                    SubstrateVirtualThread vthread = (SubstrateVirtualThread)currentThread;
                    Thread carrier = vthread.carrierThread;
                    PlatformThreads.setCurrentThread(carrier, carrier);
                    try {
                        this.submitRunContinuation();
                    }
                    finally {
                        PlatformThreads.setCurrentThread(carrier, vthread);
                    }
                } else {
                    this.submitRunContinuation();
                }
            } else if (s == 6) {
                Object token = this.switchToCarrierAndAcquireInterruptLock();
                try {
                    Thread carrier = this.carrierThread;
                    if (carrier != null && this.state() == 6) {
                        Unsafe.getUnsafe().unpark(carrier);
                    }
                }
                finally {
                    this.releaseInterruptLockAndSwitchBack(token);
                }
            }
        }
    }

    void tryYield() {
        assert (Thread.currentThread() == this);
        this.setState(7);
        try {
            this.yieldContinuation();
        }
        finally {
            assert (Thread.currentThread() == this);
            if (this.state() != 3) {
                assert (this.state() == 7);
                this.setState(3);
            }
        }
    }

    boolean joinNanos(long nanos) throws InterruptedException {
        if (this.state() == 99) {
            return true;
        }
        CountDownLatch termination = this.getTermination();
        if (this.state() == 99) {
            return true;
        }
        if (nanos == 0L) {
            termination.await();
        } else {
            boolean terminated = termination.await(nanos, TimeUnit.NANOSECONDS);
            if (!terminated) {
                return false;
            }
        }
        assert (this.state() == 99);
        return true;
    }

    private Object interruptLock() {
        return JavaThreads.toTarget((Thread)this).blockerLock;
    }

    private Object switchToCarrierAndAcquireInterruptLock() {
        SubstrateVirtualThread token = null;
        Thread current = Thread.currentThread();
        if (current instanceof SubstrateVirtualThread) {
            SubstrateVirtualThread vthread = (SubstrateVirtualThread)current;
            Thread carrier = vthread.carrierThread;
            PlatformThreads.setCurrentThread(carrier, carrier);
            token = vthread;
        }
        MonitorSupport.singleton().monitorEnter(this.interruptLock());
        return token;
    }

    private void releaseInterruptLockAndSwitchBack(Object token) {
        MonitorSupport.singleton().monitorExit(this.interruptLock());
        if (token != null) {
            SubstrateVirtualThread vthread = (SubstrateVirtualThread)token;
            PlatformThreads.setCurrentThread(vthread.carrierThread, vthread);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Unable to fully structure code
     */
    @Override
    public void interrupt() {
        if (Thread.currentThread() != this) {
            token = this.switchToCarrierAndAcquireInterruptLock();
            try {
                JavaThreads.writeInterruptedFlag(this, true);
                b = JavaThreads.toTarget((Thread)this).blocker;
                if (b != null) {
                    b.interrupt(this);
                }
                if ((carrier = this.carrierThread) == null) ** GOTO lbl16
                PlatformThreads.setInterrupt(carrier);
            }
            finally {
                this.releaseInterruptLockAndSwitchBack(token);
            }
        } else {
            JavaThreads.writeInterruptedFlag(this, true);
            PlatformThreads.setInterrupt(this.carrierThread);
        }
lbl16:
        // 3 sources

        this.unpark();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    boolean getAndClearInterrupt() {
        assert (Thread.currentThread() == this);
        Object token = this.switchToCarrierAndAcquireInterruptLock();
        try {
            boolean oldValue = JavaThreads.getAndClearInterruptedFlag(this);
            JavaThreads.getAndClearInterruptedFlag(this.carrierThread);
            boolean bl = oldValue;
            return bl;
        }
        finally {
            this.releaseInterruptLockAndSwitchBack(token);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void sleepNanos(long nanos) throws InterruptedException {
        assert (Thread.currentThread() == this);
        if (nanos >= 0L) {
            if (JavaThreads.getAndClearInterrupt(this)) {
                throw new InterruptedException();
            }
            if (nanos == 0L) {
                this.tryYield();
            } else {
                try {
                    long remainingNanos = nanos;
                    long startNanos = System.nanoTime();
                    while (remainingNanos > 0L) {
                        this.parkNanos(remainingNanos);
                        if (JavaThreads.getAndClearInterrupt(this)) {
                            throw new InterruptedException();
                        }
                        remainingNanos = nanos - (System.nanoTime() - startNanos);
                    }
                }
                finally {
                    this.setParkPermit(true);
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Thread.State getState() {
        switch (this.state()) {
            case 0: {
                return Thread.State.NEW;
            }
            case 1: 
            case 2: 
            case 258: {
                return Thread.State.RUNNABLE;
            }
            case 3: {
                Object token = this.switchToCarrierAndAcquireInterruptLock();
                try {
                    Thread carrierThread = this.carrierThread;
                    if (carrierThread != null) {
                        Thread.State state = JavaThreads.getThreadState(carrierThread);
                        return state;
                    }
                }
                finally {
                    this.releaseInterruptLockAndSwitchBack(token);
                }
                return Thread.State.RUNNABLE;
            }
            case 4: 
            case 7: {
                return Thread.State.RUNNABLE;
            }
            case 5: 
            case 6: 
            case 261: {
                return Thread.State.WAITING;
            }
            case 99: {
                return Thread.State.TERMINATED;
            }
        }
        throw new InternalError();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder("VirtualThread[#");
        sb.append(this.getId());
        String name = this.getName();
        if (!name.isEmpty() && !name.equals("<unnamed>")) {
            sb.append(",");
            sb.append(name);
        }
        sb.append("]/");
        Thread carrier = this.carrierThread;
        if (carrier != null) {
            Object token = this.switchToCarrierAndAcquireInterruptLock();
            try {
                carrier = this.carrierThread;
                if (carrier != null) {
                    String stateAsString = JavaThreads.getThreadState(carrier).toString();
                    sb.append(stateAsString.toLowerCase(Locale.ROOT));
                    sb.append('@');
                    sb.append(carrier.getName());
                }
            }
            finally {
                this.releaseInterruptLockAndSwitchBack(token);
            }
        }
        if (carrier == null) {
            String stateAsString = this.getState().toString();
            sb.append(stateAsString.toLowerCase(Locale.ROOT));
        }
        return sb.toString();
    }

    public int hashCode() {
        return (int)this.getId();
    }

    public boolean equals(Object obj) {
        return obj == this;
    }

    private CountDownLatch getTermination() {
        CountDownLatch termination = this.termination;
        if (termination == null && !U.compareAndSetObject(this, TERMINATION, null, termination = new CountDownLatch(1))) {
            termination = this.termination;
        }
        return termination;
    }

    private int state() {
        return this.state;
    }

    private void setState(int newValue) {
        this.state = newValue;
    }

    private boolean compareAndSetState(int expectedValue, int newValue) {
        return U.compareAndSetInt(this, STATE, expectedValue, newValue);
    }

    private void setParkPermit(boolean newValue) {
        if (this.parkPermit != newValue) {
            this.parkPermit = newValue;
        }
    }

    private boolean getAndSetParkPermit(boolean newValue) {
        if (this.parkPermit != newValue) {
            return U.getAndSetBoolean(this, PARK_PERMIT, newValue);
        }
        return newValue;
    }

    private void setCarrierThread(Thread carrier) {
        U.putObjectRelease(this, CARRIER_THREAD, carrier);
    }

    private void dispatchUncaughtException(Throwable e) {
        this.getUncaughtExceptionHandler().uncaughtException(this, e);
    }

    void pin() {
        assert (SubstrateVirtualThread.currentThread() == this);
        assert (this.pins >= 0);
        if (this.pins == Short.MAX_VALUE) {
            throw new IllegalStateException("Too many pins");
        }
        this.pins = (short)(this.pins + 1);
    }

    void unpin() {
        assert (SubstrateVirtualThread.currentThread() == this);
        assert (this.pins >= 0);
        if (this.pins == 0) {
            throw new IllegalStateException("Not pinned");
        }
        this.pins = (short)(this.pins - 1);
    }

    @Override
    public void run() {
    }

    Executor getScheduler() {
        return this.scheduler;
    }

    private static ScheduledExecutorService createDelayedTaskScheduler() {
        int poolSize = 1;
        ScheduledThreadPoolExecutor dts = (ScheduledThreadPoolExecutor)Executors.newScheduledThreadPool(poolSize, task -> Target_jdk_internal_misc_InnocuousThread.newThread("VirtualThread-unparker", task));
        dts.setRemoveOnCancelPolicy(true);
        return dts;
    }
}

