/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.svm.core.reflect;

import com.oracle.svm.core.annotate.InvokeJavaFunctionPointer;
import com.oracle.svm.core.jdk.InternalVMMethod;
import com.oracle.svm.core.util.VMError;
import java.lang.reflect.Executable;
import jdk.internal.reflect.MethodAccessor;
import org.graalvm.nativeimage.c.function.CFunctionPointer;

@InternalVMMethod
public final class SubstrateMethodAccessor
implements MethodAccessor {
    private final Executable member;
    private final CFunctionPointer invokeFunctionPointer;

    public SubstrateMethodAccessor(Executable member, CFunctionPointer invokeFunctionPointer) {
        this.member = member;
        this.invokeFunctionPointer = invokeFunctionPointer;
    }

    @Override
    public Object invoke(Object obj, Object[] args) {
        MethodInvokeFunctionPointer functionPointer = (MethodInvokeFunctionPointer)this.invokeFunctionPointer;
        if (functionPointer.isNull()) {
            throw this.invokeError();
        }
        return functionPointer.invoke(false, obj, args);
    }

    private RuntimeException invokeError() {
        throw VMError.shouldNotReachHere("No SubstrateMethodAccessor.invokeFunctionPointer for " + this.member);
    }

    public Object invokeSpecial(Object obj, Object[] args) {
        MethodInvokeFunctionPointer functionPointer = (MethodInvokeFunctionPointer)this.invokeFunctionPointer;
        if (functionPointer.isNull()) {
            throw this.invokeError();
        }
        return functionPointer.invoke(true, obj, args);
    }

    static interface MethodInvokeFunctionPointer
    extends CFunctionPointer {
        @InvokeJavaFunctionPointer
        public Object invoke(boolean var1, Object var2, Object[] var3);
    }
}

