/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.svm.core.option;

import com.oracle.svm.common.option.CommonOptionParser;
import com.oracle.svm.common.option.UnsupportedOptionClassException;
import com.oracle.svm.core.option.APIOption;
import com.oracle.svm.core.option.HostedOptionKey;
import com.oracle.svm.core.option.RuntimeOptionKey;
import com.oracle.svm.core.util.InterruptImageBuilding;
import com.oracle.svm.core.util.VMError;
import java.io.PrintStream;
import java.lang.reflect.Field;
import java.util.Arrays;
import java.util.ServiceLoader;
import java.util.Set;
import java.util.function.Consumer;
import java.util.function.Predicate;
import org.graalvm.collections.EconomicMap;
import org.graalvm.compiler.options.OptionDescriptor;
import org.graalvm.compiler.options.OptionDescriptors;
import org.graalvm.compiler.options.OptionKey;
import org.graalvm.nativeimage.Platform;
import org.graalvm.nativeimage.Platforms;

public class SubstrateOptionsParser {
    public static final String HOSTED_OPTION_PREFIX = "-H:";
    public static final String RUNTIME_OPTION_PREFIX = "-R:";

    static CommonOptionParser.OptionParseResult parseOption(EconomicMap<String, OptionDescriptor> options, Predicate<OptionKey<?>> isHosted, String option, EconomicMap<OptionKey<?>, Object> valuesMap, String optionPrefix, CommonOptionParser.BooleanOptionFormat booleanOptionFormat) {
        try {
            return CommonOptionParser.parseOption(options, isHosted, (String)option, valuesMap, (String)optionPrefix, (CommonOptionParser.BooleanOptionFormat)booleanOptionFormat);
        }
        catch (UnsupportedOptionClassException e) {
            VMError.shouldNotReachHere(e.getMessage());
            return null;
        }
    }

    public static boolean parseHostedOption(String optionPrefix, EconomicMap<String, OptionDescriptor> options, EconomicMap<OptionKey<?>, Object> valuesMap, CommonOptionParser.BooleanOptionFormat booleanOptionFormat, Set<String> errors, String arg, PrintStream out) {
        if (!arg.startsWith(optionPrefix)) {
            return false;
        }
        Predicate<OptionKey<?>> isHosted = optionKey -> optionKey instanceof HostedOptionKey;
        CommonOptionParser.OptionParseResult optionParseResult = SubstrateOptionsParser.parseOption(options, isHosted, arg.substring(optionPrefix.length()), valuesMap, optionPrefix, booleanOptionFormat);
        if (optionParseResult.printFlags() || optionParseResult.printFlagsWithExtraHelp()) {
            SubstrateOptionsParser.printFlags(d -> {
                OptionKey key = d.getOptionKey();
                return optionParseResult.matchesFlags(d, key instanceof RuntimeOptionKey || key instanceof HostedOptionKey);
            }, options, optionPrefix, out, optionParseResult.printFlagsWithExtraHelp());
            throw new InterruptImageBuilding("");
        }
        if (!optionParseResult.isValid()) {
            errors.add(optionParseResult.getError());
            return true;
        }
        OptionKey option = optionParseResult.getOptionKey();
        OptionDescriptor descriptor = option.getDescriptor();
        if (descriptor != null && descriptor.isDeprecated()) {
            String message = "Warning: Option '" + descriptor.getName() + "' is deprecated and might be removed from future versions";
            String deprecationMessage = descriptor.getDeprecationMessage();
            if (deprecationMessage != null && !deprecationMessage.isEmpty()) {
                message = message + ": " + deprecationMessage;
            }
            System.err.println(message);
        }
        return true;
    }

    public static void collectOptions(ServiceLoader<OptionDescriptors> optionDescriptors, Consumer<OptionDescriptor> optionDescriptorConsumer) {
        CommonOptionParser.collectOptions(optionDescriptors, optionDescriptorConsumer);
    }

    public static void printOption(Consumer<String> println, String option, String description, int indentation, int optionWidth, int wrapWidth) {
        CommonOptionParser.printOption(println, (String)option, (String)description, (int)indentation, (int)optionWidth, (int)wrapWidth);
    }

    static void printFlags(Predicate<OptionDescriptor> filter, EconomicMap<String, OptionDescriptor> options, String prefix, PrintStream out, boolean verbose) {
        CommonOptionParser.printFlags(filter, options, (String)prefix, (PrintStream)out, (boolean)verbose);
    }

    public static long parseLong(String v) {
        return CommonOptionParser.parseLong((String)v);
    }

    public static double parseDouble(String v) {
        return CommonOptionParser.parseDouble((String)v);
    }

    @Platforms(value={Platform.HOSTED_ONLY.class})
    public static String commandArgument(OptionKey<?> option, String value) {
        return SubstrateOptionsParser.commandArgument(option, value, null);
    }

    @Platforms(value={Platform.HOSTED_ONLY.class})
    public static String commandArgument(OptionKey<?> option, String value, String apiOptionName) {
        String selected;
        APIOption[] apiOptions;
        Field field;
        try {
            field = option.getDescriptor().getDeclaringClass().getDeclaredField(option.getDescriptor().getFieldName());
        }
        catch (ReflectiveOperationException ex) {
            throw VMError.shouldNotReachHere(ex);
        }
        for (APIOption apiOption : apiOptions = (APIOption[])field.getAnnotationsByType(APIOption.class)) {
            selected = SubstrateOptionsParser.selectVariant(apiOption, apiOptionName);
            assert (selected == null || apiOption.deprecated().equals("")) : "Using the deprecated option in a description: " + apiOption;
        }
        if (option.getDescriptor().getOptionValueType() == Boolean.class) {
            VMError.guarantee(value.equals("+") || value.equals("-"), "Boolean option value can be only + or -");
            for (APIOption apiOption : apiOptions) {
                String apiValue;
                selected = SubstrateOptionsParser.selectVariant(apiOption, apiOptionName);
                if (selected == null) continue;
                String string = apiValue = apiOption.kind() == APIOption.APIOptionKind.Negated ? "-" : "+";
                if (!apiValue.equals(value)) continue;
                return APIOption.Utils.optionName(selected);
            }
            return HOSTED_OPTION_PREFIX + value + option;
        }
        Object apiOptionWithValue = null;
        for (APIOption apiOption : apiOptions) {
            String selected2 = SubstrateOptionsParser.selectVariant(apiOption, apiOptionName);
            if (selected2 == null) continue;
            String optionName = APIOption.Utils.optionName(selected2);
            if (apiOption.fixedValue().length == 0) {
                if (apiOptionWithValue != null) continue;
                if (Arrays.equals(apiOption.defaultValue(), new String[]{value})) {
                    apiOptionWithValue = optionName;
                    continue;
                }
                apiOptionWithValue = optionName + apiOption.valueSeparator()[0] + value;
                continue;
            }
            if (!apiOption.fixedValue()[0].equals(value)) continue;
            return optionName;
        }
        if (apiOptionWithValue != null) {
            return apiOptionWithValue;
        }
        assert (apiOptionName == null) : "invalid API option name " + apiOptionName;
        return HOSTED_OPTION_PREFIX + option.getName() + "=" + value;
    }

    private static String selectVariant(APIOption apiOption, String apiOptionName) {
        VMError.guarantee(apiOption.name().length > 0, "APIOption requires at least one name");
        if (apiOptionName == null) {
            return apiOption.name()[0];
        }
        if (Arrays.asList(apiOption.name()).contains(apiOptionName)) {
            return apiOptionName;
        }
        return null;
    }
}

