/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.svm.core.jfr;

import com.oracle.svm.core.SubstrateOptions;
import com.oracle.svm.core.annotate.Uninterruptible;
import com.oracle.svm.core.jfr.JfrChunkWriter;
import com.oracle.svm.core.jfr.JfrConstantPool;
import org.graalvm.nativeimage.Platform;
import org.graalvm.nativeimage.Platforms;

public class JfrStackTraceRepository
implements JfrConstantPool {
    private int depth = SubstrateOptions.MaxJavaStackTraceDepth.getValue();

    @Platforms(value={Platform.HOSTED_ONLY.class})
    JfrStackTraceRepository() {
    }

    public void teardown() {
    }

    @Uninterruptible(reason="Epoch must not change while in this method.")
    public long getStackTraceId(int skipCount, boolean previousEpoch) {
        assert (this.depth >= 0);
        return 0L;
    }

    public void setStackTraceDepth(int depth) {
        if (depth < 0 || depth > SubstrateOptions.MaxJavaStackTraceDepth.getValue()) {
            throw new IllegalArgumentException("StackTrace depth (" + depth + ") is not in a valid range!");
        }
        this.depth = depth;
    }

    @Override
    public int write(JfrChunkWriter writer) {
        return 0;
    }
}

