/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.svm.core.jfr;

import com.oracle.svm.core.UnmanagedMemoryUtil;
import com.oracle.svm.core.annotate.Uninterruptible;
import com.oracle.svm.core.jfr.JfrBuffer;
import com.oracle.svm.core.jfr.JfrBufferAccess;
import com.oracle.svm.core.jfr.JfrBufferType;
import com.oracle.svm.core.jfr.JfrBuffers;
import com.oracle.svm.core.jfr.JfrRecorderThread;
import com.oracle.svm.core.jfr.SubstrateJVM;
import org.graalvm.nativeimage.Platform;
import org.graalvm.nativeimage.Platforms;
import org.graalvm.nativeimage.UnmanagedMemory;
import org.graalvm.nativeimage.c.struct.SizeOf;
import org.graalvm.word.PointerBase;
import org.graalvm.word.UnsignedWord;
import org.graalvm.word.WordFactory;

public class JfrGlobalMemory {
    private static final int PROMOTION_RETRY_COUNT = 100;
    private long bufferCount;
    private long bufferSize;
    private JfrBuffers buffers;

    @Platforms(value={Platform.HOSTED_ONLY.class})
    public JfrGlobalMemory() {
    }

    public void initialize(long globalBufferSize, long globalBufferCount) {
        this.bufferCount = globalBufferCount;
        this.bufferSize = globalBufferSize;
        this.buffers = (JfrBuffers)UnmanagedMemory.calloc((UnsignedWord)SizeOf.unsigned(JfrBuffers.class).multiply(WordFactory.unsigned((long)this.bufferCount)));
        int i = 0;
        while ((long)i < this.bufferCount) {
            JfrBuffer buffer = JfrBufferAccess.allocate(WordFactory.unsigned((long)this.bufferSize), JfrBufferType.GLOBAL_MEMORY);
            this.buffers.addressOf(i).write(buffer);
            ++i;
        }
    }

    public void teardown() {
        if (this.buffers.isNonNull()) {
            int i = 0;
            while ((long)i < this.bufferCount) {
                JfrBuffer buffer = this.buffers.addressOf(i).read();
                JfrBufferAccess.free(buffer);
                ++i;
            }
            UnmanagedMemory.free((PointerBase)this.buffers);
            this.buffers = (JfrBuffers)WordFactory.nullPointer();
        }
    }

    @Uninterruptible(reason="Called from uninterruptible code.", mayBeInlined=true)
    public JfrBuffers getBuffers() {
        assert (this.buffers.isNonNull());
        return this.buffers;
    }

    @Uninterruptible(reason="Called from uninterruptible code.", mayBeInlined=true)
    public long getBufferCount() {
        return this.bufferCount;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Uninterruptible(reason="Epoch must not change while in this method.")
    public boolean write(JfrBuffer threadLocalBuffer, UnsignedWord unflushedSize) {
        boolean shouldSignal;
        JfrBuffer promotionBuffer = this.acquireBufferWithRetry(unflushedSize, 100);
        if (promotionBuffer.isNull()) {
            return false;
        }
        JfrRecorderThread recorderThread = SubstrateJVM.getRecorderThread();
        try {
            assert (JfrBufferAccess.getAvailableSize(promotionBuffer).aboveOrEqual(unflushedSize));
            UnmanagedMemoryUtil.copy(threadLocalBuffer.getTop(), promotionBuffer.getPos(), unflushedSize);
            JfrBufferAccess.increasePos(promotionBuffer, unflushedSize);
            shouldSignal = recorderThread.shouldSignal(promotionBuffer);
        }
        finally {
            JfrGlobalMemory.releasePromotionBuffer(promotionBuffer);
        }
        JfrBufferAccess.increaseTop(threadLocalBuffer, unflushedSize);
        if (shouldSignal) {
            recorderThread.signal();
        }
        return true;
    }

    @Uninterruptible(reason="Epoch must not change while in this method.")
    private JfrBuffer acquireBufferWithRetry(UnsignedWord size, int retryCount) {
        assert (size.belowOrEqual(WordFactory.unsigned((long)this.bufferSize)));
        for (int retry = 0; retry < retryCount; ++retry) {
            int i = 0;
            while ((long)i < this.bufferCount) {
                JfrBuffer buffer = this.buffers.addressOf(i).read();
                if (JfrBufferAccess.getAvailableSize(buffer).aboveOrEqual(size) && JfrBufferAccess.acquire(buffer)) {
                    if (JfrBufferAccess.getAvailableSize(buffer).aboveOrEqual(size)) {
                        return buffer;
                    }
                    JfrBufferAccess.release(buffer);
                }
                ++i;
            }
        }
        return (JfrBuffer)WordFactory.nullPointer();
    }

    @Uninterruptible(reason="Epoch must not change while in this method.")
    private static void releasePromotionBuffer(JfrBuffer buffer) {
        assert (JfrBufferAccess.isAcquired(buffer));
        JfrBufferAccess.release(buffer);
    }
}

