/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.svm.core.jdk;

import com.oracle.svm.core.annotate.RecomputeFieldValue;
import com.oracle.svm.core.jdk.VarHandleFeature;
import com.oracle.svm.core.meta.SharedField;
import com.oracle.svm.core.util.VMError;
import java.lang.reflect.Field;
import jdk.vm.ci.meta.MetaAccessProvider;
import jdk.vm.ci.meta.ResolvedJavaField;
import org.graalvm.nativeimage.ImageSingletons;

class VarHandleFieldOffsetComputer
implements RecomputeFieldValue.CustomFieldValueComputer {
    VarHandleFieldOffsetComputer() {
    }

    @Override
    public RecomputeFieldValue.ValueAvailability valueAvailability() {
        return RecomputeFieldValue.ValueAvailability.AfterAnalysis;
    }

    @Override
    public Object compute(MetaAccessProvider metaAccess, ResolvedJavaField original, ResolvedJavaField annotated, Object varHandle) {
        Field field = ((VarHandleFeature)ImageSingletons.lookup(VarHandleFeature.class)).findVarHandleField(varHandle);
        SharedField sField = (SharedField)metaAccess.lookupJavaField(field);
        VMError.guarantee(sField.isAccessed() && sField.getLocation() > 0, "Field not marked as accessed");
        return (long)sField.getLocation();
    }

    @Override
    public Class<?>[] types() {
        return new Class[]{Long.TYPE};
    }
}

