/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.svm.core.jdk;

import com.oracle.svm.core.SubstrateUtil;
import com.oracle.svm.core.annotate.NeverInline;
import com.oracle.svm.core.code.FrameInfoQueryResult;
import com.oracle.svm.core.jdk.PrivilegedStack;
import com.oracle.svm.core.jdk.StackTraceUtils;
import com.oracle.svm.core.jdk.Target_java_security_AccessControlContext;
import com.oracle.svm.core.snippets.KnownIntrinsics;
import com.oracle.svm.core.stack.JavaStackFrameVisitor;
import com.oracle.svm.core.stack.JavaStackWalker;
import java.security.AccessControlContext;
import java.security.AccessController;
import java.security.ProtectionDomain;
import java.util.ArrayList;

class StackAccessControlContextVisitor
extends JavaStackFrameVisitor {
    final ArrayList<ProtectionDomain> localArray = new ArrayList();
    boolean isPrivileged = false;
    ProtectionDomain previousProtectionDomain;
    AccessControlContext privilegedContext = null;

    StackAccessControlContextVisitor() {
    }

    @Override
    public boolean visitFrame(FrameInfoQueryResult frameInfo) {
        ProtectionDomain protectionDomain;
        if (!StackTraceUtils.shouldShowFrame(frameInfo, true, false, false)) {
            return true;
        }
        Class<?> clazz = frameInfo.getSourceClass();
        String method = frameInfo.getSourceMethodName();
        if (PrivilegedStack.length() > 0 && clazz.equals(AccessController.class) && method.equals("doPrivileged")) {
            this.isPrivileged = true;
            this.privilegedContext = PrivilegedStack.peekContext();
            protectionDomain = PrivilegedStack.peekCaller().getProtectionDomain();
        } else {
            protectionDomain = clazz.getProtectionDomain();
        }
        if (!(protectionDomain == null || this.previousProtectionDomain != null && this.previousProtectionDomain.equals(protectionDomain))) {
            this.localArray.add(protectionDomain);
            this.previousProtectionDomain = protectionDomain;
        }
        return !this.isPrivileged;
    }

    @NeverInline(value="Starting a stack walk in the caller frame")
    public static AccessControlContext getFromStack() {
        Target_java_security_AccessControlContext wrapper;
        StackAccessControlContextVisitor visitor = new StackAccessControlContextVisitor();
        JavaStackWalker.walkCurrentThread(KnownIntrinsics.readCallerStackPointer(), visitor);
        if (visitor.localArray.isEmpty()) {
            if (visitor.isPrivileged && visitor.privilegedContext == null) {
                return null;
            }
            wrapper = new Target_java_security_AccessControlContext(null, visitor.privilegedContext);
        } else {
            ProtectionDomain[] context = visitor.localArray.toArray(new ProtectionDomain[visitor.localArray.size()]);
            wrapper = new Target_java_security_AccessControlContext(context, visitor.privilegedContext);
        }
        wrapper.isPrivileged = visitor.isPrivileged;
        wrapper.isAuthorized = true;
        return SubstrateUtil.cast(wrapper, AccessControlContext.class);
    }
}

