/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.svm.core;

import com.oracle.svm.core.annotate.RestrictHeapAccess;
import com.oracle.svm.core.code.CodeInfo;
import com.oracle.svm.core.heap.ObjectVisitor;
import org.graalvm.nativeimage.ImageSingletons;
import org.graalvm.word.PointerBase;
import org.graalvm.word.UnsignedWord;

public abstract class MemoryWalker {
    public static MemoryWalker getMemoryWalker() {
        return (MemoryWalker)ImageSingletons.lookup(MemoryWalker.class);
    }

    public abstract boolean visitMemory(Visitor var1);

    public static interface CodeAccess<T extends CodeInfo> {
        public UnsignedWord getStart(T var1);

        public UnsignedWord getCodeAndDataMemorySize(T var1);

        public UnsignedWord getNativeMetadataSize(T var1);

        public String getName(T var1);
    }

    public static interface HeapChunkAccess<T extends PointerBase> {
        public UnsignedWord getStart(T var1);

        public UnsignedWord getSize(T var1);

        public UnsignedWord getAllocationStart(T var1);

        public UnsignedWord getAllocationEnd(T var1);

        public String getRegion(T var1);

        public boolean isAligned(T var1);
    }

    public static interface NativeImageHeapRegionAccess<T> {
        public UnsignedWord getStart(T var1);

        public UnsignedWord getSize(T var1);

        public String getRegionName(T var1);

        public boolean containsReferences(T var1);

        public boolean isWritable(T var1);

        public boolean visitObjects(T var1, ObjectVisitor var2);
    }

    public static interface Visitor
    extends ImageHeapRegionVisitor {
        @RestrictHeapAccess(access=RestrictHeapAccess.Access.NO_ALLOCATION, reason="Must not allocate while visiting memory.")
        public <T extends PointerBase> boolean visitHeapChunk(T var1, HeapChunkAccess<T> var2);

        @RestrictHeapAccess(access=RestrictHeapAccess.Access.NO_ALLOCATION, reason="Must not allocate while visiting memory.")
        public <T extends CodeInfo> boolean visitCode(T var1, CodeAccess<T> var2);
    }

    public static interface ImageHeapRegionVisitor {
        @RestrictHeapAccess(access=RestrictHeapAccess.Access.NO_ALLOCATION, reason="Must not allocate while visiting memory.")
        public <T> boolean visitNativeImageHeapRegion(T var1, NativeImageHeapRegionAccess<T> var2);
    }
}

