/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.svm.reflect.serialize.hosted;

import com.oracle.svm.core.jdk.Package_jdk_internal_reflect;
import com.oracle.svm.core.jdk.RecordSupport;
import com.oracle.svm.core.util.UserError;
import com.oracle.svm.core.util.VMError;
import com.oracle.svm.hosted.ConditionalConfigurationRegistry;
import com.oracle.svm.hosted.ConfigurationTypeResolver;
import com.oracle.svm.hosted.FeatureImpl;
import com.oracle.svm.reflect.serialize.SerializationRegistry;
import com.oracle.svm.reflect.serialize.SerializationSupport;
import com.oracle.svm.reflect.serialize.hosted.SerializationDenyRegistry;
import com.oracle.svm.reflect.serialize.hosted.SerializationFeature;
import com.oracle.svm.util.ReflectionUtil;
import java.io.Externalizable;
import java.io.ObjectStreamClass;
import java.io.Serializable;
import java.lang.reflect.Constructor;
import java.lang.reflect.Executable;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import org.graalvm.nativeimage.ImageSingletons;
import org.graalvm.nativeimage.hosted.RuntimeReflection;
import org.graalvm.nativeimage.impl.ConfigurationCondition;
import org.graalvm.nativeimage.impl.RuntimeSerializationSupport;

final class SerializationBuilder
extends ConditionalConfigurationRegistry
implements RuntimeSerializationSupport {
    private final Object reflectionFactory;
    private final Method newConstructorForSerializationMethod1;
    private final Method newConstructorForSerializationMethod2;
    private final Method getConstructorAccessorMethod;
    private final Method getExternalizableConstructorMethod;
    private final Constructor<?> stubConstructor;
    private final SerializationSupport serializationSupport;
    private final SerializationDenyRegistry denyRegistry;
    private final ConfigurationTypeResolver typeResolver;
    private boolean sealed;

    SerializationBuilder(SerializationDenyRegistry serializationDenyRegistry, FeatureImpl.DuringSetupAccessImpl access, ConfigurationTypeResolver typeResolver) {
        try {
            Class<?> reflectionFactoryClass = access.findClassByName(Package_jdk_internal_reflect.getQualifiedName() + ".ReflectionFactory");
            Method getReflectionFactoryMethod = ReflectionUtil.lookupMethod(reflectionFactoryClass, (String)"getReflectionFactory", (Class[])new Class[0]);
            this.reflectionFactory = getReflectionFactoryMethod.invoke(null, new Object[0]);
            this.newConstructorForSerializationMethod1 = ReflectionUtil.lookupMethod(reflectionFactoryClass, (String)"newConstructorForSerialization", (Class[])new Class[]{Class.class});
            this.newConstructorForSerializationMethod2 = ReflectionUtil.lookupMethod(reflectionFactoryClass, (String)"newConstructorForSerialization", (Class[])new Class[]{Class.class, Constructor.class});
            this.getConstructorAccessorMethod = ReflectionUtil.lookupMethod(Constructor.class, (String)"getConstructorAccessor", (Class[])new Class[0]);
            this.getExternalizableConstructorMethod = ReflectionUtil.lookupMethod(ObjectStreamClass.class, (String)"getExternalizableConstructor", (Class[])new Class[]{Class.class});
        }
        catch (ReflectiveOperationException e) {
            throw VMError.shouldNotReachHere(e);
        }
        this.stubConstructor = this.newConstructorForSerialization(SerializationSupport.StubForAbstractClass.class, null);
        this.denyRegistry = serializationDenyRegistry;
        this.typeResolver = typeResolver;
        this.serializationSupport = new SerializationSupport(this.stubConstructor);
        ImageSingletons.add(SerializationRegistry.class, (Object)this.serializationSupport);
    }

    private void abortIfSealed() {
        UserError.guarantee(!this.sealed, "Too late to add classes for serialization. Registration must happen in a Feature before the analysis has finished.", new Object[0]);
    }

    public void register(ConfigurationCondition condition, Class<?> ... classes) {
        for (Class<?> clazz : classes) {
            this.registerWithTargetConstructorClass(condition, clazz, null);
        }
    }

    public void registerWithTargetConstructorClass(ConfigurationCondition condition, String targetClassName, String customTargetConstructorClassName) {
        this.abortIfSealed();
        Class<?> conditionClass = this.typeResolver.resolveType(condition.getTypeName());
        if (conditionClass == null) {
            return;
        }
        Class<?> serializationTargetClass = this.typeResolver.resolveType(targetClassName);
        UserError.guarantee(serializationTargetClass != null, "Cannot find serialization target class %s. The missing of this class can't be ignored even if --allow-incomplete-classpath is set. Please make sure it is in the classpath", targetClassName);
        if (customTargetConstructorClassName != null) {
            Class<?> customTargetConstructorClass = this.typeResolver.resolveType(customTargetConstructorClassName);
            UserError.guarantee(customTargetConstructorClass != null, "Cannot find targetConstructorClass %s. The missing of this class can't be ignored even if --allow-incomplete-classpath is set. Please make sure it is in the classpath", customTargetConstructorClass);
            this.registerWithTargetConstructorClass(condition, serializationTargetClass, customTargetConstructorClass);
        } else {
            this.registerWithTargetConstructorClass(condition, serializationTargetClass, null);
        }
    }

    public void registerWithTargetConstructorClass(ConfigurationCondition condition, Class<?> serializationTargetClass, Class<?> customTargetConstructorClass) {
        this.abortIfSealed();
        if (!Serializable.class.isAssignableFrom(serializationTargetClass)) {
            SerializationFeature.println("Warning: Could not register " + serializationTargetClass.getName() + " for serialization as it does not implement Serializable.");
        } else if (this.denyRegistry.isAllowed(serializationTargetClass)) {
            if (customTargetConstructorClass != null) {
                UserError.guarantee(customTargetConstructorClass.isAssignableFrom(serializationTargetClass), "The given targetConstructorClass %s is not a subclass of the serialization target class %s.", customTargetConstructorClass, serializationTargetClass);
            }
            this.registerConditionalConfiguration(condition, () -> {
                Class<?> targetConstructor = this.addConstructorAccessor(serializationTargetClass, customTargetConstructorClass);
                SerializationBuilder.addReflections(serializationTargetClass, targetConstructor);
            });
        }
    }

    public void afterAnalysis() {
        this.sealed = true;
    }

    private static void addReflections(Class<?> serializationTargetClass, Class<?> targetConstructorClass) {
        RecordSupport recordSupport;
        if (targetConstructorClass != null) {
            RuntimeReflection.register((Executable[])new Executable[]{ReflectionUtil.lookupConstructor(targetConstructorClass, (Class[])new Class[0])});
        }
        if (Externalizable.class.isAssignableFrom(serializationTargetClass)) {
            RuntimeReflection.register((Executable[])new Executable[]{ReflectionUtil.lookupConstructor(serializationTargetClass, (Class[])null)});
        }
        if ((recordSupport = RecordSupport.singleton()).isRecord(serializationTargetClass)) {
            RuntimeReflection.register((Executable[])new Executable[]{recordSupport.getCanonicalRecordConstructor(serializationTargetClass)});
            RuntimeReflection.register((Executable[])recordSupport.getRecordComponentAccessorMethods(serializationTargetClass));
        }
        RuntimeReflection.register((Class[])new Class[]{serializationTargetClass});
        RuntimeReflection.register((Executable[])serializationTargetClass.getDeclaredConstructors());
        SerializationBuilder.registerMethods(serializationTargetClass);
        SerializationBuilder.registerFields(serializationTargetClass);
    }

    private static void registerMethods(Class<?> serializationTargetClass) {
        RuntimeReflection.register((Executable[])serializationTargetClass.getDeclaredMethods());
        Method computeDefaultSUID = ReflectionUtil.lookupMethod(ObjectStreamClass.class, (String)"computeDefaultSUID", (Class[])new Class[]{Class.class});
        RuntimeReflection.register((Executable[])new Executable[]{computeDefaultSUID});
    }

    private static void registerFields(Class<?> serializationTargetClass) {
        RuntimeReflection.register((Field[])serializationTargetClass.getDeclaredFields());
    }

    private Constructor<?> newConstructorForSerialization(Class<?> serializationTargetClass, Constructor<?> customConstructorToCall) {
        try {
            if (customConstructorToCall == null) {
                return (Constructor)this.newConstructorForSerializationMethod1.invoke(this.reflectionFactory, serializationTargetClass);
            }
            return (Constructor)this.newConstructorForSerializationMethod2.invoke(this.reflectionFactory, serializationTargetClass, customConstructorToCall);
        }
        catch (ReflectiveOperationException e) {
            throw VMError.shouldNotReachHere(e);
        }
    }

    private Object getConstructorAccessor(Constructor<?> constructor) {
        try {
            return this.getConstructorAccessorMethod.invoke(constructor, new Object[0]);
        }
        catch (ReflectiveOperationException e) {
            throw VMError.shouldNotReachHere(e);
        }
    }

    private Constructor<?> getExternalizableConstructor(Class<?> serializationTargetClass) {
        try {
            return (Constructor)this.getExternalizableConstructorMethod.invoke(null, serializationTargetClass);
        }
        catch (ReflectiveOperationException e) {
            throw VMError.shouldNotReachHere(e);
        }
    }

    Class<?> addConstructorAccessor(Class<?> serializationTargetClass, Class<?> customTargetConstructorClass) {
        Class<?> targetConstructorClass;
        Constructor<?> targetConstructor;
        if (serializationTargetClass.isArray() || Enum.class.isAssignableFrom(serializationTargetClass)) {
            return null;
        }
        if (Externalizable.class.isAssignableFrom(serializationTargetClass)) {
            try {
                Constructor<?> externalizableConstructor = this.getExternalizableConstructor(serializationTargetClass);
                return externalizableConstructor.getDeclaringClass();
            }
            catch (Exception e) {
                throw VMError.shouldNotReachHere(e);
            }
        }
        if (Modifier.isAbstract(serializationTargetClass.getModifiers())) {
            targetConstructor = this.stubConstructor;
            targetConstructorClass = targetConstructor.getDeclaringClass();
        } else {
            if (customTargetConstructorClass == serializationTargetClass) {
                return customTargetConstructorClass;
            }
            Constructor<?> customConstructorToCall = null;
            if (customTargetConstructorClass != null) {
                try {
                    customConstructorToCall = customTargetConstructorClass.getDeclaredConstructor(new Class[0]);
                }
                catch (NoSuchMethodException ex) {
                    UserError.abort("The given targetConstructorClass %s does not declare a parameterless constructor.", customTargetConstructorClass.getTypeName());
                }
            }
            targetConstructor = this.newConstructorForSerialization(serializationTargetClass, customConstructorToCall);
            targetConstructorClass = targetConstructor.getDeclaringClass();
        }
        this.serializationSupport.addConstructorAccessor(serializationTargetClass, targetConstructorClass, this.getConstructorAccessor(targetConstructor));
        return targetConstructorClass;
    }
}

