/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.svm.hosted.option;

import com.oracle.svm.core.option.HostedOptionKey;
import com.oracle.svm.core.option.RuntimeOptionKey;
import com.oracle.svm.core.option.SubstrateOptionsParser;
import com.oracle.svm.core.util.InterruptImageBuilding;
import com.oracle.svm.core.util.UserError;
import com.oracle.svm.core.util.VMError;
import com.oracle.svm.hosted.ImageClassLoader;
import com.oracle.svm.hosted.option.HostedOptionProvider;
import java.lang.reflect.Modifier;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import org.graalvm.collections.EconomicMap;
import org.graalvm.collections.EconomicSet;
import org.graalvm.compiler.options.OptionDescriptor;
import org.graalvm.compiler.options.OptionDescriptors;
import org.graalvm.compiler.options.OptionDescriptorsMap;
import org.graalvm.compiler.options.OptionKey;
import org.graalvm.compiler.options.OptionValues;
import org.graalvm.nativeimage.Platforms;

public class HostedOptionParser
implements HostedOptionProvider {
    private EconomicMap<OptionKey<?>, Object> hostedValues = OptionValues.newOptionMap();
    private EconomicMap<OptionKey<?>, Object> runtimeValues = OptionValues.newOptionMap();
    private EconomicMap<String, OptionDescriptor> allHostedOptions = EconomicMap.create();
    private EconomicMap<String, OptionDescriptor> allRuntimeOptions = EconomicMap.create();

    public HostedOptionParser(ImageClassLoader imageClassLoader) {
        HostedOptionParser.collectOptions(imageClassLoader.findSubclasses(OptionDescriptors.class, true), this.allHostedOptions, this.allRuntimeOptions);
    }

    public static void collectOptions(List<Class<? extends OptionDescriptors>> optionsClasses, EconomicMap<String, OptionDescriptor> allHostedOptions, EconomicMap<String, OptionDescriptor> allRuntimeOptions) {
        for (Class<? extends OptionDescriptors> optionsClass : optionsClasses) {
            OptionDescriptors descriptors;
            if (Modifier.isAbstract(optionsClass.getModifiers()) || OptionDescriptorsMap.class.isAssignableFrom(optionsClass)) continue;
            try {
                descriptors = optionsClass.getDeclaredConstructor(new Class[0]).newInstance(new Object[0]);
            }
            catch (Exception ex) {
                throw VMError.shouldNotReachHere(ex);
            }
            for (OptionDescriptor descriptor : descriptors) {
                OptionDescriptor existing;
                String name = descriptor.getName();
                if (descriptor.getDeclaringClass().getAnnotation(Platforms.class) != null) {
                    throw UserError.abort("Options must not be declared in a class that has a @%s annotation: option %s declared in %s", Platforms.class.getSimpleName(), name, descriptor.getDeclaringClass().getTypeName());
                }
                if (!(descriptor.getOptionKey() instanceof RuntimeOptionKey) && (existing = (OptionDescriptor)allHostedOptions.put((Object)name, (Object)descriptor)) != null) {
                    throw VMError.shouldNotReachHere("Option name \"" + name + "\" has multiple definitions: " + existing.getLocation() + " and " + descriptor.getLocation());
                }
                if (descriptor.getOptionKey() instanceof HostedOptionKey || (existing = (OptionDescriptor)allRuntimeOptions.put((Object)name, (Object)descriptor)) == null) continue;
                throw VMError.shouldNotReachHere("Option name \"" + name + "\" has multiple definitions: " + existing.getLocation() + " and " + descriptor.getLocation());
            }
        }
    }

    public String[] parse(String[] args) {
        ArrayList<String> remainingArgs = new ArrayList<String>();
        HashSet<String> errors = new HashSet<String>();
        InterruptImageBuilding interrupt = null;
        for (String arg : args) {
            boolean isImageBuildOption = false;
            try {
                isImageBuildOption |= SubstrateOptionsParser.parseHostedOption("-H:", this.allHostedOptions, this.hostedValues, SubstrateOptionsParser.BooleanOptionFormat.PLUS_MINUS, errors, arg, System.out);
            }
            catch (InterruptImageBuilding e) {
                interrupt = e;
            }
            try {
                isImageBuildOption |= SubstrateOptionsParser.parseHostedOption("-R:", this.allRuntimeOptions, this.runtimeValues, SubstrateOptionsParser.BooleanOptionFormat.PLUS_MINUS, errors, arg, System.out);
            }
            catch (InterruptImageBuilding e) {
                interrupt = e;
            }
            if (isImageBuildOption) continue;
            remainingArgs.add(arg);
        }
        if (interrupt != null) {
            throw interrupt;
        }
        if (!errors.isEmpty()) {
            throw UserError.abort(errors);
        }
        for (OptionDescriptor descriptor : this.allRuntimeOptions.getValues()) {
            if (this.allHostedOptions.containsKey((Object)descriptor.getName())) continue;
            this.hostedValues.put((Object)descriptor.getOptionKey(), null);
        }
        return remainingArgs.toArray(new String[remainingArgs.size()]);
    }

    @Override
    public EconomicMap<OptionKey<?>, Object> getHostedValues() {
        return this.hostedValues;
    }

    @Override
    public EconomicMap<OptionKey<?>, Object> getRuntimeValues() {
        return this.runtimeValues;
    }

    public EconomicSet<String> getRuntimeOptionNames() {
        EconomicSet res = EconomicSet.create((int)this.allRuntimeOptions.size());
        this.allRuntimeOptions.getKeys().forEach(arg_0 -> ((EconomicSet)res).add(arg_0));
        return res;
    }
}

