/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.svm.hosted.jdk;

import com.oracle.svm.core.annotate.AutomaticFeature;
import com.oracle.svm.hosted.FeatureImpl;
import com.oracle.svm.hosted.jdk.JNIRegistrationSupport;
import java.util.Optional;
import jdk.vm.ci.services.Services;
import org.graalvm.compiler.serviceprovider.GraalServices;
import org.graalvm.compiler.serviceprovider.JavaVersionUtil;
import org.graalvm.nativeimage.Platform;
import org.graalvm.nativeimage.Platforms;
import org.graalvm.nativeimage.hosted.Feature;

@Platforms(value={Platform.WINDOWS.class})
@AutomaticFeature
public class JNIRegistrationAWTSupport
implements Feature {
    private static final int JDK_UPDATE = GraalServices.getJavaUpdateVersion();
    private static final boolean IS_OPENJDK = Optional.ofNullable(Services.getSavedProperties().get("java.vm.name")).orElse("").startsWith("OpenJDK");

    public void afterAnalysis(Feature.AfterAnalysisAccess access) {
        int jdk11HbUpdateBound;
        JNIRegistrationSupport jniRegistrationSupport = JNIRegistrationSupport.singleton();
        if (jniRegistrationSupport.isRegisteredLibrary("awt")) {
            jniRegistrationSupport.addJvmShimExports("JVM_CurrentTimeMillis", "JVM_RaiseSignal", "jio_snprintf");
            jniRegistrationSupport.addJavaShimExports("JDK_LoadSystemLibrary", "JNU_CallMethodByName", "JNU_CallMethodByNameV", "JNU_CallStaticMethodByName", "JNU_ClassString", "JNU_GetEnv", "JNU_GetFieldByName", "JNU_GetStaticFieldByName", "JNU_IsInstanceOfByName", "JNU_NewObjectByName", "JNU_NewStringPlatform", "JNU_SetFieldByName", "JNU_ThrowArrayIndexOutOfBoundsException", "JNU_ThrowByName", "JNU_ThrowIOException", "JNU_ThrowIllegalArgumentException", "JNU_ThrowInternalError", "JNU_ThrowNullPointerException", "JNU_ThrowOutOfMemoryError", "getEncodingFromLangID", "getJavaIDFromLangID");
        }
        if (jniRegistrationSupport.isRegisteredLibrary("dcpr") && JavaVersionUtil.JAVA_SPEC == 8) {
            jniRegistrationSupport.addJavaShimExports("JNU_ThrowClassNotFoundException");
        }
        int n = jdk11HbUpdateBound = IS_OPENJDK ? 12 : 11;
        if (jniRegistrationSupport.isRegisteredLibrary("fontmanager") && (JavaVersionUtil.JAVA_SPEC == 11 && JDK_UPDATE >= 10 && JDK_UPDATE <= jdk11HbUpdateBound || JavaVersionUtil.JAVA_SPEC == 16)) {
            jniRegistrationSupport.registerLibrary("harfbuzz");
        }
        if (jniRegistrationSupport.isRegisteredLibrary("javaaccessbridge") && JavaVersionUtil.JAVA_SPEC > 8) {
            jniRegistrationSupport.registerLibrary("jawt");
        }
        if (jniRegistrationSupport.isRegisteredLibrary(JavaVersionUtil.JAVA_SPEC > 8 ? "javajpeg" : "jpeg")) {
            jniRegistrationSupport.addJavaShimExports("JNU_GetEnv", "JNU_ThrowByName", "JNU_ThrowNullPointerException", "jio_snprintf");
        }
        if (jniRegistrationSupport.isRegisteredLibrary("jpeg") && JavaVersionUtil.JAVA_SPEC == 8) {
            jniRegistrationSupport.addJavaShimExports("JNU_CallMethodByName", "JNU_CallStaticMethodByName", "JNU_NewObjectByName");
        }
    }

    public void beforeImageWrite(Feature.BeforeImageWriteAccess access) {
        if (JNIRegistrationSupport.singleton().isRegisteredLibrary("awt")) {
            ((FeatureImpl.BeforeImageWriteAccessImpl)access).registerLinkerInvocationTransformer(linkerInvocation -> {
                linkerInvocation.addNativeLinkerOption("shell32.lib");
                return linkerInvocation;
            });
        }
    }
}

