/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.svm.hosted.image;

import com.oracle.objectfile.ObjectFile;
import com.oracle.objectfile.macho.MachOSymtab;
import com.oracle.svm.core.BuildArtifacts;
import com.oracle.svm.core.LinkerInvocation;
import com.oracle.svm.core.OS;
import com.oracle.svm.core.SubstrateOptions;
import com.oracle.svm.core.SubstrateUtil;
import com.oracle.svm.core.c.libc.LibCBase;
import com.oracle.svm.core.option.OptionUtils;
import com.oracle.svm.core.util.InterruptImageBuilding;
import com.oracle.svm.core.util.UserError;
import com.oracle.svm.core.util.VMError;
import com.oracle.svm.hosted.FeatureImpl;
import com.oracle.svm.hosted.NativeImageOptions;
import com.oracle.svm.hosted.c.NativeLibraries;
import com.oracle.svm.hosted.c.util.FileUtils;
import com.oracle.svm.hosted.image.AbstractImage;
import com.oracle.svm.hosted.image.CCLinkerInvocation;
import com.oracle.svm.hosted.image.NativeImage;
import com.oracle.svm.hosted.image.NativeImageCodeCache;
import com.oracle.svm.hosted.image.NativeImageHeap;
import com.oracle.svm.hosted.meta.HostedMetaAccess;
import com.oracle.svm.hosted.meta.HostedMethod;
import com.oracle.svm.hosted.meta.HostedUniverse;
import java.io.IOException;
import java.io.InputStream;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.StandardCopyOption;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Formatter;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.function.Function;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import org.graalvm.compiler.debug.DebugContext;
import org.graalvm.compiler.debug.Indent;
import org.graalvm.nativeimage.ImageSingletons;
import org.graalvm.nativeimage.Platform;

public abstract class NativeImageViaCC
extends NativeImage {
    public NativeImageViaCC(AbstractImage.NativeImageKind k, HostedUniverse universe, HostedMetaAccess metaAccess, NativeLibraries nativeLibs, NativeImageHeap heap, NativeImageCodeCache codeCache, List<HostedMethod> entryPoints, ClassLoader imageClassLoader) {
        super(k, universe, metaAccess, nativeLibs, heap, codeCache, entryPoints, imageClassLoader);
    }

    LinkerInvocation getLinkerInvocation(Path outputDirectory, Path tempDirectory, String imageName) {
        CCLinkerInvocation inv;
        switch (ObjectFile.getNativeFormat()) {
            case MACH_O: {
                inv = new DarwinCCLinkerInvocation();
                break;
            }
            case PECOFF: {
                inv = new WindowsCCLinkerInvocation(imageName);
                break;
            }
            default: {
                inv = new BinutilsCCLinkerInvocation();
            }
        }
        Path outputFile = outputDirectory.resolve(imageName + this.imageKind.getFilenameSuffix());
        UserError.guarantee(!Files.isDirectory(outputFile, new LinkOption[0]), "Cannot write image to %s. Path exists as directory. (Use -H:Name=<image name>)", outputFile);
        inv.setOutputFile(outputFile);
        inv.setTempDirectory(tempDirectory);
        inv.addLibPath(tempDirectory.toString());
        for (String libraryPath : this.nativeLibs.getLibraryPaths()) {
            inv.addLibPath(libraryPath);
        }
        for (String rPath : OptionUtils.flatten(",", SubstrateOptions.LinkerRPath.getValue())) {
            inv.addRPath(rPath);
        }
        Collection libraries = this.nativeLibs.getLibraries();
        if (Platform.includedIn(Platform.LINUX.class) && ((LibCBase)ImageSingletons.lookup(LibCBase.class)).getName().equals("bionic")) {
            libraries = libraries.stream().filter(library -> !Arrays.asList("pthread", "rt").contains(library)).collect(Collectors.toList());
        }
        libraries.forEach(inv::addLinkedLibrary);
        for (Path filename : this.codeCache.getCCInputFiles(tempDirectory, imageName)) {
            inv.addInputFile(filename);
        }
        for (Path staticLibraryPath : this.nativeLibs.getStaticLibraries()) {
            inv.addInputFile(staticLibraryPath);
        }
        return inv;
    }

    private static List<String> diagnoseLinkerFailure(String linkerOutput) {
        Pattern p;
        Matcher m;
        ArrayList<String> potentialCauses = new ArrayList<String>();
        if (linkerOutput.contains("access beyond end of merged section")) {
            potentialCauses.add("Native Image is using a linker that appears to be incompatible with the tool chain used to build the JDK static libraries. The latter is typically shown in the output of `java -Xinternalversion`.");
        }
        if (SubstrateOptions.ForceNoROSectionRelocations.getValue().booleanValue() && (linkerOutput.contains("fatal error: cannot find ") || linkerOutput.contains("error: invalid linker name in argument"))) {
            potentialCauses.add(SubstrateOptions.ForceNoROSectionRelocations.getName() + " option cannot be used if ld.gold linker is missing from the host system");
        }
        if ((m = (p = Pattern.compile(".*cannot find -l([^\\s]+)\\s.*", 32)).matcher(linkerOutput)).matches()) {
            OS os = OS.getCurrent();
            String libPrefix = os == OS.WINDOWS ? "" : "lib";
            String libSuffix = os == OS.WINDOWS ? ".lib" : ".a";
            potentialCauses.add(String.format("It appears as though %s%s%s is missing. Please install it.", libPrefix, m.group(1), libSuffix));
        }
        return potentialCauses;
    }

    @Override
    public LinkerInvocation write(DebugContext debug, Path outputDirectory, Path tempDirectory, String imageName, FeatureImpl.BeforeImageWriteAccessImpl config) {
        try (Indent indent = debug.logAndIndent("Writing native image");){
            this.write(debug, tempDirectory.resolve(imageName + ObjectFile.getFilenameSuffix()));
            if (NativeImageOptions.ExitAfterRelocatableImageWrite.getValue().booleanValue()) {
                LinkerInvocation linkerInvocation = null;
                return linkerInvocation;
            }
            LinkerInvocation inv = this.getLinkerInvocation(outputDirectory, tempDirectory, imageName);
            for (Function<LinkerInvocation, LinkerInvocation> fn : config.getLinkerInvocationTransformers()) {
                inv = fn.apply(inv);
            }
            List<String> cmd = inv.getCommand();
            String commandLine = SubstrateUtil.getShellCommandString(cmd, false);
            Process linkerProcess = null;
            try {
                List<String> lines;
                ProcessBuilder linkerCommand = FileUtils.prepareCommand(cmd, inv.getTempDirectory());
                linkerCommand.redirectErrorStream(true);
                FileUtils.traceCommand(linkerCommand);
                linkerProcess = linkerCommand.start();
                try (InputStream inputStream = linkerProcess.getInputStream();){
                    lines = FileUtils.readAllLines(inputStream);
                    FileUtils.traceCommandOutput(lines);
                }
                int status = linkerProcess.waitFor();
                if (status != 0) {
                    String output = String.join((CharSequence)System.lineSeparator(), lines);
                    throw NativeImageViaCC.handleLinkerFailure("Linker command exited with " + status, commandLine, output);
                }
                Path imagePath = inv.getOutputFile();
                BuildArtifacts.singleton().add(this.imageKind.isExecutable ? BuildArtifacts.ArtifactType.EXECUTABLE : BuildArtifacts.ArtifactType.SHARED_LIB, imagePath);
                if (OS.getCurrent() == OS.WINDOWS && !this.imageKind.isExecutable) {
                    String importLib = imageName + ".lib";
                    Path importLibPath = imagePath.resolveSibling(importLib);
                    Files.move(inv.getTempDirectory().resolve(importLib), importLibPath, StandardCopyOption.REPLACE_EXISTING);
                    BuildArtifacts.singleton().add(BuildArtifacts.ArtifactType.IMPORT_LIB, importLibPath);
                }
                if (SubstrateOptions.GenerateDebugInfo.getValue() > 0) {
                    BuildArtifacts.singleton().add(BuildArtifacts.ArtifactType.DEBUG_INFO, SubstrateOptions.getDebugInfoSourceCacheRoot());
                    if (OS.getCurrent() == OS.WINDOWS) {
                        BuildArtifacts.singleton().add(BuildArtifacts.ArtifactType.DEBUG_INFO, imagePath.resolveSibling(imageName + ".pdb"));
                    } else {
                        BuildArtifacts.singleton().add(BuildArtifacts.ArtifactType.DEBUG_INFO, imagePath);
                    }
                }
            }
            catch (IOException e) {
                throw NativeImageViaCC.handleLinkerFailure(e.toString(), commandLine, null);
            }
            catch (InterruptedException e) {
                throw new InterruptImageBuilding("Interrupted during native-image linking step for " + imageName);
            }
            finally {
                if (linkerProcess != null) {
                    linkerProcess.destroy();
                }
            }
            LinkerInvocation linkerInvocation = inv;
            return linkerInvocation;
        }
    }

    private static RuntimeException handleLinkerFailure(String message, String commandLine, String output) {
        List<Object> potentialCauses;
        Formatter buf = new Formatter();
        buf.format("There was an error linking the native image: %s%n%n", message);
        List<Object> list = potentialCauses = output == null ? Collections.emptyList() : NativeImageViaCC.diagnoseLinkerFailure(output);
        if (!potentialCauses.isEmpty()) {
            int causeNum = 1;
            buf.format("Based on the linker command output, possible reasons for this include:%n", new Object[0]);
            for (String string : potentialCauses) {
                buf.format("%d. %s%n", causeNum, string);
                ++causeNum;
            }
            buf.format("%n", new Object[0]);
        }
        buf.format("Linker command executed:%n%s", commandLine);
        if (output != null) {
            buf.format("%n%nLinker command output:%n%s", output);
        }
        throw new RuntimeException(buf.toString());
    }

    class WindowsCCLinkerInvocation
    extends CCLinkerInvocation {
        private final String imageName;

        WindowsCCLinkerInvocation(String imageName) {
            this.imageName = imageName;
        }

        @Override
        protected void setOutputKind(List<String> cmd) {
            switch (NativeImageViaCC.this.imageKind) {
                case EXECUTABLE: 
                case STATIC_EXECUTABLE: {
                    cmd.add("/MD");
                    break;
                }
                case SHARED_LIBRARY: {
                    cmd.add("/MD");
                    cmd.add("/LD");
                    break;
                }
                default: {
                    VMError.shouldNotReachHere();
                }
            }
        }

        @Override
        public List<String> getImageSymbols(boolean onlyGlobal) {
            return NativeImageViaCC.this.codeCache.getSymbols(NativeImageViaCC.this.getOrCreateDebugObjectFile(), onlyGlobal).stream().map(ObjectFile.Symbol::getName).collect(Collectors.toList());
        }

        @Override
        public List<String> getCommand() {
            List<String> compilerCmd = this.getCompilerCommand(this.additionalPreOptions);
            ArrayList<String> cmd = new ArrayList<String>(compilerCmd);
            this.setOutputKind(cmd);
            for (Path staticLibrary : NativeImageViaCC.this.nativeLibs.getStaticLibraries()) {
                cmd.add(staticLibrary.toString());
            }
            cmd.add("/link");
            cmd.add("/INCREMENTAL:NO");
            cmd.add("/NODEFAULTLIB:LIBCMT");
            cmd.add("/IMPLIB:" + this.getTempDirectory().resolve(this.imageName + ".lib"));
            if (SubstrateOptions.GenerateDebugInfo.getValue() > 0) {
                cmd.add("/DEBUG");
                if (SubstrateOptions.DeleteLocalSymbols.getValue().booleanValue()) {
                    String pdbFile = this.imageName + ".pdb";
                    cmd.add("/PDB:" + this.getTempDirectory().resolve(pdbFile));
                    cmd.add("/PDBSTRIPPED:" + this.getOutputFile().resolveSibling(pdbFile));
                }
            }
            if (!SubstrateOptions.RemoveUnusedSymbols.getValue().booleanValue()) {
                cmd.add("/OPT:NOREF,NOICF");
            }
            for (String libraryPath : NativeImageViaCC.this.nativeLibs.getLibraryPaths()) {
                cmd.add("/LIBPATH:" + libraryPath);
            }
            for (String library : NativeImageViaCC.this.nativeLibs.getLibraries()) {
                cmd.add(library + ".lib");
            }
            cmd.add("advapi32.lib");
            cmd.add("ws2_32.lib");
            cmd.add("secur32.lib");
            cmd.add("iphlpapi.lib");
            cmd.add("userenv.lib");
            if (SubstrateOptions.EnableWildcardExpansion.getValue().booleanValue() && NativeImageViaCC.this.imageKind == AbstractImage.NativeImageKind.EXECUTABLE) {
                cmd.add("setargv.obj");
            }
            cmd.addAll(this.getNativeLinkerOptions());
            return cmd;
        }
    }

    class DarwinCCLinkerInvocation
    extends CCLinkerInvocation {
        DarwinCCLinkerInvocation() {
            this.additionalPreOptions.add("-Wl,-U,___darwin_check_fd_set_overflow");
            if (!SubstrateOptions.useLLVMBackend()) {
                this.additionalPreOptions.add("-Wl,-no_compact_unwind");
            }
            if (SubstrateOptions.RemoveUnusedSymbols.getValue().booleanValue()) {
                this.additionalPreOptions.add("-Wl,-dead_strip");
            }
            try {
                Path exportedSymbolsPath = NativeImageViaCC.this.nativeLibs.tempDirectory.resolve("exported_symbols.list");
                Files.write(exportedSymbolsPath, this.getImageSymbols(true), new OpenOption[0]);
                this.additionalPreOptions.add("-Wl,-exported_symbols_list");
                this.additionalPreOptions.add("-Wl," + exportedSymbolsPath.toAbsolutePath());
            }
            catch (IOException e) {
                VMError.shouldNotReachHere();
            }
            if (SubstrateOptions.DeleteLocalSymbols.getValue().booleanValue()) {
                this.additionalPreOptions.add("-Wl,-x");
            }
            this.additionalPreOptions.add("-arch");
            if (Platform.includedIn(Platform.AMD64.class)) {
                this.additionalPreOptions.add("x86_64");
            } else if (Platform.includedIn(Platform.AARCH64.class)) {
                this.additionalPreOptions.add("arm64");
            }
        }

        @Override
        public List<String> getImageSymbols(boolean onlyGlobal) {
            return NativeImageViaCC.this.codeCache.getSymbols(NativeImageViaCC.this.getOrCreateDebugObjectFile(), onlyGlobal).stream().map(symbol -> ((MachOSymtab.Entry)symbol).getNameInObject()).collect(Collectors.toList());
        }

        @Override
        protected void setOutputKind(List<String> cmd) {
            switch (NativeImageViaCC.this.imageKind) {
                case STATIC_EXECUTABLE: {
                    throw UserError.abort("%s does not support building static executable images.", OS.getCurrent().name());
                }
                case SHARED_LIBRARY: {
                    cmd.add("-shared");
                    if (!Platform.includedIn(Platform.DARWIN.class)) break;
                    cmd.add("-undefined");
                    cmd.add("dynamic_lookup");
                }
            }
        }
    }

    class BinutilsCCLinkerInvocation
    extends CCLinkerInvocation {
        private final boolean staticExecWithDynamicallyLinkLibC = SubstrateOptions.StaticExecutableWithDynamicLibC.getValue();
        private final Set<String> libCLibaries = new HashSet<String>(Arrays.asList("pthread", "dl", "rt", "m"));

        BinutilsCCLinkerInvocation() {
            this.additionalPreOptions.add("-z");
            this.additionalPreOptions.add("noexecstack");
            if (SubstrateOptions.ForceNoROSectionRelocations.getValue().booleanValue()) {
                this.additionalPreOptions.add("-fuse-ld=gold");
                this.additionalPreOptions.add("-Wl,--rosegment");
            }
            if (SubstrateOptions.RemoveUnusedSymbols.getValue().booleanValue()) {
                this.additionalPreOptions.add("-Wl,--gc-sections");
            }
            if (!SubstrateOptions.StaticExecutable.getValue().booleanValue()) {
                try {
                    StringBuilder exportedSymbols = new StringBuilder();
                    exportedSymbols.append("{\n");
                    for (String symbol : this.getImageSymbols(true)) {
                        exportedSymbols.append('\"').append(symbol).append("\";\n");
                    }
                    exportedSymbols.append("};");
                    Path exportedSymbolsPath = NativeImageViaCC.this.nativeLibs.tempDirectory.resolve("exported_symbols.list");
                    Files.write(exportedSymbolsPath, Collections.singleton(exportedSymbols.toString()), new OpenOption[0]);
                    this.additionalPreOptions.add("-Wl,--dynamic-list");
                    this.additionalPreOptions.add("-Wl," + exportedSymbolsPath.toAbsolutePath());
                    this.additionalPreOptions.add("-Wl,--exclude-libs,ALL");
                }
                catch (IOException e) {
                    VMError.shouldNotReachHere();
                }
            }
            if (SubstrateOptions.DeleteLocalSymbols.getValue().booleanValue()) {
                this.additionalPreOptions.add("-Wl,-x");
            }
        }

        @Override
        public List<String> getImageSymbols(boolean onlyGlobal) {
            return NativeImageViaCC.this.codeCache.getSymbols(NativeImageViaCC.this.getOrCreateDebugObjectFile(), onlyGlobal).stream().map(ObjectFile.Symbol::getName).collect(Collectors.toList());
        }

        @Override
        protected void setOutputKind(List<String> cmd) {
            switch (NativeImageViaCC.this.imageKind) {
                case EXECUTABLE: {
                    break;
                }
                case STATIC_EXECUTABLE: {
                    if (this.staticExecWithDynamicallyLinkLibC) break;
                    cmd.add("-static");
                    break;
                }
                case SHARED_LIBRARY: {
                    cmd.add("-shared");
                    break;
                }
                default: {
                    VMError.shouldNotReachHere();
                }
            }
        }

        @Override
        protected List<String> getLibrariesCommand() {
            ArrayList<String> cmd = new ArrayList<String>();
            for (String lib : this.libs) {
                if (this.staticExecWithDynamicallyLinkLibC) {
                    String linkingMode = this.libCLibaries.contains(lib) ? "dynamic" : "static";
                    cmd.add("-Wl,-B" + linkingMode);
                }
                cmd.add("-l" + lib);
            }
            if (this.staticExecWithDynamicallyLinkLibC) {
                cmd.add("-static-libgcc");
            }
            return cmd;
        }
    }
}

