/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.svm.hosted;

import com.oracle.svm.core.TypeResult;
import com.oracle.svm.core.util.json.JSONParserException;
import com.oracle.svm.hosted.ImageClassLoader;
import jdk.vm.ci.meta.MetaUtil;

public final class ConfigurationTypeResolver {
    private final String configurationType;
    private final ImageClassLoader classLoader;
    private final boolean allowIncompleteClasspath;

    public ConfigurationTypeResolver(String configurationType, ImageClassLoader classLoader, boolean allowIncompleteClasspath) {
        this.configurationType = configurationType;
        this.classLoader = classLoader;
        this.allowIncompleteClasspath = allowIncompleteClasspath;
    }

    public Class<?> resolveType(String typeName) {
        TypeResult<Class<?>> typeResult;
        String name = typeName;
        if (name.indexOf(91) != -1) {
            name = MetaUtil.internalNameToJava((String)MetaUtil.toInternalName((String)name), (boolean)true, (boolean)true);
        }
        if (!(typeResult = this.classLoader.findClass(name)).isPresent()) {
            this.handleError("Could not resolve " + name + " for " + this.configurationType + ".");
        }
        return typeResult.get();
    }

    private void handleError(String message) {
        if (!this.allowIncompleteClasspath) {
            throw new JSONParserException(message + " To allow unresolvable " + this.configurationType + ", use option --allow-incomplete-classpath");
        }
        System.err.println("Warning: " + message);
    }
}

