/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.svm.graal.meta;

import com.oracle.svm.core.util.VMError;
import com.oracle.svm.graal.meta.SubstrateField;
import com.oracle.svm.graal.meta.SubstrateType;
import java.util.Iterator;
import java.util.NoSuchElementException;
import java.util.function.Predicate;

class SubstrateNodeFieldIterator
implements Iterator<SubstrateField> {
    private final SubstrateType type;
    private final Predicate<SubstrateField> filter;
    private int nextFieldInType = 0;
    private SubstrateField nextField;

    SubstrateNodeFieldIterator(SubstrateType type, Predicate<SubstrateField> filter) {
        this.type = type;
        this.filter = filter;
        this.computeNext();
    }

    private void computeNext() {
        SubstrateField[] rawAllInstanceFields = this.type.rawAllInstanceFields;
        if (rawAllInstanceFields == null) {
            throw SubstrateNodeFieldIterator.noFieldsError(this.type);
        }
        SubstrateField[] fields = rawAllInstanceFields;
        while (this.nextFieldInType < fields.length) {
            SubstrateField field = fields[this.nextFieldInType];
            ++this.nextFieldInType;
            if (this.filter != null && !this.filter.test(field)) continue;
            this.nextField = field;
            return;
        }
        this.nextField = null;
    }

    @Override
    public boolean hasNext() {
        return this.nextField != null;
    }

    @Override
    public SubstrateField next() {
        SubstrateField result = this.nextField;
        if (result == null) {
            throw new NoSuchElementException();
        }
        this.computeNext();
        return result;
    }

    static RuntimeException noFieldsError(SubstrateType type) {
        throw VMError.shouldNotReachHere("no instance fields for " + type.getHub().getName() + " available");
    }
}

