/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.svm.core.windows;

import com.oracle.svm.core.c.NonmovableArrays;
import com.oracle.svm.core.jdk.SystemPropertiesSupport;
import com.oracle.svm.core.util.VMError;
import com.oracle.svm.core.windows.headers.FileAPI;
import com.oracle.svm.core.windows.headers.LibC;
import com.oracle.svm.core.windows.headers.LibLoaderAPI;
import com.oracle.svm.core.windows.headers.Process;
import com.oracle.svm.core.windows.headers.SysinfoAPI;
import com.oracle.svm.core.windows.headers.VerRsrc;
import com.oracle.svm.core.windows.headers.WinBase;
import com.oracle.svm.core.windows.headers.WinVer;
import java.nio.ByteOrder;
import java.nio.CharBuffer;
import java.nio.charset.StandardCharsets;
import org.graalvm.collections.Pair;
import org.graalvm.nativeimage.ImageSingletons;
import org.graalvm.nativeimage.Platform;
import org.graalvm.nativeimage.Platforms;
import org.graalvm.nativeimage.StackValue;
import org.graalvm.nativeimage.c.struct.SizeOf;
import org.graalvm.nativeimage.c.type.CIntPointer;
import org.graalvm.nativeimage.c.type.CTypeConversion;
import org.graalvm.nativeimage.c.type.VoidPointer;
import org.graalvm.nativeimage.c.type.WordPointer;
import org.graalvm.word.PointerBase;
import org.graalvm.word.UnsignedWord;
import org.graalvm.word.WordFactory;

@Platforms(value={Platform.WINDOWS.class})
public class WindowsSystemPropertiesSupport
extends SystemPropertiesSupport {
    private static final byte[] USERNAME = "USERNAME\u0000".getBytes(StandardCharsets.UTF_16LE);
    private static final byte[] KERNEL32_DLL = "\\kernel32.dll\u0000".getBytes(StandardCharsets.UTF_16LE);
    private static final byte[] ROOT_PATH = "\\\u0000".getBytes(StandardCharsets.UTF_16LE);
    private static final int VER_NT_WORKSTATION = 1;
    private static final int VER_PLATFORM_WIN32_WINDOWS = 1;
    private static final int VER_PLATFORM_WIN32_NT = 2;
    private static final byte[] PATH = "PATH\u0000".getBytes(StandardCharsets.UTF_16LE);
    private Pair<String, String> cachedOsNameAndVersion;

    @Override
    protected String userNameValue() {
        UnsignedWord length;
        LibC.WCharPointer userName = LibC._wgetenv((LibC.WCharPointer)NonmovableArrays.addressOf(NonmovableArrays.fromImageHeap((Object)USERNAME), 0));
        if (userName.isNonNull() && (length = LibC.wcslen(userName)).aboveThan(0)) {
            return WindowsSystemPropertiesSupport.toJavaString(userName, Math.toIntExact(length.rawValue()));
        }
        int maxLength = 257;
        userName = (LibC.WCharPointer)StackValue.get((int)maxLength, LibC.WCharPointer.class);
        CIntPointer lengthPointer = (CIntPointer)StackValue.get(CIntPointer.class);
        lengthPointer.write(maxLength);
        if (WinBase.GetUserNameW(userName, lengthPointer) != 0) {
            return WindowsSystemPropertiesSupport.toJavaString(userName, lengthPointer.read() - 1);
        }
        return "unknown";
    }

    @Override
    protected String userHomeValue() {
        WinBase.LPHANDLE tokenHandle = (WinBase.LPHANDLE)StackValue.get(WinBase.LPHANDLE.class);
        if (Process.OpenProcessToken(Process.GetCurrentProcess(), Process.TOKEN_QUERY(), tokenHandle) == 0) {
            return "C:\\";
        }
        int initialLen = 261;
        CIntPointer buffLenPointer = (CIntPointer)StackValue.get(CIntPointer.class);
        buffLenPointer.write(initialLen);
        LibC.WCharPointer userHome = (LibC.WCharPointer)StackValue.get((int)initialLen, LibC.WCharPointer.class);
        int result = WinBase.GetUserProfileDirectoryW(tokenHandle.read(), userHome, buffLenPointer);
        WinBase.CloseHandle(tokenHandle.read());
        if (result == 0) {
            return "C:\\";
        }
        return WindowsSystemPropertiesSupport.toJavaString(userHome, buffLenPointer.read() - 1);
    }

    @Override
    protected String userDirValue() {
        int maxLength = 260;
        LibC.WCharPointer userDir = (LibC.WCharPointer)StackValue.get((int)maxLength, LibC.WCharPointer.class);
        int length = WinBase.GetCurrentDirectoryW(maxLength, userDir);
        VMError.guarantee(length > 0 && length < maxLength, "Could not determine value of user.dir");
        return WindowsSystemPropertiesSupport.toJavaString(userDir, length);
    }

    @Override
    protected String tmpdirValue() {
        int maxLength = 261;
        LibC.WCharPointer tmpdir = (LibC.WCharPointer)StackValue.get((int)maxLength, LibC.WCharPointer.class);
        int length = FileAPI.GetTempPathW(maxLength, tmpdir);
        VMError.guarantee(length > 0, "Could not determine value of java.io.tmpdir");
        return WindowsSystemPropertiesSupport.toJavaString(tmpdir, length);
    }

    @Override
    protected String javaLibraryPathValue() {
        LibC.WCharPointer tmp = (LibC.WCharPointer)StackValue.get((int)260, LibC.WCharPointer.class);
        LibC.WCharPointer path = LibC._wgetenv((LibC.WCharPointer)NonmovableArrays.addressOf(NonmovableArrays.fromImageHeap((Object)PATH), 0));
        int pathLength = path.isNonNull() ? Math.toIntExact(LibC.wcslen(path).rawValue()) : 0;
        StringBuilder libraryPath = new StringBuilder(780 + pathLength + 5);
        int tmpLength = LibLoaderAPI.GetModuleFileNameW((WinBase.HMODULE)WordFactory.nullPointer(), tmp, 260);
        VMError.guarantee(tmpLength > 0 && tmpLength < 260);
        libraryPath.append(WindowsSystemPropertiesSupport.asCharBuffer(tmp, tmpLength));
        libraryPath.setLength(libraryPath.lastIndexOf("\\"));
        tmpLength = SysinfoAPI.GetSystemDirectoryW(tmp, 260);
        VMError.guarantee(tmpLength > 0 && tmpLength < 260);
        libraryPath.append(';');
        libraryPath.append(WindowsSystemPropertiesSupport.asCharBuffer(tmp, tmpLength));
        tmpLength = SysinfoAPI.GetWindowsDirectoryW(tmp, 260);
        VMError.guarantee(tmpLength > 0 && tmpLength < 260);
        libraryPath.append(';');
        libraryPath.append(WindowsSystemPropertiesSupport.asCharBuffer(tmp, tmpLength));
        if (path.isNonNull()) {
            libraryPath.append(';');
            libraryPath.append(WindowsSystemPropertiesSupport.asCharBuffer(path, pathLength));
        }
        libraryPath.append(";.");
        return libraryPath.toString();
    }

    private static String toJavaString(LibC.WCharPointer wcString, int length) {
        return WindowsSystemPropertiesSupport.asCharBuffer(wcString, length).toString();
    }

    private static CharBuffer asCharBuffer(LibC.WCharPointer wcString, int length) {
        return CTypeConversion.asByteBuffer((PointerBase)wcString, (int)(length * SizeOf.get(LibC.WCharPointer.class))).order(ByteOrder.LITTLE_ENDIAN).asCharBuffer();
    }

    @Override
    protected String osNameValue() {
        if (this.cachedOsNameAndVersion == null) {
            this.cachedOsNameAndVersion = this.getOsNameAndVersion();
        }
        return (String)this.cachedOsNameAndVersion.getLeft();
    }

    @Override
    protected String osVersionValue() {
        if (this.cachedOsNameAndVersion == null) {
            this.cachedOsNameAndVersion = this.getOsNameAndVersion();
        }
        return (String)this.cachedOsNameAndVersion.getRight();
    }

    public Pair<String, String> getOsNameAndVersion() {
        String osName;
        SysinfoAPI.OSVERSIONINFOEXA ver = (SysinfoAPI.OSVERSIONINFOEXA)StackValue.get(SysinfoAPI.OSVERSIONINFOEXA.class);
        ver.dwOSVersionInfoSize(SizeOf.get(SysinfoAPI.OSVERSIONINFOEXA.class));
        SysinfoAPI.GetVersionExA(ver);
        boolean is64bit = ((Platform)ImageSingletons.lookup(Platform.class)).getArchitecture().endsWith("64");
        boolean isWorkstation = ver.wProductType() == 1;
        int platformId = ver.dwPlatformId();
        int majorVersion = ver.dwMajorVersion();
        int minorVersion = ver.dwMinorVersion();
        int buildNumber = ver.dwBuildNumber();
        LibC.WCharPointer kernel32Path = (LibC.WCharPointer)StackValue.get((int)260, LibC.WCharPointer.class);
        LibC.WCharPointer kernel32Dll = (LibC.WCharPointer)NonmovableArrays.addressOf(NonmovableArrays.fromImageHeap((Object)KERNEL32_DLL), 0);
        int len = 260 - (int)LibC.wcslen(kernel32Dll).rawValue() - 1;
        int ret = SysinfoAPI.GetSystemDirectoryW(kernel32Path, len);
        if (ret != 0 && ret <= len) {
            VoidPointer versionInfo;
            LibC.wcsncat(kernel32Path, kernel32Dll, WordFactory.unsigned((int)(260 - ret)));
            int versionSize = WinVer.GetFileVersionInfoSizeW(kernel32Path, (CIntPointer)WordFactory.nullPointer());
            if (versionSize != 0 && !(versionInfo = (VoidPointer)LibC.malloc(WordFactory.unsigned((int)versionSize))).isNull()) {
                if (WinVer.GetFileVersionInfoW(kernel32Path, 0, versionSize, versionInfo) == 0) {
                    LibC.free((PointerBase)versionInfo);
                } else {
                    CIntPointer lengthPointer;
                    WordPointer fileInfoPointer;
                    LibC.WCharPointer rootPath = (LibC.WCharPointer)NonmovableArrays.addressOf(NonmovableArrays.fromImageHeap((Object)ROOT_PATH), 0);
                    if (WinVer.VerQueryValueW(versionInfo, rootPath, fileInfoPointer = (WordPointer)StackValue.get(WordPointer.class), lengthPointer = (CIntPointer)StackValue.get(CIntPointer.class)) == 0) {
                        LibC.free((PointerBase)versionInfo);
                    } else {
                        VerRsrc.VS_FIXEDFILEINFO fileInfo = (VerRsrc.VS_FIXEDFILEINFO)fileInfoPointer.read();
                        majorVersion = (short)(fileInfo.dwProductVersionMS() >> 16);
                        minorVersion = (short)fileInfo.dwProductVersionMS();
                        buildNumber = (short)(fileInfo.dwProductVersionLS() >> 16);
                        LibC.free((PointerBase)versionInfo);
                    }
                }
            }
        }
        String osVersion = majorVersion + "." + minorVersion;
        block0 : switch (platformId) {
            case 1: {
                if (majorVersion == 4) {
                    switch (minorVersion) {
                        case 0: {
                            osName = "Windows 95";
                            break block0;
                        }
                        case 10: {
                            osName = "Windows 98";
                            break block0;
                        }
                        case 90: {
                            osName = "Windows Me";
                            break block0;
                        }
                    }
                    osName = "Windows 9X (unknown)";
                    break;
                }
                osName = "Windows 9X (unknown)";
                break;
            }
            case 2: {
                if (majorVersion <= 4) {
                    osName = "Windows NT";
                    break;
                }
                if (majorVersion == 5) {
                    switch (minorVersion) {
                        case 0: {
                            osName = "Windows 2000";
                            break block0;
                        }
                        case 1: {
                            osName = "Windows XP";
                            break block0;
                        }
                        case 2: {
                            if (isWorkstation && is64bit) {
                                osName = "Windows XP";
                                break block0;
                            }
                            osName = "Windows 2003";
                            break block0;
                        }
                    }
                    osName = "Windows NT (unknown)";
                    break;
                }
                if (majorVersion == 6) {
                    if (isWorkstation) {
                        switch (minorVersion) {
                            case 0: {
                                osName = "Windows Vista";
                                break block0;
                            }
                            case 1: {
                                osName = "Windows 7";
                                break block0;
                            }
                            case 2: {
                                osName = "Windows 8";
                                break block0;
                            }
                            case 3: {
                                osName = "Windows 8.1";
                                break block0;
                            }
                        }
                        osName = "Windows NT (unknown)";
                        break;
                    }
                    switch (minorVersion) {
                        case 0: {
                            osName = "Windows Server 2008";
                            break block0;
                        }
                        case 1: {
                            osName = "Windows Server 2008 R2";
                            break block0;
                        }
                        case 2: {
                            osName = "Windows Server 2012";
                            break block0;
                        }
                        case 3: {
                            osName = "Windows Server 2012 R2";
                            break block0;
                        }
                    }
                    osName = "Windows NT (unknown)";
                    break;
                }
                if (majorVersion == 10) {
                    if (isWorkstation) {
                        switch (minorVersion) {
                            case 0: {
                                osName = "Windows 10";
                                break block0;
                            }
                        }
                        osName = "Windows NT (unknown)";
                        break;
                    }
                    switch (minorVersion) {
                        case 0: {
                            if (buildNumber > 17762) {
                                osName = "Windows Server 2019";
                                break block0;
                            }
                            osName = "Windows Server 2016";
                            break block0;
                        }
                    }
                    osName = "Windows NT (unknown)";
                    break;
                }
                osName = "Windows NT (unknown)";
                break;
            }
            default: {
                osName = "Windows (unknown)";
            }
        }
        return Pair.create((Object)osName, (Object)osVersion);
    }
}

