/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.svm.core.util;

import com.oracle.svm.core.util.VMError;
import java.util.function.Supplier;
import org.graalvm.compiler.serviceprovider.GraalUnsafeAccess;
import sun.misc.Unsafe;

public final class LazyFinalReference<T> {
    private static final Object UNINITIALIZED = new Object();
    private static final Unsafe UNSAFE = GraalUnsafeAccess.getUnsafe();
    private static final long VALUE_OFFSET;
    private final Supplier<T> supplier;
    private T value = UNINITIALIZED;

    public LazyFinalReference(Supplier<T> supplier) {
        this.supplier = supplier;
    }

    public boolean isPresent() {
        return this.value != UNINITIALIZED || UNSAFE.getObjectVolatile(this, VALUE_OFFSET) != UNINITIALIZED;
    }

    public T get() {
        Object v = this.value;
        if (v == UNINITIALIZED && (v = UNSAFE.getObjectVolatile(this, VALUE_OFFSET)) == UNINITIALIZED) {
            T obj = this.supplier.get();
            v = UNSAFE.compareAndSwapObject(this, VALUE_OFFSET, UNINITIALIZED, obj) ? obj : UNSAFE.getObjectVolatile(this, VALUE_OFFSET);
            assert (v != UNINITIALIZED);
        }
        return v;
    }

    static {
        try {
            VALUE_OFFSET = UNSAFE.objectFieldOffset(LazyFinalReference.class.getDeclaredField("value"));
        }
        catch (Throwable ex) {
            throw VMError.shouldNotReachHere(ex);
        }
    }
}

