/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.svm.core.jdk.localization.substitutions;

import com.oracle.svm.core.annotate.Alias;
import com.oracle.svm.core.annotate.Substitute;
import com.oracle.svm.core.annotate.TargetClass;
import com.oracle.svm.core.annotate.TargetElement;
import com.oracle.svm.core.jdk.JDK8OrEarlier;
import com.oracle.svm.core.jdk.localization.LocalizationSupport;
import java.nio.charset.Charset;
import java.util.Collections;
import java.util.Map;
import java.util.SortedMap;
import java.util.TreeMap;
import org.graalvm.nativeimage.ImageSingletons;

@TargetClass(value=Charset.class)
final class Target_java_nio_charset_Charset {
    @Alias
    private static Charset defaultCharset;

    Target_java_nio_charset_Charset() {
    }

    @Substitute
    private static Charset defaultCharset() {
        return defaultCharset;
    }

    @Substitute
    private static SortedMap<String, Charset> availableCharsets() {
        TreeMap<String, Charset> result = new TreeMap<String, Charset>(String.CASE_INSENSITIVE_ORDER);
        Map<String, Charset> charsets = ((LocalizationSupport)ImageSingletons.lookup(LocalizationSupport.class)).charsets;
        for (Charset charset : charsets.values()) {
            result.put(charset.name(), charset);
        }
        return Collections.unmodifiableSortedMap(result);
    }

    @Substitute
    private static Charset lookup(String charsetName) {
        if (charsetName == null) {
            throw new IllegalArgumentException("Null charset name");
        }
        Map<String, Charset> charsets = ((LocalizationSupport)ImageSingletons.lookup(LocalizationSupport.class)).charsets;
        Charset result = charsets.get(charsetName.toLowerCase());
        if (result == null) {
            Target_java_nio_charset_Charset.checkName(charsetName);
        }
        return result;
    }

    @Alias
    private static native void checkName(String var0);

    @Substitute
    @TargetElement(onlyWith={JDK8OrEarlier.class})
    private static boolean atBugLevel(String bl) {
        return false;
    }
}

