/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.svm.core.graal.nodes;

import com.oracle.svm.core.graal.nodes.LoweredDeadEndNode;
import com.oracle.svm.core.util.VMError;
import java.util.ArrayList;
import java.util.List;
import jdk.vm.ci.meta.JavaKind;
import org.graalvm.compiler.core.common.type.StampFactory;
import org.graalvm.compiler.graph.Node;
import org.graalvm.compiler.graph.NodeClass;
import org.graalvm.compiler.nodeinfo.InputType;
import org.graalvm.compiler.nodeinfo.NodeCycles;
import org.graalvm.compiler.nodeinfo.NodeInfo;
import org.graalvm.compiler.nodeinfo.NodeSize;
import org.graalvm.compiler.nodes.DeoptimizingFixedWithNextNode;
import org.graalvm.compiler.nodes.DeoptimizingNode;
import org.graalvm.compiler.nodes.FixedNode;
import org.graalvm.compiler.nodes.FixedWithNextNode;
import org.graalvm.compiler.nodes.IfNode;
import org.graalvm.compiler.nodes.ReturnNode;
import org.graalvm.compiler.nodes.StructuredGraph;
import org.graalvm.compiler.nodes.ValueNode;
import org.graalvm.compiler.nodes.extended.FixedValueAnchorNode;
import org.graalvm.compiler.nodes.memory.SingleMemoryKill;
import org.graalvm.compiler.nodes.spi.Lowerable;
import org.graalvm.compiler.nodes.spi.Simplifiable;
import org.graalvm.compiler.nodes.spi.SimplifierTool;
import org.graalvm.word.LocationIdentity;

@NodeInfo(cycles=NodeCycles.CYCLES_8, size=NodeSize.SIZE_8, allowedUsageTypes={InputType.Memory})
public class CEntryPointLeaveNode
extends DeoptimizingFixedWithNextNode
implements Simplifiable,
Lowerable,
SingleMemoryKill,
DeoptimizingNode.DeoptBefore {
    public static final NodeClass<CEntryPointLeaveNode> TYPE = NodeClass.create(CEntryPointLeaveNode.class);
    protected final LeaveAction leaveAction;
    @Node.OptionalInput
    protected ValueNode exception;
    private boolean returnValueAnchored;

    public CEntryPointLeaveNode(LeaveAction leaveAction) {
        this(leaveAction, null);
    }

    public CEntryPointLeaveNode(LeaveAction leaveAction, ValueNode exception) {
        super(TYPE, StampFactory.forKind((JavaKind)JavaKind.Int));
        assert (leaveAction == LeaveAction.ExceptionAbort == (exception != null));
        this.leaveAction = leaveAction;
        this.exception = exception;
    }

    public LeaveAction getLeaveAction() {
        return this.leaveAction;
    }

    public ValueNode getException() {
        return this.exception;
    }

    public LocationIdentity getKilledLocationIdentity() {
        return LocationIdentity.any();
    }

    public boolean canDeoptimize() {
        return true;
    }

    public boolean canUseAsStateDuring() {
        return true;
    }

    public void simplify(SimplifierTool tool) {
        if (tool.allUsagesAvailable() && !this.returnValueAnchored) {
            this.returnValueAnchored = true;
            this.anchorReturnValue();
        }
    }

    private void anchorReturnValue() {
        if (this.graph().method().getSignature().getReturnKind() == JavaKind.Void) {
            return;
        }
        ArrayList<ReturnNode> returns = new ArrayList<ReturnNode>(1);
        CEntryPointLeaveNode.collectReturns((Node)this, returns);
        if (returns.size() == 1) {
            ReturnNode returnNode = (ReturnNode)returns.get(0);
            ValueNode returnValue = returnNode.result();
            assert (returnValue != null) : "methods with return type void are already excluded";
            if (returnValue != this) {
                FixedValueAnchorNode anchoredReturnValue = (FixedValueAnchorNode)this.graph().add((Node)new FixedValueAnchorNode(returnValue));
                this.graph().addBeforeFixed((FixedNode)this, (FixedWithNextNode)anchoredReturnValue);
                returnNode.replaceAllInputs((Node)returnValue, (Node)anchoredReturnValue);
            }
        } else if (this.leaveAction == LeaveAction.ExceptionAbort) {
            VMError.guarantee(returns.size() == 0, "Must not have a ReturnNode when aborting with an exception");
        } else {
            throw VMError.shouldNotReachHere("Unexpected number of ReturnNode found: " + returns.size() + " in method " + this.graph().method().format("%H.%n(%p)"));
        }
    }

    private static void collectReturns(Node n, List<ReturnNode> returns) {
        Node cur = n;
        while (cur instanceof FixedWithNextNode) {
            cur = ((FixedWithNextNode)cur).next();
        }
        if (cur instanceof IfNode) {
            for (Node sux : cur.successors()) {
                CEntryPointLeaveNode.collectReturns(sux, returns);
            }
        } else if (cur instanceof ReturnNode) {
            returns.add((ReturnNode)cur);
        } else if (!(cur instanceof LoweredDeadEndNode)) {
            throw VMError.shouldNotReachHere("Unexpected control flow structure after CEntryPointLeaveNode. Disallowed node " + cur + " in method " + ((StructuredGraph)cur.graph()).method().format("%H.%n(%p)"));
        }
    }

    public static enum LeaveAction {
        Leave,
        DetachThread,
        TearDownIsolate,
        ExceptionAbort;

    }
}

