/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.svm.core.annotate;

import java.lang.annotation.ElementType;
import java.lang.annotation.Retention;
import java.lang.annotation.RetentionPolicy;
import java.lang.annotation.Target;
import java.lang.reflect.AnnotatedElement;
import org.graalvm.util.GuardedAnnotationAccess;

@Retention(value=RetentionPolicy.RUNTIME)
@Target(value={ElementType.METHOD, ElementType.CONSTRUCTOR})
public @interface Uninterruptible {
    public String reason();

    public boolean callerMustBe() default false;

    public boolean calleeMustBe() default true;

    public boolean mayBeInlined() default false;

    public static class Utils {
        public static boolean inliningAllowed(AnnotatedElement caller, AnnotatedElement callee) {
            Uninterruptible callerUninterruptible = (Uninterruptible)GuardedAnnotationAccess.getAnnotation((AnnotatedElement)caller, Uninterruptible.class);
            Uninterruptible calleeUninterruptible = (Uninterruptible)GuardedAnnotationAccess.getAnnotation((AnnotatedElement)callee, Uninterruptible.class);
            if (callerUninterruptible != null) {
                return calleeUninterruptible != null;
            }
            return calleeUninterruptible == null || calleeUninterruptible.mayBeInlined();
        }
    }
}

