/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.svm.core;

import com.oracle.svm.core.RegisterDumper;
import com.oracle.svm.core.SubstrateDiagnostics;
import com.oracle.svm.core.annotate.Alias;
import com.oracle.svm.core.annotate.RecomputeFieldValue;
import com.oracle.svm.core.annotate.TargetClass;
import com.oracle.svm.core.annotate.Uninterruptible;
import com.oracle.svm.core.log.Log;
import com.oracle.svm.core.util.VMError;
import com.oracle.svm.util.ReflectionUtil;
import java.io.FileDescriptor;
import java.io.FileOutputStream;
import java.lang.reflect.Constructor;
import java.lang.reflect.Executable;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Member;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import jdk.vm.ci.meta.ResolvedJavaMethod;
import jdk.vm.ci.services.Services;
import org.graalvm.compiler.graph.Node;
import org.graalvm.compiler.java.LambdaUtils;
import org.graalvm.compiler.nodes.BreakpointNode;
import org.graalvm.compiler.serviceprovider.JavaVersionUtil;
import org.graalvm.nativeimage.Platform;
import org.graalvm.nativeimage.Platforms;
import org.graalvm.nativeimage.c.function.CodePointer;
import org.graalvm.nativeimage.c.type.CCharPointer;
import org.graalvm.nativeimage.c.type.CCharPointerPointer;
import org.graalvm.nativeimage.c.type.CTypeConversion;
import org.graalvm.word.Pointer;
import org.graalvm.word.UnsignedWord;
import org.graalvm.word.WordBase;
import org.graalvm.word.WordFactory;

public class SubstrateUtil {
    public static final boolean HOSTED = true;
    private static final Pattern SAFE_SHELL_ARG = Pattern.compile("[A-Za-z0-9@%_\\-+=:,./]+");
    private static final Method isHiddenMethod = JavaVersionUtil.JAVA_SPEC >= 15 ? ReflectionUtil.lookupMethod(Class.class, (String)"isHidden", (Class[])new Class[0]) : null;

    public static String getArchitectureName() {
        String arch;
        switch (arch = System.getProperty("os.arch")) {
            case "x86_64": {
                arch = "amd64";
                break;
            }
            case "arm64": {
                arch = "aarch64";
            }
        }
        return arch;
    }

    public static boolean isBuildingLibgraal() {
        return Services.IS_BUILDING_NATIVE_IMAGE;
    }

    public static boolean isInLibgraal() {
        return Services.IS_IN_NATIVE_IMAGE;
    }

    public static String quoteShellArg(String arg) {
        if (arg.isEmpty()) {
            return "''";
        }
        Matcher m = SAFE_SHELL_ARG.matcher(arg);
        if (m.matches()) {
            return arg;
        }
        return "'" + arg.replace("'", "'\"'\"'") + "'";
    }

    public static String getShellCommandString(List<String> cmd, boolean multiLine) {
        StringBuilder sb = new StringBuilder();
        for (int i = 0; i < cmd.size(); ++i) {
            if (i > 0) {
                sb.append(multiLine ? " \\\n" : " ");
            }
            sb.append(SubstrateUtil.quoteShellArg(cmd.get(i)));
        }
        return sb.toString();
    }

    @Uninterruptible(reason="Called from uninterruptible code.", mayBeInlined=true)
    public static FileDescriptor getFileDescriptor(FileOutputStream out) {
        return SubstrateUtil.cast((Object)out, Target_java_io_FileOutputStream.class).fd;
    }

    public static String[] getArgs(int argc, CCharPointerPointer argv) {
        String[] args = new String[argc - 1];
        for (int i = 1; i < argc; ++i) {
            args[i - 1] = CTypeConversion.toJavaString((CCharPointer)argv.read(i));
        }
        return args;
    }

    @Uninterruptible(reason="Called from uninterruptible code.", mayBeInlined=true)
    public static UnsignedWord strlen(CCharPointer str) {
        UnsignedWord n = (UnsignedWord)WordFactory.zero();
        while (((Pointer)str).readByte((WordBase)n) != 0) {
            n = n.add(1);
        }
        return n;
    }

    @Uninterruptible(reason="Called from uninterruptible code.", mayBeInlined=true)
    public static CCharPointer strchr(CCharPointer str, int c) {
        int index = 0;
        byte b;
        while ((b = str.read(index)) != c) {
            if (b == 0) {
                return (CCharPointer)WordFactory.zero();
            }
            ++index;
        }
        return str.addressOf(index);
    }

    @Uninterruptible(reason="Called from uninterruptible code.", mayBeInlined=true)
    public static <T> T cast(Object obj, Class<T> toType) {
        return (T)obj;
    }

    @Uninterruptible(reason="Called from uninterruptible code.", mayBeInlined=true)
    public static boolean assertionsEnabled() {
        boolean assertionsEnabled = false;
        if (!$assertionsDisabled) {
            assertionsEnabled = true;
            if (!true) {
                throw new AssertionError();
            }
        }
        return assertionsEnabled;
    }

    @Node.NodeIntrinsic(value=BreakpointNode.class)
    public static native void breakpoint(Object var0);

    @Uninterruptible(reason="Called from uninterruptible code.", mayBeInlined=true)
    public static boolean isPowerOf2(long value) {
        return (value & value - 1L) == 0L;
    }

    public static boolean printDiagnostics(Log log, Pointer sp, CodePointer ip) {
        return SubstrateDiagnostics.printFatalError(log, sp, ip, (RegisterDumper.Context)WordFactory.nullPointer(), false);
    }

    public static String[] split(String value, String separator) {
        return SubstrateUtil.split(value, separator, 0);
    }

    public static String[] split(String value, String separator, int limit) {
        int next;
        int offset = 0;
        ArrayList<String> list = null;
        while ((next = value.indexOf(separator, offset)) != -1) {
            boolean limited;
            if (list == null) {
                list = new ArrayList<String>();
            }
            boolean bl = limited = limit > 0;
            if (limited && list.size() >= limit - 1) break;
            list.add(value.substring(offset, next));
            offset = next + separator.length();
        }
        if (offset == 0) {
            return new String[]{value};
        }
        list.add(value.substring(offset));
        return list.toArray(new String[list.size()]);
    }

    public static String toHex(byte[] data) {
        return LambdaUtils.toHex((byte[])data);
    }

    public static String digest(String value) {
        return LambdaUtils.digest((String)value);
    }

    public static String uniqueShortName(ResolvedJavaMethod m) {
        StringBuilder fullName = new StringBuilder();
        fullName.append(m.getDeclaringClass().toClassName()).append(".").append(m.getName()).append("(");
        for (int i = 0; i < m.getSignature().getParameterCount(false); ++i) {
            fullName.append(m.getSignature().getParameterType(i, null).toClassName()).append(",");
        }
        fullName.append(')');
        if (!m.isConstructor()) {
            fullName.append(m.getSignature().getReturnType(null).toClassName());
        }
        return SubstrateUtil.stripPackage(m.getDeclaringClass().toJavaName()) + "_" + (m.isConstructor() ? "constructor" : m.getName()) + "_" + SubstrateUtil.digest(fullName.toString());
    }

    public static String uniqueShortName(Member m) {
        StringBuilder fullName = new StringBuilder();
        fullName.append(m.getDeclaringClass().getName()).append(".");
        if (m instanceof Constructor) {
            fullName.append("<init>");
        } else {
            fullName.append(m.getName());
        }
        if (m instanceof Executable) {
            fullName.append("(");
            for (Class<?> c : ((Executable)m).getParameterTypes()) {
                fullName.append(c.getName()).append(",");
            }
            fullName.append(')');
            if (m instanceof Method) {
                fullName.append(((Method)m).getReturnType().getName());
            }
        }
        return SubstrateUtil.stripPackage(m.getDeclaringClass().getTypeName()) + "_" + (m instanceof Constructor ? "constructor" : m.getName()) + "_" + SubstrateUtil.digest(fullName.toString());
    }

    private static String stripPackage(String qualifiedClassName) {
        return qualifiedClassName.substring(qualifiedClassName.lastIndexOf(".") + 1).replace("/", "");
    }

    @Platforms(value={Platform.HOSTED_ONLY.class})
    public static String mangleName(String methodName) {
        StringBuilder out = new StringBuilder();
        for (int i = 0; i < methodName.length(); ++i) {
            char c = methodName.charAt(i);
            if (c >= 'a' && c <= 'z' || c >= 'A' && c <= 'Z' || i == 0 && c == '.' || i > 0 && c >= '0' && c <= '9') {
                out.append(c);
                continue;
            }
            if (c == '_') {
                out.append("__");
                continue;
            }
            out.append('_');
            out.append(String.format("%04x", c));
        }
        String mangled = out.toString();
        assert (mangled.matches("[a-zA-Z\\._][a-zA-Z0-9_]*"));
        return mangled;
    }

    public static boolean isHiddenClass(Class<?> javaClass) {
        if (JavaVersionUtil.JAVA_SPEC >= 15) {
            try {
                return (Boolean)isHiddenMethod.invoke(javaClass, new Object[0]);
            }
            catch (IllegalAccessException | InvocationTargetException e) {
                throw VMError.shouldNotReachHere(e);
            }
        }
        return false;
    }

    @FunctionalInterface
    public static interface Thunk {
        public void invoke();
    }

    @TargetClass(value=FileOutputStream.class)
    static final class Target_java_io_FileOutputStream {
        @Alias
        FileDescriptor fd;

        Target_java_io_FileOutputStream() {
        }
    }

    @TargetClass(value=SubstrateUtil.class)
    static final class Target_com_oracle_svm_core_SubstrateUtil {
        @Alias
        @RecomputeFieldValue(kind=RecomputeFieldValue.Kind.FromAlias, isFinal=true)
        private static boolean HOSTED = false;

        Target_com_oracle_svm_core_SubstrateUtil() {
        }
    }
}

