/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.svm.reflect.target;

import com.oracle.svm.core.SubstrateUtil;
import com.oracle.svm.core.annotate.Alias;
import com.oracle.svm.core.annotate.Inject;
import com.oracle.svm.core.annotate.RecomputeFieldValue;
import com.oracle.svm.core.annotate.Substitute;
import com.oracle.svm.core.annotate.TargetClass;
import com.oracle.svm.core.annotate.TargetElement;
import com.oracle.svm.core.code.CodeInfoDecoder;
import com.oracle.svm.core.jdk.JDK8OrEarlier;
import com.oracle.svm.core.option.SubstrateOptionsParser;
import com.oracle.svm.core.reflect.RuntimeReflectionConstructors;
import com.oracle.svm.core.util.VMError;
import com.oracle.svm.hosted.NativeImageOptions;
import com.oracle.svm.reflect.target.ReflectionHelper;
import com.oracle.svm.reflect.target.Target_java_lang_reflect_Parameter;
import com.oracle.svm.reflect.target.Target_sun_reflect_annotation_AnnotationParser;
import com.oracle.svm.reflect.target.Target_sun_reflect_annotation_TypeAnnotationParser;
import java.lang.annotation.Annotation;
import java.lang.reflect.AnnotatedElement;
import java.lang.reflect.AnnotatedType;
import java.lang.reflect.Executable;
import java.lang.reflect.Modifier;
import java.lang.reflect.Type;
import java.util.Map;
import java.util.function.Supplier;
import jdk.vm.ci.meta.MetaAccessProvider;
import jdk.vm.ci.meta.ResolvedJavaField;
import sun.reflect.annotation.TypeAnnotation;

@TargetClass(value=Executable.class)
public final class Target_java_lang_reflect_Executable {
    @Alias
    Target_java_lang_reflect_Parameter[] parameters;
    @Alias
    boolean hasRealParameterData;
    @Alias
    Map<Class<? extends Annotation>, Annotation> declaredAnnotations;
    @Inject
    @RecomputeFieldValue(kind=RecomputeFieldValue.Kind.Reset)
    byte[] typeAnnotations;
    @Inject
    @RecomputeFieldValue(kind=RecomputeFieldValue.Kind.Custom, declClass=ParameterAnnotationsComputer.class)
    Annotation[][] parameterAnnotations;
    @Inject
    @RecomputeFieldValue(kind=RecomputeFieldValue.Kind.Custom, declClass=AnnotatedReceiverTypeComputer.class)
    Object annotatedReceiverType;
    @Inject
    @RecomputeFieldValue(kind=RecomputeFieldValue.Kind.Custom, declClass=AnnotatedParameterTypesComputer.class)
    Object[] annotatedParameterTypes;
    @Inject
    @RecomputeFieldValue(kind=RecomputeFieldValue.Kind.Custom, declClass=AnnotatedReturnTypeComputer.class)
    Object annotatedReturnType;
    @Inject
    @RecomputeFieldValue(kind=RecomputeFieldValue.Kind.Custom, declClass=AnnotatedExceptionTypesComputer.class)
    Object[] annotatedExceptionTypes;

    @Alias
    @TargetElement(onlyWith={JDK8OrEarlier.class})
    native Target_java_lang_reflect_Executable getRoot();

    @Alias
    public native int getModifiers();

    @Alias
    native byte[] getAnnotationBytes();

    @Alias
    public native Class<?> getDeclaringClass();

    @Alias
    native Type[] getAllGenericParameterTypes();

    @Alias
    public native Type[] getGenericExceptionTypes();

    @Alias
    private native Target_java_lang_reflect_Parameter[] synthesizeAllParams();

    @Substitute
    private Target_java_lang_reflect_Parameter[] privateGetParameters() {
        Target_java_lang_reflect_Executable holder = ReflectionHelper.getHolder(this);
        if (holder.parameters != null) {
            return holder.parameters;
        }
        if (RuntimeReflectionConstructors.hasQueriedMethods()) {
            assert (!this.hasRealParameterData);
            holder.parameters = this.synthesizeAllParams();
            return holder.parameters;
        }
        throw VMError.shouldNotReachHere();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Substitute
    Map<Class<? extends Annotation>, Annotation> declaredAnnotations() {
        Map<Class<? extends Annotation>, Annotation> declAnnos = this.declaredAnnotations;
        if (declAnnos == null) {
            if (!RuntimeReflectionConstructors.hasQueriedMethods()) {
                throw VMError.shouldNotReachHere();
            }
            Target_java_lang_reflect_Executable target_java_lang_reflect_Executable = this;
            synchronized (target_java_lang_reflect_Executable) {
                declAnnos = this.declaredAnnotations;
                if (declAnnos == null) {
                    Target_java_lang_reflect_Executable holder = ReflectionHelper.getHolder(this);
                    this.declaredAnnotations = declAnnos = Target_sun_reflect_annotation_AnnotationParser.parseAnnotations(holder.getAnnotationBytes(), CodeInfoDecoder.getMetadataPseudoConstantPool(), holder.getDeclaringClass());
                }
            }
        }
        return declAnnos;
    }

    @Alias
    native Annotation[][] sharedGetParameterAnnotations(Class<?>[] var1, byte[] var2);

    @Substitute
    Annotation[][] parseParameterAnnotations(byte[] parameterAnnotations) {
        if (!RuntimeReflectionConstructors.hasQueriedMethods()) {
            throw VMError.shouldNotReachHere();
        }
        return Target_sun_reflect_annotation_AnnotationParser.parseParameterAnnotations(parameterAnnotations, CodeInfoDecoder.getMetadataPseudoConstantPool(), this.getDeclaringClass());
    }

    @Substitute
    public AnnotatedType getAnnotatedReceiverType() {
        Target_java_lang_reflect_Executable holder = ReflectionHelper.getHolder(this);
        if (holder.annotatedReceiverType != null) {
            return (AnnotatedType)AnnotatedTypeEncoder.decodeAnnotationTypes(holder.annotatedReceiverType);
        }
        if (RuntimeReflectionConstructors.hasQueriedMethods()) {
            if (Modifier.isStatic(this.getModifiers())) {
                return null;
            }
            AnnotatedType annotatedRecvType = Target_sun_reflect_annotation_TypeAnnotationParser.buildAnnotatedType(this.typeAnnotations, CodeInfoDecoder.getMetadataPseudoConstantPool(), SubstrateUtil.cast(this, AnnotatedElement.class), this.getDeclaringClass(), this.getDeclaringClass(), TypeAnnotation.TypeAnnotationTarget.METHOD_RECEIVER);
            holder.annotatedReceiverType = annotatedRecvType;
            return annotatedRecvType;
        }
        throw VMError.shouldNotReachHere();
    }

    @Substitute
    public AnnotatedType[] getAnnotatedParameterTypes() {
        Target_java_lang_reflect_Executable holder = ReflectionHelper.getHolder(this);
        if (holder.annotatedParameterTypes != null) {
            return (AnnotatedType[])AnnotatedTypeEncoder.decodeAnnotationTypes(holder.annotatedParameterTypes);
        }
        if (RuntimeReflectionConstructors.hasQueriedMethods()) {
            AnnotatedType[] annotatedParamTypes = Target_sun_reflect_annotation_TypeAnnotationParser.buildAnnotatedTypes(this.typeAnnotations, CodeInfoDecoder.getMetadataPseudoConstantPool(), SubstrateUtil.cast(this, AnnotatedElement.class), this.getDeclaringClass(), this.getAllGenericParameterTypes(), TypeAnnotation.TypeAnnotationTarget.METHOD_FORMAL_PARAMETER);
            holder.annotatedParameterTypes = annotatedParamTypes;
            return annotatedParamTypes;
        }
        throw VMError.shouldNotReachHere();
    }

    @Substitute
    public AnnotatedType getAnnotatedReturnType0(Type returnType) {
        Target_java_lang_reflect_Executable holder = ReflectionHelper.getHolder(this);
        if (holder.annotatedReturnType != null) {
            return (AnnotatedType)AnnotatedTypeEncoder.decodeAnnotationTypes(holder.annotatedReturnType);
        }
        if (RuntimeReflectionConstructors.hasQueriedMethods()) {
            AnnotatedType annotatedRetType = Target_sun_reflect_annotation_TypeAnnotationParser.buildAnnotatedType(this.typeAnnotations, CodeInfoDecoder.getMetadataPseudoConstantPool(), SubstrateUtil.cast(this, AnnotatedElement.class), this.getDeclaringClass(), returnType, TypeAnnotation.TypeAnnotationTarget.METHOD_RETURN);
            holder.annotatedReturnType = annotatedRetType;
            return annotatedRetType;
        }
        throw VMError.shouldNotReachHere();
    }

    @Substitute
    public AnnotatedType[] getAnnotatedExceptionTypes() {
        Target_java_lang_reflect_Executable holder = ReflectionHelper.getHolder(this);
        if (holder.annotatedExceptionTypes != null) {
            return (AnnotatedType[])AnnotatedTypeEncoder.decodeAnnotationTypes(holder.annotatedExceptionTypes);
        }
        if (RuntimeReflectionConstructors.hasQueriedMethods()) {
            AnnotatedType[] annotatedExcTypes = Target_sun_reflect_annotation_TypeAnnotationParser.buildAnnotatedTypes(this.typeAnnotations, CodeInfoDecoder.getMetadataPseudoConstantPool(), SubstrateUtil.cast(this, AnnotatedElement.class), this.getDeclaringClass(), this.getGenericExceptionTypes(), TypeAnnotation.TypeAnnotationTarget.THROWS);
            holder.annotatedExceptionTypes = annotatedExcTypes;
            return annotatedExcTypes;
        }
        throw VMError.shouldNotReachHere();
    }

    private static final class AnnotatedTypeEncoder {
        private AnnotatedTypeEncoder() {
        }

        static Object encodeAnnotationTypes(Supplier<Object> supplier, Object receiver) {
            try {
                return supplier.get();
            }
            catch (InternalError e) {
                return e;
            }
            catch (LinkageError e) {
                if (NativeImageOptions.AllowIncompleteClasspath.getValue().booleanValue()) {
                    return e;
                }
                Executable culprit = (Executable)receiver;
                String message = "Encountered an error while processing annotated types for type: " + culprit.getDeclaringClass().getName() + ", executable: " + culprit.getName() + ". To avoid the issue at build time, use " + SubstrateOptionsParser.commandArgument(NativeImageOptions.AllowIncompleteClasspath, "+") + ". The error is then reported at runtime when these annotated types are first accessed.";
                throw new UnsupportedOperationException(message, e);
            }
        }

        static Object decodeAnnotationTypes(Object value) {
            if (value == null) {
                return null;
            }
            if (value instanceof AnnotatedType || value instanceof AnnotatedType[]) {
                return value;
            }
            if (value instanceof LinkageError) {
                throw (LinkageError)value;
            }
            if (value instanceof InternalError) {
                throw (InternalError)value;
            }
            throw VMError.shouldNotReachHere("Unexpected value while decoding annotation types: " + value.toString());
        }
    }

    public static final class AnnotatedExceptionTypesComputer
    implements RecomputeFieldValue.CustomFieldValueComputer {
        @Override
        public Object compute(MetaAccessProvider metaAccess, ResolvedJavaField original, ResolvedJavaField annotated, Object receiver) {
            Executable executable = (Executable)receiver;
            return AnnotatedTypeEncoder.encodeAnnotationTypes(executable::getAnnotatedExceptionTypes, receiver);
        }
    }

    public static final class AnnotatedReturnTypeComputer
    implements RecomputeFieldValue.CustomFieldValueComputer {
        @Override
        public Object compute(MetaAccessProvider metaAccess, ResolvedJavaField original, ResolvedJavaField annotated, Object receiver) {
            Executable executable = (Executable)receiver;
            return AnnotatedTypeEncoder.encodeAnnotationTypes(executable::getAnnotatedReturnType, receiver);
        }
    }

    public static final class AnnotatedParameterTypesComputer
    implements RecomputeFieldValue.CustomFieldValueComputer {
        @Override
        public Object compute(MetaAccessProvider metaAccess, ResolvedJavaField original, ResolvedJavaField annotated, Object receiver) {
            Executable executable = (Executable)receiver;
            return AnnotatedTypeEncoder.encodeAnnotationTypes(executable::getAnnotatedParameterTypes, receiver);
        }
    }

    public static final class AnnotatedReceiverTypeComputer
    implements RecomputeFieldValue.CustomFieldValueComputer {
        @Override
        public Object compute(MetaAccessProvider metaAccess, ResolvedJavaField original, ResolvedJavaField annotated, Object receiver) {
            Executable executable = (Executable)receiver;
            return AnnotatedTypeEncoder.encodeAnnotationTypes(executable::getAnnotatedReceiverType, receiver);
        }
    }

    public static final class ParameterAnnotationsComputer
    implements RecomputeFieldValue.CustomFieldValueComputer {
        @Override
        public Object compute(MetaAccessProvider metaAccess, ResolvedJavaField original, ResolvedJavaField annotated, Object receiver) {
            Executable executable = (Executable)receiver;
            return executable.getParameterAnnotations();
        }
    }
}

