/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.svm.reflect.target;

import com.oracle.svm.core.SubstrateUtil;
import com.oracle.svm.core.annotate.Alias;
import com.oracle.svm.core.annotate.Inject;
import com.oracle.svm.core.annotate.RecomputeFieldValue;
import com.oracle.svm.core.annotate.Substitute;
import com.oracle.svm.core.annotate.TargetClass;
import com.oracle.svm.core.annotate.TargetElement;
import com.oracle.svm.core.code.CodeInfoDecoder;
import com.oracle.svm.core.reflect.RuntimeReflectionConstructors;
import com.oracle.svm.core.util.VMError;
import com.oracle.svm.reflect.hosted.ExecutableAccessorComputer;
import com.oracle.svm.reflect.target.ReflectionHelper;
import com.oracle.svm.reflect.target.Target_java_lang_reflect_Executable;
import com.oracle.svm.reflect.target.Target_jdk_internal_reflect_ConstructorAccessor;
import com.oracle.svm.reflect.target.Target_sun_reflect_annotation_TypeAnnotationParser;
import java.lang.annotation.Annotation;
import java.lang.reflect.AnnotatedElement;
import java.lang.reflect.AnnotatedType;
import java.lang.reflect.Constructor;
import java.lang.reflect.Modifier;
import jdk.vm.ci.meta.MetaAccessProvider;
import jdk.vm.ci.meta.ResolvedJavaField;
import sun.reflect.annotation.TypeAnnotation;
import sun.reflect.generics.repository.ConstructorRepository;

@TargetClass(value=Constructor.class)
public final class Target_java_lang_reflect_Constructor {
    @Alias
    ConstructorRepository genericInfo;
    @Alias
    private Class<?>[] parameterTypes;
    @Alias
    @RecomputeFieldValue(kind=RecomputeFieldValue.Kind.Reset)
    private byte[] annotations;
    @Alias
    @RecomputeFieldValue(kind=RecomputeFieldValue.Kind.Reset)
    private byte[] parameterAnnotations;
    @Alias
    @RecomputeFieldValue(kind=RecomputeFieldValue.Kind.Custom, declClass=ExecutableAccessorComputer.class)
    Target_jdk_internal_reflect_ConstructorAccessor constructorAccessor;
    @Inject
    @RecomputeFieldValue(kind=RecomputeFieldValue.Kind.Custom, declClass=ConstructorAnnotatedReceiverTypeComputer.class)
    AnnotatedType annotatedReceiverType;

    @Alias
    @TargetElement(name="<init>")
    public native void constructor(Class<?> var1, Class<?>[] var2, Class<?>[] var3, int var4, int var5, String var6, byte[] var7, byte[] var8);

    @Alias
    native Target_java_lang_reflect_Constructor copy();

    @Substitute
    Target_jdk_internal_reflect_ConstructorAccessor acquireConstructorAccessor() {
        if (this.constructorAccessor == null) {
            throw VMError.unsupportedFeature("Runtime reflection is not supported for " + this);
        }
        return this.constructorAccessor;
    }

    @Alias
    public native Class<?> getDeclaringClass();

    @Substitute
    public Annotation[][] getParameterAnnotations() {
        Target_java_lang_reflect_Executable self = SubstrateUtil.cast(this, Target_java_lang_reflect_Executable.class);
        Target_java_lang_reflect_Executable holder = ReflectionHelper.getHolder(self);
        if (holder.parameterAnnotations != null) {
            return holder.parameterAnnotations;
        }
        return self.sharedGetParameterAnnotations(this.parameterTypes, this.parameterAnnotations);
    }

    @Substitute
    public AnnotatedType getAnnotatedReceiverType() {
        Target_java_lang_reflect_Constructor holder = ReflectionHelper.getHolder(this);
        if (holder.annotatedReceiverType != null) {
            return holder.annotatedReceiverType;
        }
        if (RuntimeReflectionConstructors.hasQueriedMethods()) {
            Class<?> thisDeclClass = this.getDeclaringClass();
            Class<?> enclosingClass = thisDeclClass.getEnclosingClass();
            if (enclosingClass == null) {
                return null;
            }
            Class<?> outerDeclaringClass = thisDeclClass.getDeclaringClass();
            if (outerDeclaringClass == null) {
                return null;
            }
            if (Modifier.isStatic(thisDeclClass.getModifiers())) {
                return null;
            }
            return Target_sun_reflect_annotation_TypeAnnotationParser.buildAnnotatedType(SubstrateUtil.cast((Object)holder, Target_java_lang_reflect_Executable.class).typeAnnotations, CodeInfoDecoder.getMetadataPseudoConstantPool(), SubstrateUtil.cast(this, AnnotatedElement.class), thisDeclClass, enclosingClass, TypeAnnotation.TypeAnnotationTarget.METHOD_RECEIVER);
        }
        throw VMError.shouldNotReachHere();
    }

    public static final class ConstructorAnnotatedReceiverTypeComputer
    implements RecomputeFieldValue.CustomFieldValueComputer {
        @Override
        public Object compute(MetaAccessProvider metaAccess, ResolvedJavaField original, ResolvedJavaField annotated, Object receiver) {
            Constructor constructor = (Constructor)receiver;
            return constructor.getAnnotatedReceiverType();
        }
    }
}

