/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.svm.jni.access;

import com.oracle.svm.jni.access.JNIAccessibleField;
import com.oracle.svm.jni.access.JNIAccessibleMethod;
import com.oracle.svm.jni.access.JNIAccessibleMethodDescriptor;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.function.Function;
import jdk.vm.ci.meta.MetaUtil;
import org.graalvm.nativeimage.Platform;
import org.graalvm.nativeimage.Platforms;

public final class JNIAccessibleClass {
    private final Class<?> classObject;
    private Map<JNIAccessibleMethodDescriptor, JNIAccessibleMethod> methods;
    private Map<String, JNIAccessibleField> fields;

    JNIAccessibleClass(Class<?> clazz) {
        this.classObject = clazz;
    }

    public Class<?> getClassObject() {
        return this.classObject;
    }

    public Collection<JNIAccessibleField> getFields() {
        return this.fields != null ? this.fields.values() : Collections.emptySet();
    }

    Map<String, JNIAccessibleField> getFieldsByName() {
        return this.fields != null ? this.fields : Collections.emptyMap();
    }

    public JNIAccessibleField getField(String name) {
        return this.fields != null ? this.fields.get(name) : null;
    }

    @Platforms(value={Platform.HOSTED_ONLY.class})
    void addFieldIfAbsent(String name, Function<String, JNIAccessibleField> mappingFunction) {
        if (this.fields == null) {
            this.fields = new HashMap<String, JNIAccessibleField>();
        }
        this.fields.computeIfAbsent(name, mappingFunction);
    }

    @Platforms(value={Platform.HOSTED_ONLY.class})
    void addMethodIfAbsent(JNIAccessibleMethodDescriptor descriptor, Function<JNIAccessibleMethodDescriptor, JNIAccessibleMethod> mappingFunction) {
        if (this.methods == null) {
            this.methods = new HashMap<JNIAccessibleMethodDescriptor, JNIAccessibleMethod>();
        }
        this.methods.computeIfAbsent(descriptor, mappingFunction);
    }

    public Collection<JNIAccessibleMethod> getMethods() {
        return this.methods != null ? this.methods.values() : Collections.emptySet();
    }

    public Map<JNIAccessibleMethodDescriptor, JNIAccessibleMethod> getMethodsByDescriptor() {
        return this.methods != null ? this.methods : Collections.emptyMap();
    }

    public JNIAccessibleMethod getMethod(JNIAccessibleMethodDescriptor descriptor) {
        return this.methods != null ? this.methods.get(descriptor) : null;
    }

    String getInternalName() {
        return MetaUtil.toInternalName((String)this.classObject.getName());
    }
}

