/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.svm.core.stack;

import com.oracle.svm.core.annotate.Uninterruptible;
import com.oracle.svm.core.option.HostedOptionKey;
import org.graalvm.compiler.api.replacements.Fold;
import org.graalvm.compiler.options.Option;
import org.graalvm.nativeimage.ImageSingletons;
import org.graalvm.nativeimage.IsolateThread;
import org.graalvm.word.UnsignedWord;
import org.graalvm.word.WordFactory;

public interface StackOverflowCheck {
    @Fold
    public static StackOverflowCheck singleton() {
        return (StackOverflowCheck)ImageSingletons.lookup(StackOverflowCheck.class);
    }

    @Uninterruptible(reason="Called while thread is being attached to the VM, i.e., when the thread state is not yet set up.")
    public void initialize(IsolateThread var1);

    public void makeYellowZoneAvailable();

    public boolean isYellowZoneAvailable();

    public void protectYellowZone();

    public int yellowAndRedZoneSize();

    @Uninterruptible(reason="Called by fatal error handling that is uninterruptible.")
    public void disableStackOverflowChecksForFatalError();

    public void updateStackOverflowBoundary();

    public static interface OSSupport {
        @Uninterruptible(reason="Called from uninterruptible code.", mayBeInlined=true)
        default public UnsignedWord lookupStackBase() {
            return (UnsignedWord)WordFactory.zero();
        }

        @Uninterruptible(reason="Called from uninterruptible code.", mayBeInlined=true)
        public UnsignedWord lookupStackEnd();

        @Uninterruptible(reason="Called from uninterruptible code.", mayBeInlined=true)
        default public UnsignedWord lookupStackEnd(UnsignedWord requestedStackSize) {
            return this.lookupStackEnd();
        }
    }

    public static class Options {
        @Option(help={"Size (in bytes) of the yellow zone reserved at the end of the stack. This stack space is reserved for VM use and cannot be used by the application."})
        public static final HostedOptionKey<Integer> StackYellowZoneSize = new HostedOptionKey<Integer>(32768);
        @Option(help={"Size (in bytes) of the red zone reserved at the end of the stack. This stack space can only be used by critical VM code and C code, e.g., to report fatal errors."})
        public static final HostedOptionKey<Integer> StackRedZoneSize = new HostedOptionKey<Integer>(8192);
    }
}

