/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.svm.core.posix;

import com.oracle.svm.core.annotate.AutomaticFeature;
import com.oracle.svm.core.os.AbstractRawFileOperationSupport;
import com.oracle.svm.core.posix.PosixRawFileOperationSupport;
import java.nio.ByteOrder;
import org.graalvm.nativeimage.ImageSingletons;
import org.graalvm.nativeimage.hosted.Feature;

@AutomaticFeature
class PosixRawFileOperationFeature
implements Feature {
    PosixRawFileOperationFeature() {
    }

    public void beforeAnalysis(Feature.BeforeAnalysisAccess access) {
        ByteOrder nativeByteOrder = ByteOrder.nativeOrder();
        assert (nativeByteOrder == ByteOrder.LITTLE_ENDIAN || nativeByteOrder == ByteOrder.BIG_ENDIAN);
        PosixRawFileOperationSupport littleEndianSupport = new PosixRawFileOperationSupport(ByteOrder.LITTLE_ENDIAN == nativeByteOrder);
        PosixRawFileOperationSupport bigEndianSupport = new PosixRawFileOperationSupport(ByteOrder.BIG_ENDIAN == nativeByteOrder);
        PosixRawFileOperationSupport nativeByteOrderSupport = nativeByteOrder == ByteOrder.LITTLE_ENDIAN ? littleEndianSupport : bigEndianSupport;
        ImageSingletons.add(AbstractRawFileOperationSupport.RawFileOperationSupportHolder.class, (Object)new AbstractRawFileOperationSupport.RawFileOperationSupportHolder(littleEndianSupport, bigEndianSupport, nativeByteOrderSupport));
    }
}

