/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.svm.core.option;

import com.oracle.svm.core.option.HostedOptionValues;
import com.oracle.svm.core.option.LocatableOption;
import com.oracle.svm.core.option.MultiOptionValue;
import org.graalvm.collections.EconomicMap;
import org.graalvm.compiler.api.replacements.Fold;
import org.graalvm.compiler.options.OptionKey;

public class HostedOptionKey<T>
extends OptionKey<T> {
    public HostedOptionKey(T defaultValue) {
        super(defaultValue);
    }

    @Fold
    public T getValue() {
        return (T)this.getValue(HostedOptionValues.singleton());
    }

    @Fold
    public boolean hasBeenSet() {
        return this.hasBeenSet(HostedOptionValues.singleton());
    }

    protected boolean checkDescriptorExists() {
        return true;
    }

    public void update(EconomicMap<OptionKey<?>, Object> values, Object boxedValue) {
        Object defaultValue = this.getDefaultValue();
        if (defaultValue instanceof MultiOptionValue) {
            MultiOptionValue value = (MultiOptionValue)values.get((Object)this);
            if (value == null) {
                value = ((MultiOptionValue)defaultValue).createCopy();
            }
            value.valueUpdate(boxedValue);
            super.update(values, value);
        } else {
            super.update(values, LocatableOption.rawValue(boxedValue));
        }
    }
}

