/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.svm.core.jdk.localization;

import com.oracle.svm.core.jdk.localization.LocalizationFeature;
import com.oracle.svm.core.jdk.localization.LocalizationSupport;
import com.oracle.svm.core.option.SubstrateOptionsParser;
import java.util.HashMap;
import java.util.Locale;
import java.util.Map;
import java.util.MissingResourceException;
import java.util.ResourceBundle;
import java.util.Set;
import java.util.spi.LocaleServiceProvider;
import org.graalvm.collections.Pair;
import org.graalvm.nativeimage.Platform;
import org.graalvm.nativeimage.Platforms;
import sun.util.locale.provider.LocaleProviderAdapter;

public class OptimizedLocalizationSupport
extends LocalizationSupport {
    public final Map<Pair<Class<? extends LocaleServiceProvider>, Locale>, LocaleProviderAdapter> adaptersByClass = new HashMap<Pair<Class<? extends LocaleServiceProvider>, Locale>, LocaleProviderAdapter>();
    public final Map<LocaleProviderAdapter.Type, LocaleProviderAdapter> adaptersByType = new HashMap<LocaleProviderAdapter.Type, LocaleProviderAdapter>();
    public final Map<Class<? extends LocaleServiceProvider>, Object> providerPools = new HashMap<Class<? extends LocaleServiceProvider>, Object>();
    final Map<Pair<String, Locale>, ResourceBundle> resourceBundles = new HashMap<Pair<String, Locale>, ResourceBundle>();
    private final String includeResourceBundlesOption = SubstrateOptionsParser.commandArgument(LocalizationFeature.Options.IncludeResourceBundles, "");

    public OptimizedLocalizationSupport(Locale defaultLocale, Set<Locale> locales) {
        super(defaultLocale, locales);
    }

    public ResourceBundle getCached(String baseName, Locale locale) throws MissingResourceException {
        for (Locale candidateLocale : this.control.getCandidateLocales(baseName, locale)) {
            ResourceBundle result = this.resourceBundles.get(Pair.create((Object)baseName, (Object)candidateLocale));
            if (result == null) continue;
            return result;
        }
        String errorMessage = "Resource bundle not found " + baseName + ", locale " + locale + ". Register the resource bundle using the option " + this.includeResourceBundlesOption + baseName + ".";
        throw new MissingResourceException(errorMessage, this.getClass().getName(), baseName);
    }

    @Override
    @Platforms(value={Platform.HOSTED_ONLY.class})
    public void prepareBundle(String bundleName, ResourceBundle bundle, Locale locale) {
        bundle.keySet();
        this.resourceBundles.put((Pair<String, Locale>)Pair.create((Object)bundleName, (Object)locale), bundle);
    }

    @Override
    public boolean shouldSubstituteLoadLookup(String className) {
        return true;
    }
}

