/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.svm.core.jdk;

import com.oracle.svm.core.jdk.resources.NativeImageResourcePath;
import com.oracle.svm.core.jdk.resources.ResourceStorageEntry;
import com.oracle.svm.core.jdk.resources.ResourceURLConnection;
import com.oracle.svm.core.util.ImageHeapMap;
import com.oracle.svm.core.util.VMError;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLConnection;
import java.net.URLStreamHandler;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Enumeration;
import java.util.List;
import org.graalvm.collections.EconomicMap;
import org.graalvm.nativeimage.ImageSingletons;
import org.graalvm.nativeimage.Platform;
import org.graalvm.nativeimage.Platforms;

public final class Resources {
    public static final char RESOURCES_INTERNAL_PATH_SEPARATOR = '/';
    private final EconomicMap<String, ResourceStorageEntry> resources = ImageHeapMap.create();

    public static Resources singleton() {
        return (Resources)ImageSingletons.lookup(Resources.class);
    }

    Resources() {
    }

    public EconomicMap<String, ResourceStorageEntry> resources() {
        return this.resources;
    }

    public static byte[] inputStreamToByteArray(InputStream is) {
        byte[] arr = new byte[4096];
        int pos = 0;
        try {
            while (true) {
                int len;
                if (pos == arr.length) {
                    byte[] tmp = new byte[arr.length * 2];
                    System.arraycopy(arr, 0, tmp, 0, arr.length);
                    arr = tmp;
                }
                if ((len = is.read(arr, pos, arr.length - pos)) != -1) {
                    pos += len;
                    continue;
                }
                break;
            }
        }
        catch (IOException ex) {
            throw VMError.shouldNotReachHere(ex);
        }
        byte[] data = new byte[pos];
        System.arraycopy(arr, 0, data, 0, pos);
        return data;
    }

    private static void addEntry(String resourceName, boolean isDirectory, byte[] data) {
        Resources support = Resources.singleton();
        ResourceStorageEntry entry = (ResourceStorageEntry)support.resources.get((Object)resourceName);
        if (entry == null) {
            entry = new ResourceStorageEntry(isDirectory);
            support.resources.put((Object)resourceName, (Object)entry);
        }
        entry.getData().add(data);
    }

    @Platforms(value={Platform.HOSTED_ONLY.class})
    public static void registerResource(String resourceName, InputStream is) {
        Resources.addEntry(resourceName, false, Resources.inputStreamToByteArray(is));
    }

    @Platforms(value={Platform.HOSTED_ONLY.class})
    public static void registerDirectoryResource(String resourceDirName, String content) {
        Resources.addEntry(resourceDirName, true, content.getBytes());
    }

    public static String toCanonicalForm(String resourceName) {
        NativeImageResourcePath path = new NativeImageResourcePath(null, resourceName.getBytes(StandardCharsets.UTF_8), true);
        return new String(NativeImageResourcePath.getResolved(path));
    }

    public static ResourceStorageEntry get(String name) {
        return (ResourceStorageEntry)Resources.singleton().resources.get((Object)name);
    }

    private static URL createURL(String resourceName, final int index) {
        try {
            return new URL("resource", null, -1, resourceName, new URLStreamHandler(){

                @Override
                protected URLConnection openConnection(URL url) {
                    return new ResourceURLConnection(url, index);
                }
            });
        }
        catch (MalformedURLException ex) {
            throw new IllegalStateException(ex);
        }
    }

    public static URL createURL(String resourceName) {
        if (resourceName == null) {
            return null;
        }
        Enumeration<URL> urls = Resources.createURLs(Resources.toCanonicalForm(resourceName));
        return urls.hasMoreElements() ? urls.nextElement() : null;
    }

    public static InputStream createInputStream(String resourceName) {
        if (resourceName == null) {
            return null;
        }
        ResourceStorageEntry entry = Resources.get(Resources.toCanonicalForm(resourceName));
        if (entry == null) {
            return null;
        }
        List<byte[]> data = entry.getData();
        return data.isEmpty() ? null : new ByteArrayInputStream(data.get(0));
    }

    public static Enumeration<URL> createURLs(String resourceName) {
        if (resourceName == null) {
            return null;
        }
        String canonicalResourceName = Resources.toCanonicalForm(resourceName);
        ResourceStorageEntry entry = Resources.get(canonicalResourceName);
        if (entry == null) {
            return Collections.emptyEnumeration();
        }
        int numberOfResources = entry.getData().size();
        ArrayList<URL> resourcesURLs = new ArrayList<URL>(numberOfResources);
        for (int index = 0; index < numberOfResources; ++index) {
            resourcesURLs.add(Resources.createURL(canonicalResourceName, index));
        }
        return Collections.enumeration(resourcesURLs);
    }
}

