/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.svm.core.graal.thread;

import com.oracle.svm.core.graal.thread.VMThreadLocalAccess;
import com.oracle.svm.core.threadlocal.VMThreadLocalInfo;
import org.graalvm.compiler.core.common.type.StampFactory;
import org.graalvm.compiler.graph.Node;
import org.graalvm.compiler.graph.NodeClass;
import org.graalvm.compiler.nodeinfo.NodeCycles;
import org.graalvm.compiler.nodeinfo.NodeInfo;
import org.graalvm.compiler.nodeinfo.NodeSize;
import org.graalvm.compiler.nodes.AbstractStateSplit;
import org.graalvm.compiler.nodes.ConstantNode;
import org.graalvm.compiler.nodes.FixedWithNextNode;
import org.graalvm.compiler.nodes.StructuredGraph;
import org.graalvm.compiler.nodes.ValueNode;
import org.graalvm.compiler.nodes.extended.JavaWriteNode;
import org.graalvm.compiler.nodes.memory.OnHeapMemoryAccess;
import org.graalvm.compiler.nodes.memory.address.AddressNode;
import org.graalvm.compiler.nodes.memory.address.OffsetAddressNode;
import org.graalvm.compiler.nodes.spi.Lowerable;
import org.graalvm.compiler.nodes.spi.LoweringTool;

@NodeInfo(cycles=NodeCycles.CYCLES_2, size=NodeSize.SIZE_1)
public class StoreVMThreadLocalNode
extends AbstractStateSplit
implements VMThreadLocalAccess,
Lowerable {
    public static final NodeClass<StoreVMThreadLocalNode> TYPE = NodeClass.create(StoreVMThreadLocalNode.class);
    protected final VMThreadLocalInfo threadLocalInfo;
    protected final OnHeapMemoryAccess.BarrierType barrierType;
    @Node.Input
    protected ValueNode holder;
    @Node.Input
    protected ValueNode value;

    public StoreVMThreadLocalNode(VMThreadLocalInfo threadLocalInfo, ValueNode holder, ValueNode value, OnHeapMemoryAccess.BarrierType barrierType) {
        super(TYPE, StampFactory.forVoid());
        this.threadLocalInfo = threadLocalInfo;
        this.barrierType = barrierType;
        this.holder = holder;
        this.value = value;
    }

    public ValueNode getValue() {
        return this.value;
    }

    public void lower(LoweringTool tool) {
        assert (this.threadLocalInfo.offset >= 0);
        ConstantNode offset = ConstantNode.forLong((long)this.threadLocalInfo.offset, (StructuredGraph)this.graph());
        AddressNode address = (AddressNode)this.graph().unique((Node)new OffsetAddressNode(this.holder, (ValueNode)offset));
        JavaWriteNode write = (JavaWriteNode)this.graph().add((Node)new JavaWriteNode(this.threadLocalInfo.storageKind, address, this.threadLocalInfo.locationIdentity, this.value, this.barrierType, true));
        write.setStateAfter(this.stateAfter());
        this.graph().replaceFixedWithFixed((FixedWithNextNode)this, (FixedWithNextNode)write);
        tool.getLowerer().lower((Node)write, tool);
    }
}

