/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.svm.core.code;

import com.oracle.svm.core.code.CodeInfo;
import com.oracle.svm.core.code.CodeInfoAccess;
import com.oracle.svm.core.code.RuntimeCodeCache;
import com.oracle.svm.core.heap.Heap;
import com.oracle.svm.core.log.Log;
import com.oracle.svm.core.thread.VMOperation;
import com.oracle.svm.core.thread.VMThreads;
import com.oracle.svm.core.util.RingBuffer;
import org.graalvm.compiler.api.replacements.Fold;
import org.graalvm.nativeimage.ImageSingletons;
import org.graalvm.nativeimage.Platform;
import org.graalvm.nativeimage.Platforms;
import org.graalvm.nativeimage.c.function.CodePointer;

public class RuntimeCodeInfoHistory {
    private static final RingBuffer.Consumer<CodeCacheLogEntry> PRINT_WITH_JAVA_HEAP_DATA = RuntimeCodeInfoHistory::printEntryWithJavaHeapData;
    private static final RingBuffer.Consumer<CodeCacheLogEntry> PRINT_WITHOUT_JAVA_HEAP_DATA = RuntimeCodeInfoHistory::printEntryWithoutJavaHeapData;
    private final RingBuffer<CodeCacheLogEntry> recentOperations = new RingBuffer<CodeCacheLogEntry>(20, CodeCacheLogEntry::new);

    @Platforms(value={Platform.HOSTED_ONLY.class})
    RuntimeCodeInfoHistory() {
    }

    @Fold
    public static RuntimeCodeInfoHistory singleton() {
        return (RuntimeCodeInfoHistory)ImageSingletons.lookup(RuntimeCodeInfoHistory.class);
    }

    public void logAdd(CodeInfo info) {
        this.logOperation("Added", info);
    }

    public void logMakeNonEntrant(CodeInfo info) {
        this.logOperation("Made non-entrant", info);
    }

    public void logInvalidate(CodeInfo info) {
        this.logOperation("Invalidated", info);
    }

    private void logOperation(String kind, CodeInfo info) {
        assert (VMOperation.isInProgressAtSafepoint());
        RuntimeCodeInfoHistory.traceCodeCache(kind, info, true);
        this.recentOperations.next().setValues(kind, info, CodeInfoAccess.getState(info), CodeInfoAccess.getName(info), CodeInfoAccess.getCodeStart(info), CodeInfoAccess.getCodeEnd(info));
    }

    public void logFree(CodeInfo info) {
        assert (VMOperation.isInProgressAtSafepoint() || VMThreads.isTearingDown());
        RuntimeCodeInfoHistory.traceCodeCache("Freed", info, false);
        this.recentOperations.next().setValues("Freed", info, CodeInfoAccess.getState(info), null, CodeInfoAccess.getCodeStart(info), CodeInfoAccess.getCodeEnd(info));
    }

    private static void traceCodeCache(String kind, CodeInfo info, boolean allowJavaHeapAccess) {
        if (RuntimeCodeCache.Options.TraceCodeCache.getValue().booleanValue()) {
            Log.log().string(kind).string(" method: ");
            CodeInfoAccess.printCodeInfo(Log.log(), info, allowJavaHeapAccess);
        }
    }

    public void printRecentOperations(Log log, boolean allowJavaHeapAccess) {
        log.string("The ").signed(this.recentOperations.size()).string(" most recent RuntimeCodeInfo operations (oldest first): ").indent(true);
        this.recentOperations.foreach(log, allowJavaHeapAccess ? PRINT_WITH_JAVA_HEAP_DATA : PRINT_WITHOUT_JAVA_HEAP_DATA);
        log.indent(false);
    }

    private static void printEntryWithJavaHeapData(Object context, CodeCacheLogEntry entry) {
        RuntimeCodeInfoHistory.printEntry(context, entry, true);
    }

    private static void printEntryWithoutJavaHeapData(Object context, CodeCacheLogEntry entry) {
        RuntimeCodeInfoHistory.printEntry(context, entry, false);
    }

    private static void printEntry(Object context, CodeCacheLogEntry entry, boolean allowJavaHeapAccess) {
        Log log = (Log)context;
        entry.print(log, allowJavaHeapAccess);
    }

    private static class CodeCacheLogEntry {
        private long timestamp;
        private String kind;
        private String codeName;
        private CodeInfo codeInfo;
        private int codeInfoState;
        private CodePointer codeStart;
        private CodePointer codeEnd;

        @Platforms(value={Platform.HOSTED_ONLY.class})
        CodeCacheLogEntry() {
        }

        public void setValues(String kind, CodeInfo codeInfo, int codeInfoState, String codeName, CodePointer codeStart, CodePointer codeEnd) {
            assert (Heap.getHeap().isInImageHeap(kind));
            this.timestamp = System.currentTimeMillis();
            this.kind = kind;
            this.codeInfo = codeInfo;
            this.codeInfoState = codeInfoState;
            this.codeName = codeName;
            this.codeStart = codeStart;
            this.codeEnd = codeEnd;
        }

        public void print(Log log, boolean allowJavaHeapAccess) {
            if (this.kind != null) {
                log.unsigned(this.timestamp).string(" - ").string(this.kind).spaces(1);
                String name = allowJavaHeapAccess ? this.codeName : null;
                CodeInfoAccess.printCodeInfo(log, this.codeInfo, this.codeInfoState, name, this.codeStart, this.codeEnd);
            }
        }
    }
}

