/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.svm.truffle;

import com.oracle.graal.pointsto.meta.AnalysisField;
import com.oracle.graal.pointsto.meta.AnalysisMethod;
import com.oracle.graal.pointsto.meta.AnalysisType;
import com.oracle.graal.pointsto.meta.HostedProviders;
import com.oracle.svm.core.SubstrateOptions;
import com.oracle.svm.core.SubstrateUtil;
import com.oracle.svm.core.annotate.Uninterruptible;
import com.oracle.svm.core.deopt.Deoptimizer;
import com.oracle.svm.core.graal.GraalFeature;
import com.oracle.svm.core.heap.Heap;
import com.oracle.svm.core.meta.SubstrateObjectConstant;
import com.oracle.svm.core.option.HostedOptionKey;
import com.oracle.svm.core.option.HostedOptionValues;
import com.oracle.svm.core.option.SubstrateOptionsParser;
import com.oracle.svm.core.snippets.KnownIntrinsics;
import com.oracle.svm.core.stack.JavaStackWalker;
import com.oracle.svm.core.util.UserError;
import com.oracle.svm.core.util.VMError;
import com.oracle.svm.graal.GraalSupport;
import com.oracle.svm.graal.hosted.GraalFeature;
import com.oracle.svm.hosted.FeatureImpl;
import com.oracle.svm.hosted.SVMHost;
import com.oracle.svm.hosted.meta.HostedType;
import com.oracle.svm.hosted.snippets.SubstrateGraphBuilderPlugins;
import com.oracle.svm.truffle.HostedTruffleConstantFieldProvider;
import com.oracle.svm.truffle.NodeClassFeature;
import com.oracle.svm.truffle.api.SubstrateOptimizedCallTarget;
import com.oracle.svm.truffle.api.SubstratePartialEvaluator;
import com.oracle.svm.truffle.api.SubstrateTruffleCompiler;
import com.oracle.svm.truffle.api.SubstrateTruffleCompilerImpl;
import com.oracle.svm.truffle.api.SubstrateTruffleRuntime;
import com.oracle.svm.truffle.isolated.IsolateAwareTruffleCompiler;
import com.oracle.svm.truffle.isolated.IsolatedTruffleRuntimeSupport;
import com.oracle.svm.util.ReflectionUtil;
import com.oracle.truffle.api.CompilerAsserts;
import com.oracle.truffle.api.CompilerDirectives;
import com.oracle.truffle.api.Truffle;
import com.oracle.truffle.api.TruffleLanguage;
import com.oracle.truffle.api.TruffleRuntime;
import com.oracle.truffle.api.frame.Frame;
import com.oracle.truffle.api.impl.DefaultTruffleRuntime;
import com.oracle.truffle.api.instrumentation.TruffleInstrument;
import com.oracle.truffle.api.library.DefaultExportProvider;
import com.oracle.truffle.api.library.ExportLibrary;
import com.oracle.truffle.api.library.GenerateLibrary;
import com.oracle.truffle.api.library.Library;
import com.oracle.truffle.api.library.LibraryExport;
import com.oracle.truffle.api.library.LibraryFactory;
import com.oracle.truffle.api.nodes.ExplodeLoop;
import com.oracle.truffle.api.nodes.RootNode;
import com.oracle.truffle.api.object.DynamicObject;
import com.oracle.truffle.api.object.Layout;
import com.oracle.truffle.api.profiles.Profile;
import com.oracle.truffle.api.utilities.TriState;
import java.lang.annotation.Annotation;
import java.lang.reflect.Executable;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Hashtable;
import java.util.IdentityHashMap;
import java.util.Iterator;
import java.util.List;
import java.util.ListIterator;
import java.util.Map;
import java.util.Optional;
import java.util.ServiceLoader;
import java.util.Set;
import java.util.TreeMap;
import java.util.TreeSet;
import java.util.Vector;
import java.util.WeakHashMap;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.locks.ReentrantLock;
import java.util.function.BooleanSupplier;
import java.util.function.Consumer;
import java.util.function.Predicate;
import java.util.function.Supplier;
import java.util.stream.Collectors;
import jdk.vm.ci.code.Architecture;
import jdk.vm.ci.meta.Constant;
import jdk.vm.ci.meta.JavaConstant;
import jdk.vm.ci.meta.JavaKind;
import jdk.vm.ci.meta.MetaAccessProvider;
import jdk.vm.ci.meta.ResolvedJavaField;
import jdk.vm.ci.meta.ResolvedJavaMethod;
import org.graalvm.compiler.api.replacements.SnippetReflectionProvider;
import org.graalvm.compiler.core.common.spi.ConstantFieldProvider;
import org.graalvm.compiler.java.BytecodeParserOptions;
import org.graalvm.compiler.nodes.ConstantNode;
import org.graalvm.compiler.nodes.ValueNode;
import org.graalvm.compiler.nodes.graphbuilderconf.GraphBuilderConfiguration;
import org.graalvm.compiler.nodes.graphbuilderconf.GraphBuilderContext;
import org.graalvm.compiler.nodes.graphbuilderconf.InlineInvokePlugin;
import org.graalvm.compiler.nodes.graphbuilderconf.InvocationPlugin;
import org.graalvm.compiler.nodes.graphbuilderconf.InvocationPlugins;
import org.graalvm.compiler.nodes.spi.Replacements;
import org.graalvm.compiler.options.Option;
import org.graalvm.compiler.phases.util.Providers;
import org.graalvm.compiler.truffle.common.CompilableTruffleAST;
import org.graalvm.compiler.truffle.common.OptimizedAssumptionDependency;
import org.graalvm.compiler.truffle.common.TruffleCompilerRuntime;
import org.graalvm.compiler.truffle.compiler.PartialEvaluator;
import org.graalvm.compiler.truffle.compiler.nodes.asserts.NeverPartOfCompilationNode;
import org.graalvm.compiler.truffle.compiler.substitutions.KnownTruffleTypes;
import org.graalvm.compiler.truffle.runtime.BackgroundCompileQueue;
import org.graalvm.compiler.truffle.runtime.GraalTruffleRuntime;
import org.graalvm.compiler.truffle.runtime.OptimizedAssumption;
import org.graalvm.compiler.truffle.runtime.OptimizedCallTarget;
import org.graalvm.compiler.truffle.runtime.OptimizedDirectCallNode;
import org.graalvm.compiler.truffle.runtime.TruffleCallBoundary;
import org.graalvm.nativeimage.ImageSingletons;
import org.graalvm.nativeimage.hosted.Feature;
import org.graalvm.nativeimage.hosted.RuntimeClassInitialization;
import org.graalvm.nativeimage.hosted.RuntimeReflection;

public final class TruffleFeature
implements GraalFeature {
    private boolean firstAnalysisRun;
    private Support support;
    private ClassLoader imageClassLoader;
    private final Set<ResolvedJavaMethod> blacklistMethods;
    private final Set<GraalFeature.CallTreeNode> blacklistViolations;
    private final Set<ResolvedJavaMethod> warnMethods;
    private final Set<GraalFeature.CallTreeNode> warnViolations;
    private final Set<GraalFeature.CallTreeNode> neverPartOfCompilationViolations;
    private Boolean profilingEnabled;
    private final Set<Class<?>> dynamicObjectClasses = new HashSet();

    public TruffleFeature() {
        this.blacklistMethods = new HashSet<ResolvedJavaMethod>();
        this.blacklistViolations = new TreeSet<GraalFeature.CallTreeNode>(TruffleFeature::blacklistViolationComparator);
        this.warnMethods = new HashSet<ResolvedJavaMethod>();
        this.warnViolations = new TreeSet<GraalFeature.CallTreeNode>(TruffleFeature::blacklistViolationComparator);
        this.neverPartOfCompilationViolations = new TreeSet<GraalFeature.CallTreeNode>(TruffleFeature::blacklistViolationComparator);
    }

    public static TruffleFeature getSingleton() {
        return (TruffleFeature)ImageSingletons.lookup(TruffleFeature.class);
    }

    public static void setSupport(Support support) {
        TruffleFeature.getSingleton().support = support;
    }

    public static Support getSupport() {
        return TruffleFeature.getSingleton().support;
    }

    public List<Class<? extends Feature>> getRequiredFeatures() {
        return Arrays.asList(com.oracle.svm.graal.hosted.GraalFeature.class, NodeClassFeature.class);
    }

    private static void initializeTruffleReflectively(ClassLoader imageClassLoader) {
        TruffleFeature.invokeStaticMethod("com.oracle.truffle.api.impl.Accessor", "getTVMCI", Collections.emptyList(), new Object[0]);
        TruffleFeature.invokeStaticMethod("com.oracle.truffle.polyglot.LanguageCache", "initializeNativeImageState", Collections.singletonList(ClassLoader.class), imageClassLoader);
        TruffleFeature.invokeStaticMethod("com.oracle.truffle.polyglot.InstrumentCache", "initializeNativeImageState", Collections.singletonList(ClassLoader.class), imageClassLoader);
        TruffleFeature.invokeStaticMethod("com.oracle.truffle.api.impl.TruffleLocator", "initializeNativeImageState", Collections.emptyList(), new Object[0]);
    }

    public static void removeTruffleLanguage(String mimeType) {
        TruffleFeature.invokeStaticMethod("com.oracle.truffle.polyglot.LanguageCache", "removeLanguageFromNativeImage", Collections.singletonList(String.class), mimeType);
    }

    private static Collection<Class<?>> getLanguageClasses() {
        return (Collection)TruffleFeature.invokeStaticMethod("com.oracle.truffle.polyglot.LanguageCache", "getLanguageClasses", Collections.emptyList(), new Object[0]);
    }

    private static <T> T invokeStaticMethod(String className, String methodName, Collection<Class<?>> parameterTypes, Object ... args) {
        try {
            Class<?> clazz = Class.forName(className);
            Method method = ReflectionUtil.lookupMethod(clazz, (String)methodName, (Class[])parameterTypes.toArray(new Class[0]));
            return (T)method.invoke(null, args);
        }
        catch (ReflectiveOperationException e) {
            throw VMError.shouldNotReachHere(e);
        }
    }

    public void afterRegistration(Feature.AfterRegistrationAccess a) {
        if (this.support == null) {
            this.support = new Support();
        }
        this.imageClassLoader = a.getApplicationClassLoader();
        TruffleRuntime runtime = Truffle.getRuntime();
        UserError.guarantee(runtime != null, "TruffleRuntime not available via Truffle.getRuntime()", new Object[0]);
        UserError.guarantee(runtime instanceof SubstrateTruffleRuntime || runtime instanceof DefaultTruffleRuntime, "Unsupported TruffleRuntime %s (only SubstrateTruffleRuntime or DefaultTruffleRuntime allowed)", runtime.getClass().getName());
        RuntimeClassInitialization.initializeAtBuildTime((String[])new String[]{"com.oracle.graalvm.locator", "Truffle classes are always initialized at build time"});
        if (TruffleFeature.useTruffleCompiler()) {
            SubstrateTruffleRuntime truffleRuntime = (SubstrateTruffleRuntime)runtime;
            truffleRuntime.resetHosted();
        }
        for (TruffleLanguage.Provider provider : ServiceLoader.load(TruffleLanguage.Provider.class)) {
            RuntimeClassInitialization.initializeAtBuildTime((Class[])new Class[]{provider.getClass()});
        }
        for (TruffleInstrument.Provider provider : ServiceLoader.load(TruffleInstrument.Provider.class)) {
            RuntimeClassInitialization.initializeAtBuildTime((Class[])new Class[]{provider.getClass()});
        }
        TruffleFeature.initializeTruffleReflectively(this.imageClassLoader);
        TruffleFeature.invokeStaticMethod("com.oracle.truffle.api.library.LibraryFactory", "reinitializeNativeImageState", Collections.emptyList(), new Object[0]);
    }

    public void cleanup() {
        TruffleRuntime runtime = Truffle.getRuntime();
        if (runtime instanceof SubstrateTruffleRuntime) {
            ((SubstrateTruffleRuntime)runtime).resetNativeImageState();
        } else if (!(runtime instanceof DefaultTruffleRuntime)) {
            throw VMError.shouldNotReachHere("Only SubstrateTruffleRuntime and DefaultTruffleRuntime supported");
        }
        TruffleFeature.invokeStaticMethod("com.oracle.truffle.polyglot.LanguageCache", "resetNativeImageState", Collections.emptyList(), new Object[0]);
        TruffleFeature.invokeStaticMethod("com.oracle.truffle.polyglot.InstrumentCache", "resetNativeImageState", Collections.emptyList(), new Object[0]);
        TruffleFeature.invokeStaticMethod("org.graalvm.polyglot.Engine$ImplHolder", "resetPreInitializedEngine", Collections.emptyList(), new Object[0]);
        TruffleFeature.invokeStaticMethod("com.oracle.truffle.api.impl.TruffleLocator", "resetNativeImageState", Collections.emptyList(), new Object[0]);
        TruffleFeature.invokeStaticMethod("com.oracle.truffle.api.library.LibraryFactory", "resetNativeImageState", Collections.singletonList(ClassLoader.class), this.imageClassLoader);
        TruffleFeature.invokeStaticMethod("com.oracle.truffle.api.nodes.Node", "resetNativeImageState", Collections.emptyList(), new Object[0]);
        TruffleFeature.invokeStaticMethod("com.oracle.truffle.api.source.Source", "resetNativeImageState", Collections.emptyList(), new Object[0]);
        TruffleFeature.invokeStaticMethod("com.oracle.truffle.object.LayoutImpl", "resetNativeImageState", Collections.emptyList(), new Object[0]);
    }

    public static boolean useTruffleCompiler() {
        return Truffle.getRuntime() instanceof SubstrateTruffleRuntime;
    }

    @Override
    public void registerInvocationPlugins(Providers providers, SnippetReflectionProvider snippetReflection, InvocationPlugins invocationPlugins, boolean analysis, boolean hosted) {
        InvocationPlugins.Registration r = new InvocationPlugins.Registration(invocationPlugins, Profile.class);
        r.register0("isProfilingEnabled", new InvocationPlugin(){

            public boolean apply(GraphBuilderContext b, ResolvedJavaMethod targetMethod, InvocationPlugin.Receiver receiver) {
                boolean constantBoolean = TruffleFeature.this.profilingEnabled == null ? false : TruffleFeature.this.profilingEnabled;
                b.addPush(JavaKind.Boolean, (ValueNode)ConstantNode.forBoolean((boolean)constantBoolean));
                return true;
            }
        });
        if (analysis || hosted) {
            r = new InvocationPlugins.Registration(invocationPlugins, CompilerDirectives.class);
            SubstrateGraphBuilderPlugins.registerCastExact(r);
        }
    }

    private void registerNeverPartOfCompilation(InvocationPlugins plugins) {
        InvocationPlugins.Registration r = new InvocationPlugins.Registration(plugins, CompilerAsserts.class);
        r.setAllowOverwrite(true);
        r.register0("neverPartOfCompilation", new InvocationPlugin(){

            public boolean apply(GraphBuilderContext b, ResolvedJavaMethod targetMethod, InvocationPlugin.Receiver receiver) {
                return TruffleFeature.this.handleNeverPartOfCompilation(b, targetMethod, null);
            }
        });
        r.register1("neverPartOfCompilation", String.class, new InvocationPlugin(){

            public boolean apply(GraphBuilderContext b, ResolvedJavaMethod targetMethod, InvocationPlugin.Receiver receiver, ValueNode message) {
                return TruffleFeature.this.handleNeverPartOfCompilation(b, targetMethod, message);
            }
        });
    }

    private boolean handleNeverPartOfCompilation(GraphBuilderContext b, ResolvedJavaMethod targetMethod, ValueNode messageNode) {
        String message = "CompilerAsserts.neverPartOfCompilation()";
        if (messageNode != null && messageNode.isConstant()) {
            message = messageNode.asConstant().toValueString();
        }
        NeverPartOfCompilationNode neverPartOfCompilation = (NeverPartOfCompilationNode)b.add((ValueNode)new NeverPartOfCompilationNode(message));
        if (Options.TruffleCheckNeverPartOfCompilation.getValue().booleanValue() && !neverPartOfCompilation.stateAfter().getMethod().getDeclaringClass().equals(targetMethod.getDeclaringClass())) {
            GraalFeature.CallTreeNode callerNode = ((GraalFeature.RuntimeBytecodeParser)b).getCallTreeNode();
            GraalFeature.CallTreeNode calleeNode = new GraalFeature.CallTreeNode(targetMethod, targetMethod, callerNode, callerNode.getLevel() + 1, com.oracle.svm.graal.hosted.GraalFeature.buildSourceReference(neverPartOfCompilation.stateAfter()));
            this.neverPartOfCompilationViolations.add(calleeNode);
        }
        return true;
    }

    public void beforeAnalysis(Feature.BeforeAnalysisAccess access) {
        FeatureImpl.BeforeAnalysisAccessImpl config = (FeatureImpl.BeforeAnalysisAccessImpl)access;
        TruffleFeature.getLanguageClasses().forEach(xva$0 -> RuntimeReflection.registerForReflectiveInstantiation((Class[])new Class[]{xva$0}));
        config.registerHierarchyForReflectiveInstantiation(DefaultExportProvider.class);
        config.registerHierarchyForReflectiveInstantiation(TruffleInstrument.class);
        TruffleFeature.registerDynamicObjectFields(config);
        config.registerSubtypeReachabilityHandler(TruffleFeature::registerTruffleLibrariesAsInHeap, LibraryFactory.class);
        config.registerSubtypeReachabilityHandler(TruffleFeature::registerTruffleLibrariesAsInHeap, LibraryExport.class);
        if (TruffleFeature.useTruffleCompiler()) {
            SubstrateTruffleRuntime truffleRuntime = (SubstrateTruffleRuntime)Truffle.getRuntime();
            com.oracle.svm.graal.hosted.GraalFeature graalFeature = (com.oracle.svm.graal.hosted.GraalFeature)ImageSingletons.lookup(com.oracle.svm.graal.hosted.GraalFeature.class);
            SnippetReflectionProvider snippetReflection = graalFeature.getHostedProviders().getSnippetReflection();
            SubstrateTruffleCompiler truffleCompiler = truffleRuntime.initTruffleCompiler();
            truffleRuntime.lookupCallMethods((MetaAccessProvider)config.getMetaAccess());
            PartialEvaluator partialEvaluator = truffleCompiler.getPartialEvaluator();
            TruffleFeature.registerKnownTruffleFields(config, partialEvaluator.getKnownTruffleTypes());
            this.support.registerInterpreterEntryMethodsAsCompiled(partialEvaluator, access);
            GraphBuilderConfiguration graphBuilderConfig = partialEvaluator.getConfigPrototype();
            if (Options.TruffleInlineDuringParsing.getValue().booleanValue()) {
                graphBuilderConfig.getPlugins().appendInlineInvokePlugin((InlineInvokePlugin)new TruffleParsingInlineInvokePlugin(config.getHostVM(), graalFeature.getHostedProviders().getReplacements(), graphBuilderConfig.getPlugins().getInvocationPlugins(), partialEvaluator, method -> this.includeCallee((ResolvedJavaMethod)method, null, null)));
            }
            this.registerNeverPartOfCompilation(graphBuilderConfig.getPlugins().getInvocationPlugins());
            graphBuilderConfig.getPlugins().getInvocationPlugins().closeRegistration();
            HostedProviders newHostedProviders = new HostedProviders(partialEvaluator.getProviders().getMetaAccess(), partialEvaluator.getProviders().getCodeCache(), partialEvaluator.getProviders().getConstantReflection(), (ConstantFieldProvider)new HostedTruffleConstantFieldProvider(partialEvaluator.getProviders().getConstantFieldProvider()), partialEvaluator.getProviders().getForeignCalls(), partialEvaluator.getProviders().getLowerer(), partialEvaluator.getProviders().getReplacements(), partialEvaluator.getProviders().getStampProvider(), snippetReflection, graalFeature.getHostedProviders().getWordTypes(), graalFeature.getHostedProviders().getPlatformConfigurationProvider(), graalFeature.getHostedProviders().getMetaAccessExtensionProvider());
            newHostedProviders.setGraphBuilderPlugins(graphBuilderConfig.getPlugins());
            graalFeature.initializeRuntimeCompilationConfiguration(newHostedProviders, graphBuilderConfig, this::includeCallee, this::deoptimizeOnException);
            for (ResolvedJavaMethod method2 : partialEvaluator.getCompilationRootMethods()) {
                graalFeature.prepareMethodForRuntimeCompilation(method2, config);
            }
            this.initializeMethodBlacklist((MetaAccessProvider)config.getMetaAccess());
            for (ResolvedJavaMethod method2 : truffleRuntime.getAnyFrameMethod()) {
                graalFeature.requireFrameInformationForMethod(method2);
                config.registerAsCompiled((AnalysisMethod)method2);
            }
            this.profilingEnabled = Truffle.getRuntime().isProfilingEnabled();
            TruffleFeature.invokeStaticMethod("com.oracle.truffle.polyglot.PolyglotEngineImpl", "resetFallbackEngine", Collections.emptyList(), new Object[0]);
        }
        this.firstAnalysisRun = true;
    }

    private static void registerTruffleLibrariesAsInHeap(Feature.DuringAnalysisAccess access, Class<?> clazz) {
        assert (access.isReachable(clazz)) : clazz;
        assert (LibraryFactory.class.isAssignableFrom(clazz) || LibraryExport.class.isAssignableFrom(clazz)) : clazz;
        if (!Modifier.isAbstract(clazz.getModifiers())) {
            access.registerAsInHeap(clazz);
        }
    }

    public void duringAnalysis(Feature.DuringAnalysisAccess access) {
        if (this.firstAnalysisRun) {
            this.firstAnalysisRun = false;
            Object keep = TruffleFeature.invokeStaticMethod("com.oracle.truffle.polyglot.PolyglotContextImpl", "resetSingleContextState", Collections.singleton(Boolean.TYPE), false);
            TruffleFeature.invokeStaticMethod("org.graalvm.polyglot.Engine$ImplHolder", "preInitializeEngine", Collections.emptyList(), new Object[0]);
            TruffleFeature.invokeStaticMethod("com.oracle.truffle.polyglot.PolyglotContextImpl", "restoreSingleContextState", Collections.singleton(Object.class), keep);
            access.requireAnalysisIteration();
        }
        for (AnalysisType type : ((FeatureImpl.DuringAnalysisAccessImpl)access).getBigBang().getUniverse().getTypes()) {
            if (!access.isReachable(type.getJavaClass())) continue;
            TruffleFeature.initializeTruffleLibrariesAtBuildTime(type);
            this.initializeDynamicObjectLayouts(type);
        }
    }

    private static void initializeTruffleLibrariesAtBuildTime(AnalysisType type) {
        if (type.isAnnotationPresent(GenerateLibrary.class)) {
            LibraryFactory.resolve(type.getJavaClass().asSubclass(Library.class));
        }
        if (((ExportLibrary[])type.getDeclaredAnnotationsByType(ExportLibrary.class)).length != 0) {
            TruffleFeature.invokeStaticMethod("com.oracle.truffle.api.library.LibraryFactory$ResolvedDispatch", "lookup", Collections.singleton(Class.class), type.getJavaClass());
        }
    }

    private void initializeDynamicObjectLayouts(AnalysisType type) {
        Class javaClass;
        if (type.isInstantiated() && DynamicObject.class.isAssignableFrom(javaClass = type.getJavaClass()) && this.dynamicObjectClasses.add(javaClass)) {
            Layout.newLayout().type(javaClass.asSubclass(DynamicObject.class)).build();
        }
    }

    private static void registerKnownTruffleFields(FeatureImpl.BeforeAnalysisAccessImpl config, KnownTruffleTypes knownTruffleFields) {
        for (Class<?> klass = knownTruffleFields.getClass(); klass != Object.class; klass = klass.getSuperclass()) {
            for (Field field : klass.getDeclaredFields()) {
                if (!Modifier.isPublic(field.getModifiers())) continue;
                try {
                    Object value = field.get(knownTruffleFields);
                    if (value == null || !(value instanceof ResolvedJavaField)) continue;
                    config.registerAsAccessed((AnalysisField)value);
                }
                catch (IllegalAccessException ex) {
                    throw VMError.shouldNotReachHere(ex);
                }
            }
        }
    }

    private static void registerDynamicObjectFields(FeatureImpl.BeforeAnalysisAccessImpl config) {
        Class<?> dynamicFieldClass = config.findClassByName(DynamicObject.class.getName().concat("$DynamicField"));
        if (dynamicFieldClass == null) {
            throw VMError.shouldNotReachHere("DynamicObject.DynamicField annotation not found.");
        }
        for (Field field : config.findAnnotatedFields(dynamicFieldClass.asSubclass(Annotation.class))) {
            config.registerAsUnsafeAccessed(field);
        }
    }

    private boolean includeCallee(GraalFeature.CallTreeNode calleeNode, List<AnalysisMethod> implementationMethods) {
        return this.includeCallee((ResolvedJavaMethod)calleeNode.getImplementationMethod(), calleeNode, implementationMethods);
    }

    private boolean includeCallee(ResolvedJavaMethod implementationMethod, GraalFeature.CallTreeNode calleeNode, List<AnalysisMethod> implementationMethods) {
        Uninterruptible uninterruptibleAnnotation = (Uninterruptible)implementationMethod.getAnnotation(Uninterruptible.class);
        if (implementationMethod.getAnnotation(CompilerDirectives.TruffleBoundary.class) != null) {
            return false;
        }
        if (SubstrateUtil.NativeImageLoadingShield.isNeverInline(implementationMethod)) {
            return false;
        }
        if (uninterruptibleAnnotation != null && !uninterruptibleAnnotation.mayBeInlined()) {
            return false;
        }
        if (implementationMethod.getAnnotation(TruffleCallBoundary.class) != null) {
            return false;
        }
        if (calleeNode != null && implementationMethods.size() > 4 && this.isBlacklisted((ResolvedJavaMethod)calleeNode.getTargetMethod())) {
            this.blacklistViolations.add(new GraalFeature.CallTreeNode((ResolvedJavaMethod)calleeNode.getTargetMethod(), (ResolvedJavaMethod)calleeNode.getTargetMethod(), calleeNode.getParent(), calleeNode.getLevel(), calleeNode.getSourceReference()));
            return false;
        }
        if (this.isBlacklisted(implementationMethod)) {
            if (calleeNode != null) {
                this.blacklistViolations.add(calleeNode);
            }
            return false;
        }
        if (this.warnMethods.contains(implementationMethod) && calleeNode != null) {
            this.warnViolations.add(calleeNode);
        }
        return true;
    }

    private boolean isBlacklisted(ResolvedJavaMethod method) {
        if (!((AnalysisMethod)method).allowRuntimeCompilation()) {
            return true;
        }
        if (method.isSynchronized() && method.getName().equals("fillInStackTrace")) {
            return true;
        }
        return this.blacklistMethods.contains(method);
    }

    private boolean deoptimizeOnException(ResolvedJavaMethod method) {
        if (method == null) {
            return false;
        }
        CompilerDirectives.TruffleBoundary truffleBoundary = (CompilerDirectives.TruffleBoundary)method.getAnnotation(CompilerDirectives.TruffleBoundary.class);
        return truffleBoundary != null && truffleBoundary.transferToInterpreterOnException();
    }

    private void initializeMethodBlacklist(MetaAccessProvider metaAccess) {
        this.blacklistMethod(metaAccess, Object.class, "clone", new Class[0]);
        this.blacklistMethod(metaAccess, Object.class, "equals", Object.class);
        this.blacklistMethod(metaAccess, Object.class, "hashCode", new Class[0]);
        this.blacklistMethod(metaAccess, Object.class, "toString", new Class[0]);
        this.blacklistMethod(metaAccess, String.class, "valueOf", Object.class);
        this.blacklistMethod(metaAccess, String.class, "getBytes", new Class[0]);
        this.blacklistMethod(metaAccess, Throwable.class, "initCause", Throwable.class);
        this.blacklistMethod(metaAccess, System.class, "getProperty", String.class);
        this.blacklistAllMethods(metaAccess, AssertionError.class);
        this.blacklistAllMethods(metaAccess, BigInteger.class);
        this.blacklistAllMethods(metaAccess, BigDecimal.class);
        this.blacklistAllMethods(metaAccess, Comparable.class);
        this.blacklistAllMethods(metaAccess, Comparator.class);
        this.blacklistAllMethods(metaAccess, Collection.class);
        this.blacklistAllMethods(metaAccess, List.class);
        this.blacklistAllMethods(metaAccess, Set.class);
        this.blacklistAllMethods(metaAccess, Map.class);
        this.blacklistAllMethods(metaAccess, Map.Entry.class);
        this.blacklistAllMethods(metaAccess, TreeMap.class);
        this.blacklistAllMethods(metaAccess, HashMap.class);
        this.blacklistAllMethods(metaAccess, ConcurrentHashMap.class);
        this.blacklistAllMethods(metaAccess, WeakHashMap.class);
        this.blacklistAllMethods(metaAccess, IdentityHashMap.class);
        this.blacklistAllMethods(metaAccess, Iterable.class);
        this.blacklistAllMethods(metaAccess, Iterator.class);
        this.blacklistAllMethods(metaAccess, ListIterator.class);
        this.blacklistAllMethods(metaAccess, ReentrantLock.class);
        this.whitelistMethod(metaAccess, BigInteger.class, "signum", new Class[0]);
        this.whitelistMethod(metaAccess, ReentrantLock.class, "isLocked", new Class[0]);
        this.whitelistMethod(metaAccess, ReentrantLock.class, "isHeldByCurrentThread", new Class[0]);
        this.blacklistAllMethods(metaAccess, StringBuffer.class);
        this.blacklistAllMethods(metaAccess, Vector.class);
        this.blacklistAllMethods(metaAccess, Hashtable.class);
        this.warnAllMethods(metaAccess, JavaStackWalker.class);
        this.warnAllMethods(metaAccess, Deoptimizer.class);
        this.warnAllMethods(metaAccess, Heap.getHeap().getClass());
    }

    private void blacklistAllMethods(MetaAccessProvider metaAccess, Class<?> clazz) {
        for (Method method : clazz.getDeclaredMethods()) {
            this.blacklistMethods.add(metaAccess.lookupJavaMethod((Executable)method));
        }
        for (Executable executable : clazz.getDeclaredConstructors()) {
            this.blacklistMethods.add(metaAccess.lookupJavaMethod(executable));
        }
    }

    private void blacklistMethod(MetaAccessProvider metaAccess, Class<?> clazz, String name, Class<?> ... parameterTypes) {
        try {
            this.blacklistMethods.add(metaAccess.lookupJavaMethod((Executable)clazz.getDeclaredMethod(name, parameterTypes)));
        }
        catch (NoSuchMethodException ex) {
            throw VMError.shouldNotReachHere(ex);
        }
    }

    private void whitelistMethod(MetaAccessProvider metaAccess, Class<?> clazz, String name, Class<?> ... parameterTypes) {
        try {
            if (!this.blacklistMethods.remove(metaAccess.lookupJavaMethod((Executable)clazz.getDeclaredMethod(name, parameterTypes)))) {
                throw VMError.shouldNotReachHere();
            }
        }
        catch (NoSuchMethodException ex) {
            throw VMError.shouldNotReachHere(ex);
        }
    }

    private void warnAllMethods(MetaAccessProvider metaAccess, Class<?> clazz) {
        for (Method method : clazz.getDeclaredMethods()) {
            if (method.getAnnotations().length != 0 || ((Executable)method).getName().startsWith("get") || ((Executable)method).getName().startsWith("set")) continue;
            this.warnMethods.add(metaAccess.lookupJavaMethod((Executable)method));
        }
        for (Executable executable : clazz.getDeclaredConstructors()) {
            if (executable.getAnnotations().length != 0) continue;
            this.warnMethods.add(metaAccess.lookupJavaMethod(executable));
        }
    }

    private static int blacklistViolationComparator(GraalFeature.CallTreeNode n1, GraalFeature.CallTreeNode n2) {
        int result = n1.getTargetMethod().getQualifiedName().compareTo(n2.getTargetMethod().getQualifiedName());
        if (result == 0) {
            result = n1.getSourceReference().compareTo(n2.getSourceReference());
        }
        return result;
    }

    public void beforeCompilation(Feature.BeforeCompilationAccess config) {
        Optional<HostedType> optionalFrameType;
        Object cur;
        boolean printBlackListViolations;
        FeatureImpl.BeforeCompilationAccessImpl access = (FeatureImpl.BeforeCompilationAccessImpl)config;
        boolean failBlackListViolations = Options.TruffleCheckBlackListedMethods.getValue();
        boolean bl = printBlackListViolations = GraalFeature.Options.PrintRuntimeCompileMethods.getValue() != false || failBlackListViolations;
        if (printBlackListViolations && this.blacklistViolations.size() > 0) {
            System.out.println();
            System.out.println("=== Found " + this.blacklistViolations.size() + " compilation blacklist violations ===");
            System.out.println();
            for (GraalFeature.CallTreeNode node : this.blacklistViolations) {
                System.out.println("Blacklisted method");
                System.out.println(node.getImplementationMethod().format("  %H.%n(%p)"));
                System.out.println("called from");
                for (cur = node; cur != null; cur = ((GraalFeature.CallTreeNode)cur).getParent()) {
                    System.out.println("  " + ((GraalFeature.CallTreeNode)cur).getSourceReference());
                }
            }
            if (failBlackListViolations) {
                throw VMError.shouldNotReachHere("Blacklisted methods are reachable for runtime compilation");
            }
        }
        if (this.warnViolations.size() > 0) {
            Object printNode = null;
            int printLength = Integer.MAX_VALUE;
            cur = this.warnViolations.iterator();
            while (cur.hasNext()) {
                GraalFeature.CallTreeNode warnNode = cur.next();
                int warnLength = 0;
                for (GraalFeature.CallTreeNode cur2 = warnNode; cur2 != null; cur2 = cur2.getParent()) {
                    ++warnLength;
                }
                if (warnLength >= printLength) continue;
                printNode = warnNode;
                printLength = warnLength;
            }
            System.out.println("WARNING: suspicious method reachable for runtime compilation: " + ((GraalFeature.CallTreeNode)printNode).getImplementationMethod().format("%H.%n(%p)"));
            System.out.println("Check the complete tree of reachable methods using the option " + GraalFeature.Options.PrintRuntimeCompileMethods.getDescriptor().getFieldName());
            System.out.println("Suspicious method is called from");
            for (cur = printNode; cur != null; cur = ((GraalFeature.CallTreeNode)cur).getParent()) {
                System.out.println("  " + ((GraalFeature.CallTreeNode)cur).getSourceReference());
            }
        }
        if (this.neverPartOfCompilationViolations.size() > 0) {
            System.out.println("ERROR: CompilerAsserts.neverPartOfCompilation reachable for runtime compilation from " + this.neverPartOfCompilationViolations.size() + " places:");
            for (GraalFeature.CallTreeNode neverPartOfCompilationNode : this.neverPartOfCompilationViolations) {
                System.out.println("called from");
                for (cur = neverPartOfCompilationNode; cur != null; cur = ((GraalFeature.CallTreeNode)cur).getParent()) {
                    System.out.println("  " + ((GraalFeature.CallTreeNode)cur).getSourceReference());
                }
            }
            throw VMError.shouldNotReachHere("CompilerAsserts.neverPartOfCompilation reachable for runtime compilation");
        }
        if (Options.TruffleCheckFrameImplementation.getValue().booleanValue() && TruffleFeature.useTruffleCompiler() && (optionalFrameType = access.getMetaAccess().optionalLookupJavaType(Frame.class)).isPresent()) {
            HostedType frameType = optionalFrameType.get();
            HashSet<HostedType> implementations = new HashSet<HostedType>();
            TruffleFeature.collectImplementations(frameType, implementations);
            if (implementations.size() > 1) {
                throw UserError.abort("More than one implementation of %s found. For performance reasons, Truffle languages must not provide new implementations, and instead only use the single implementation provided by the Truffle runtime. To disable this check, add %s to the native-image command line. Found classes: %s", Frame.class.getTypeName(), SubstrateOptionsParser.commandArgument(Options.TruffleCheckFrameImplementation, "-"), implementations.stream().map(m -> m.toJavaName(true)).collect(Collectors.joining(", ")));
            }
            assert (implementations.size() == 0 || implementations.iterator().next() == frameType.getSingleImplementor());
        }
    }

    private static void collectImplementations(HostedType type, Set<HostedType> implementations) {
        for (HostedType subType : type.getSubTypes()) {
            if (!subType.isAbstract()) {
                implementations.add(subType);
            }
            TruffleFeature.collectImplementations(subType, implementations);
        }
    }

    static class TruffleParsingInlineInvokePlugin
    implements InlineInvokePlugin {
        private final SVMHost hostVM;
        private final Replacements replacements;
        private final InvocationPlugins invocationPlugins;
        private final PartialEvaluator partialEvaluator;
        private final Predicate<ResolvedJavaMethod> includeMethodPredicate;

        TruffleParsingInlineInvokePlugin(SVMHost hostVM, Replacements replacements, InvocationPlugins invocationPlugins, PartialEvaluator partialEvaluator, Predicate<ResolvedJavaMethod> includeMethodPredicate) {
            this.hostVM = hostVM;
            this.replacements = replacements;
            this.invocationPlugins = invocationPlugins;
            this.partialEvaluator = partialEvaluator;
            this.includeMethodPredicate = includeMethodPredicate;
        }

        public InlineInvokePlugin.InlineInfo shouldInlineInvoke(GraphBuilderContext builder, ResolvedJavaMethod original, ValueNode[] arguments) {
            if (SubstrateUtil.NativeImageLoadingShield.isNeverInline(original)) {
                return InlineInvokePlugin.InlineInfo.DO_NOT_INLINE_WITH_EXCEPTION;
            }
            if (this.invocationPlugins.lookupInvocation(original) != null) {
                return InlineInvokePlugin.InlineInfo.DO_NOT_INLINE_WITH_EXCEPTION;
            }
            if (original.getAnnotation(ExplodeLoop.class) != null) {
                return InlineInvokePlugin.InlineInfo.DO_NOT_INLINE_WITH_EXCEPTION;
            }
            if (builder.getMethod().getAnnotation(ExplodeLoop.class) != null) {
                return InlineInvokePlugin.InlineInfo.DO_NOT_INLINE_WITH_EXCEPTION;
            }
            if (this.replacements.hasSubstitution(original)) {
                return InlineInvokePlugin.InlineInfo.DO_NOT_INLINE_WITH_EXCEPTION;
            }
            for (ResolvedJavaMethod m : this.partialEvaluator.getNeverInlineMethods()) {
                if (!original.equals(m)) continue;
                return InlineInvokePlugin.InlineInfo.DO_NOT_INLINE_WITH_EXCEPTION;
            }
            if (original.getCode() != null && this.includeMethodPredicate.test(original) && this.hostVM.isAnalysisTrivialMethod((AnalysisMethod)original) && builder.getDepth() < (Integer)BytecodeParserOptions.InlineDuringParsingMaxDepth.getValue(HostedOptionValues.singleton())) {
                return InlineInvokePlugin.InlineInfo.createStandardInlineInfo((ResolvedJavaMethod)original);
            }
            return null;
        }
    }

    public static class Support {
        public SubstrateOptimizedCallTarget createOptimizedCallTarget(OptimizedCallTarget sourceCallTarget, RootNode rootNode) {
            return new SubstrateOptimizedCallTarget(sourceCallTarget, rootNode);
        }

        public SubstratePartialEvaluator createPartialEvaluator(Providers providers, GraphBuilderConfiguration configForRoot, SnippetReflectionProvider snippetReflection, Architecture architecture) {
            return new SubstratePartialEvaluator(providers, configForRoot, snippetReflection, architecture);
        }

        public void registerInterpreterEntryMethodsAsCompiled(PartialEvaluator partialEvaluator, Feature.BeforeAnalysisAccess access) {
        }

        public SubstrateTruffleCompiler createTruffleCompiler(SubstrateTruffleRuntime runtime) {
            SubstrateTruffleCompiler compiler = Support.createSubstrateTruffleCompilerImpl(runtime);
            if (SubstrateOptions.supportCompileInIsolates()) {
                compiler = new IsolateAwareTruffleCompiler(compiler);
            }
            return compiler;
        }

        protected static SubstrateTruffleCompiler createSubstrateTruffleCompilerImpl(SubstrateTruffleRuntime runtime) {
            com.oracle.svm.graal.hosted.GraalFeature graalFeature = (com.oracle.svm.graal.hosted.GraalFeature)ImageSingletons.lookup(com.oracle.svm.graal.hosted.GraalFeature.class);
            SnippetReflectionProvider snippetReflectionProvider = graalFeature.getHostedProviders().getSnippetReflection();
            return new SubstrateTruffleCompilerImpl((TruffleCompilerRuntime)runtime, graalFeature.getHostedProviders().getGraphBuilderPlugins(), GraalSupport.getSuites(), GraalSupport.getLIRSuites(), GraalSupport.getRuntimeConfig().getBackendForNormalMethod(), GraalSupport.getFirstTierSuites(), GraalSupport.getFirstTierLirSuites(), GraalSupport.getFirstTierProviders(), snippetReflectionProvider);
        }

        protected static boolean isIsolatedCompilation() {
            return !SubstrateUtil.HOSTED && SubstrateOptions.shouldCompileInIsolates();
        }

        public Consumer<OptimizedAssumptionDependency> registerOptimizedAssumptionDependency(JavaConstant optimizedAssumptionConstant) {
            if (Support.isIsolatedCompilation()) {
                return IsolatedTruffleRuntimeSupport.registerOptimizedAssumptionDependency(optimizedAssumptionConstant);
            }
            Object target = SubstrateObjectConstant.asObject((Constant)optimizedAssumptionConstant);
            OptimizedAssumption assumption = (OptimizedAssumption)KnownIntrinsics.convertUnknownValue(target, Object.class);
            return assumption.registerDependency();
        }

        public JavaConstant getCallTargetForCallNode(JavaConstant callNodeConstant) {
            if (Support.isIsolatedCompilation()) {
                return IsolatedTruffleRuntimeSupport.getCallTargetForCallNode(callNodeConstant);
            }
            Object target = SubstrateObjectConstant.asObject((Constant)callNodeConstant);
            OptimizedDirectCallNode callNode = (OptimizedDirectCallNode)KnownIntrinsics.convertUnknownValue(target, Object.class);
            OptimizedCallTarget callTarget = callNode.getCallTarget();
            return SubstrateObjectConstant.forObject(callTarget);
        }

        public BackgroundCompileQueue createBackgroundCompileQueue(SubstrateTruffleRuntime runtime) {
            return new BackgroundCompileQueue((GraalTruffleRuntime)runtime);
        }

        public CompilableTruffleAST asCompilableTruffleAST(JavaConstant constant) {
            if (Support.isIsolatedCompilation()) {
                return IsolatedTruffleRuntimeSupport.asCompilableTruffleAST(constant);
            }
            return (CompilableTruffleAST)KnownIntrinsics.convertUnknownValue(SubstrateObjectConstant.asObject(OptimizedCallTarget.class, constant), Object.class);
        }

        public boolean tryLog(SubstrateTruffleRuntime runtime, String loggerId, CompilableTruffleAST compilable, String message) {
            if (Support.isIsolatedCompilation()) {
                return IsolatedTruffleRuntimeSupport.tryLog(loggerId, compilable, message);
            }
            return false;
        }

        public TriState tryIsSuppressedFailure(CompilableTruffleAST compilable, Supplier<String> serializedException) {
            if (Support.isIsolatedCompilation()) {
                return IsolatedTruffleRuntimeSupport.tryIsSuppressedFailure(compilable, serializedException);
            }
            return TriState.UNDEFINED;
        }
    }

    public static final class IsCreateProcessDisabled
    implements BooleanSupplier {
        static final boolean ALLOW_CREATE_PROCESS = IsCreateProcessDisabled.query();

        static boolean query() {
            try {
                Class<?> clazz = Class.forName("com.oracle.truffle.polyglot.PolyglotEngineImpl");
                boolean allowCreateProcess = (Boolean)ReflectionUtil.readField(clazz, (String)"ALLOW_CREATE_PROCESS", null);
                return !allowCreateProcess;
            }
            catch (ReflectiveOperationException e) {
                throw VMError.shouldNotReachHere(e);
            }
        }

        @Override
        public boolean getAsBoolean() {
            return ALLOW_CREATE_PROCESS;
        }
    }

    public static final class IsEnabled
    implements BooleanSupplier {
        @Override
        public boolean getAsBoolean() {
            return ImageSingletons.contains(TruffleFeature.class);
        }
    }

    public static class Options {
        @Option(help={"Check that CompilerAsserts.neverPartOfCompilation is not reachable for runtime compilation"})
        public static final HostedOptionKey<Boolean> TruffleCheckNeverPartOfCompilation = new HostedOptionKey<Boolean>(true);
        @Option(help={"Enforce that the Truffle runtime provides the only implementation of Frame"})
        public static final HostedOptionKey<Boolean> TruffleCheckFrameImplementation = new HostedOptionKey<Boolean>(true);
        @Option(help={"Fail if a method known as not suitable for partial evaluation is reachable for runtime compilation"})
        public static final HostedOptionKey<Boolean> TruffleCheckBlackListedMethods = new HostedOptionKey<Boolean>(false);
        @Option(help={"Inline trivial methods in Truffle graphs during native image generation"})
        public static final HostedOptionKey<Boolean> TruffleInlineDuringParsing = new HostedOptionKey<Boolean>(true);
    }
}

