/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.svm.hosted.image;

import com.oracle.graal.pointsto.meta.AnalysisUniverse;
import com.oracle.graal.pointsto.util.AnalysisError;
import com.oracle.svm.core.StaticFieldsSupport;
import com.oracle.svm.core.SubstrateOptions;
import com.oracle.svm.core.config.ConfigurationValues;
import com.oracle.svm.core.config.ObjectLayout;
import com.oracle.svm.core.heap.FillerObject;
import com.oracle.svm.core.heap.Heap;
import com.oracle.svm.core.hub.DynamicHub;
import com.oracle.svm.core.hub.LayoutEncoding;
import com.oracle.svm.core.image.ImageHeap;
import com.oracle.svm.core.image.ImageHeapLayouter;
import com.oracle.svm.core.image.ImageHeapObject;
import com.oracle.svm.core.image.ImageHeapPartition;
import com.oracle.svm.core.jdk.StringInternSupport;
import com.oracle.svm.core.meta.SubstrateObjectConstant;
import com.oracle.svm.core.util.HostedStringDeduplication;
import com.oracle.svm.core.util.UserError;
import com.oracle.svm.core.util.VMError;
import com.oracle.svm.hosted.config.HybridLayout;
import com.oracle.svm.hosted.image.StringInternFeature;
import com.oracle.svm.hosted.meta.HostedArrayClass;
import com.oracle.svm.hosted.meta.HostedClass;
import com.oracle.svm.hosted.meta.HostedField;
import com.oracle.svm.hosted.meta.HostedInstanceClass;
import com.oracle.svm.hosted.meta.HostedMetaAccess;
import com.oracle.svm.hosted.meta.HostedType;
import com.oracle.svm.hosted.meta.HostedUniverse;
import com.oracle.svm.hosted.meta.MaterializedConstantFields;
import com.oracle.svm.hosted.meta.UniverseBuilder;
import java.lang.reflect.Array;
import java.lang.reflect.Modifier;
import java.util.ArrayDeque;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Deque;
import java.util.HashMap;
import java.util.IdentityHashMap;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import jdk.vm.ci.meta.Constant;
import jdk.vm.ci.meta.JavaConstant;
import jdk.vm.ci.meta.JavaKind;
import jdk.vm.ci.meta.MetaAccessProvider;
import jdk.vm.ci.meta.ResolvedJavaType;
import org.graalvm.compiler.api.replacements.Fold;
import org.graalvm.compiler.core.common.CompressEncoding;
import org.graalvm.compiler.core.common.NumUtil;
import org.graalvm.compiler.core.common.SuppressFBWarnings;
import org.graalvm.nativeimage.ImageSingletons;
import org.graalvm.nativeimage.c.function.RelocatedPointer;
import org.graalvm.word.UnsignedWord;
import org.graalvm.word.WordBase;

public final class NativeImageHeap
implements ImageHeap {
    private final HostedUniverse universe;
    private final AnalysisUniverse aUniverse;
    private final HostedMetaAccess metaAccess;
    private final ObjectLayout objectLayout;
    private final ImageHeapLayouter heapLayouter;
    private final int minInstanceSize;
    private final int minArraySize;
    protected final IdentityHashMap<Object, ObjectInfo> objects = new IdentityHashMap();
    private final Set<Object> blacklist = Collections.newSetFromMap(new IdentityHashMap());
    private final Map<HostedClass, HybridLayout<?>> hybridLayouts = new HashMap();
    private final Map<String, String> internedStrings = new HashMap<String, String>();
    private final Phase addObjectsPhase = Phase.factory();
    private final Phase internStringsPhase = Phase.factory();
    private final Deque<AddObjectData> addObjectWorklist = new ArrayDeque<AddObjectData>();
    private final Set<Object> knownImmutableObjects = Collections.newSetFromMap(new IdentityHashMap());

    public NativeImageHeap(AnalysisUniverse aUniverse, HostedUniverse universe, HostedMetaAccess metaAccess, ImageHeapLayouter heapLayouter) {
        this.aUniverse = aUniverse;
        this.universe = universe;
        this.metaAccess = metaAccess;
        this.objectLayout = ConfigurationValues.getObjectLayout();
        this.heapLayouter = heapLayouter;
        this.minInstanceSize = this.objectLayout.getMinimumInstanceObjectSize();
        this.minArraySize = this.objectLayout.getMinimumArraySize();
        assert (this.assertFillerObjectSizes());
    }

    public Collection<ObjectInfo> getObjects() {
        return this.objects.values();
    }

    public int getObjectCount() {
        return this.objects.size();
    }

    public ObjectInfo getObjectInfo(Object obj) {
        return this.objects.get(obj);
    }

    protected HostedUniverse getUniverse() {
        return this.universe;
    }

    protected HostedMetaAccess getMetaAccess() {
        return this.metaAccess;
    }

    protected AnalysisUniverse getAnalysisUniverse() {
        return this.aUniverse;
    }

    protected HybridLayout<?> getHybridLayout(HostedClass clazz) {
        return this.hybridLayouts.get(clazz);
    }

    protected boolean isBlacklisted(Object obj) {
        return this.blacklist.contains(obj);
    }

    protected ObjectLayout getObjectLayout() {
        return this.objectLayout;
    }

    public ImageHeapLayouter getLayouter() {
        return this.heapLayouter;
    }

    @Fold
    static boolean useHeapBase() {
        return SubstrateOptions.SpawnIsolates.getValue() != false && ((CompressEncoding)ImageSingletons.lookup(CompressEncoding.class)).hasBase();
    }

    @Fold
    static boolean spawnIsolates() {
        return SubstrateOptions.SpawnIsolates.getValue() != false && NativeImageHeap.useHeapBase();
    }

    public void addInitialObjects() {
        this.addObjectsPhase.allow();
        this.internStringsPhase.allow();
        this.addStaticFields();
    }

    public void addTrailingObjects() {
        this.processAddObjectWorklist();
        HostedField internedStringsField = (HostedField)StringInternFeature.getInternedStringsField((MetaAccessProvider)this.metaAccess);
        boolean usesInternedStrings = internedStringsField.isAccessed();
        if (usesInternedStrings) {
            this.addObject(this.getMetaAccess().lookupJavaType((Class)String[].class).getHub(), false, "internedStrings table");
            this.internStringsPhase.disallow();
            Object[] imageInternedStrings = this.internedStrings.keySet().toArray(new String[0]);
            Arrays.sort(imageInternedStrings);
            ((StringInternSupport)ImageSingletons.lookup(StringInternSupport.class)).setImageInternedStrings((String[])imageInternedStrings);
            this.addObject(imageInternedStrings, true, "internedStrings table");
            this.processAddObjectWorklist();
        } else {
            this.internStringsPhase.disallow();
        }
        this.addObjectsPhase.disallow();
        assert (this.addObjectWorklist.isEmpty());
    }

    private static Object readObjectField(HostedField field, JavaConstant receiver) {
        return SubstrateObjectConstant.asObject((Constant)field.readStorageValue(receiver));
    }

    private void addStaticFields() {
        this.addObject(StaticFieldsSupport.getStaticObjectFields(), false, "staticObjectFields");
        this.addObject(StaticFieldsSupport.getStaticPrimitiveFields(), false, "staticPrimitiveFields");
        for (HostedField field : this.getUniverse().getFields()) {
            if (!Modifier.isStatic(field.getModifiers()) || !field.hasLocation() || field.getType().getStorageKind() != JavaKind.Object) continue;
            assert (field.isWritten() || MaterializedConstantFields.singleton().contains(field.wrapped));
            this.addObject(NativeImageHeap.readObjectField(field, null), false, field);
        }
    }

    public void registerAsImmutable(Object object) {
        assert (this.addObjectsPhase.isBefore()) : "Registering immutable object too late: phase: " + this.addObjectsPhase.toString();
        this.knownImmutableObjects.add(object);
    }

    public void addObject(Object original, boolean immutableFromParent, Object reason) {
        ObjectInfo existing;
        assert (this.addObjectsPhase.isAllowed()) : "Objects cannot be added at phase: " + this.addObjectsPhase.toString() + " with reason: " + reason;
        if (original == null || original instanceof WordBase) {
            return;
        }
        if (original instanceof Class) {
            throw VMError.shouldNotReachHere("Must not have Class in native image heap: " + original);
        }
        if (original instanceof DynamicHub && ((DynamicHub)original).getClassInitializationInfo() == null) {
            throw NativeImageHeap.reportIllegalType(original, reason);
        }
        int identityHashCode = original instanceof DynamicHub ? System.identityHashCode(this.universe.hostVM().lookupType((DynamicHub)original).getJavaClass()) : System.identityHashCode(original);
        VMError.guarantee(identityHashCode != 0, "0 is used as a marker value for 'hash code not yet computed'");
        if (original instanceof String) {
            this.handleImageString((String)original);
        }
        if ((existing = this.objects.get(original)) == null) {
            this.addObjectToBootImageHeap(original, immutableFromParent, identityHashCode, reason);
        }
    }

    @Override
    public int countDynamicHubs() {
        int count = 0;
        for (ObjectInfo o : this.getObjects()) {
            if (!(o.getObject() instanceof DynamicHub)) continue;
            ++count;
        }
        return count;
    }

    @Override
    public ObjectInfo addFillerObject(int size) {
        if (size >= this.minArraySize) {
            int elementSize = this.objectLayout.getArrayIndexScale(JavaKind.Int);
            int arrayLength = (size - this.minArraySize) / elementSize;
            assert (this.objectLayout.getArraySize(JavaKind.Int, arrayLength) == (long)size);
            return this.addLateToImageHeap(new int[arrayLength], "Filler object");
        }
        if (size >= this.minInstanceSize) {
            return this.addLateToImageHeap(new FillerObject(), "Filler object");
        }
        return null;
    }

    private boolean assertFillerObjectSizes() {
        assert ((long)this.minArraySize == this.objectLayout.getArraySize(JavaKind.Int, 0));
        ResolvedJavaType filler = this.metaAccess.lookupJavaType((Class)FillerObject.class);
        UnsignedWord fillerSize = LayoutEncoding.getInstanceSize(filler.getHub().getLayoutEncoding());
        assert (fillerSize.equal(this.minInstanceSize));
        assert (this.minInstanceSize * 2 >= this.minArraySize) : "otherwise, we might need more than one non-array object";
        return true;
    }

    private void handleImageString(String str) {
        NativeImageHeap.forceHashCodeComputation(str);
        if (HostedStringDeduplication.isInternedString(str)) {
            assert (this.internedStrings.containsKey(str) || this.internStringsPhase.isAllowed()) : "Should not intern string during phase " + this.internStringsPhase.toString();
            this.internedStrings.put(str, str);
        }
    }

    @SuppressFBWarnings(value={"RV_RETURN_VALUE_IGNORED"}, justification="eager hash field computation")
    private static void forceHashCodeComputation(String str) {
        str.hashCode();
    }

    /*
     * Unable to fully structure code
     * Could not resolve type clashes
     */
    private void addObjectToBootImageHeap(Object object, boolean immutableFromParent, int identityHashCode, Object reason) {
        optionalType = this.getMetaAccess().optionalLookupJavaType(object.getClass());
        type = NativeImageHeap.requireType(optionalType, object, reason);
        hub = type.getHub();
        immutable = immutableFromParent != false || this.isKnownImmutable(object) != false;
        written = false;
        references = false;
        relocatable = false;
        if (type.isInstanceClass()) {
            clazz = (HostedInstanceClass)type;
            if (clazz.getMonitorFieldOffset() != 0) {
                written = true;
                references = true;
            }
            con = SubstrateObjectConstant.forObject(object);
            hybridTypeIDSlotsField = null;
            hybridBitsetField = null;
            hybridArrayField = null;
            hybridArray = null;
            if (HybridLayout.isHybrid(clazz)) {
                hybridLayout /* !! */  = this.hybridLayouts.get(clazz);
                if (hybridLayout /* !! */  == null) {
                    hybridLayout /* !! */  = new HybridLayout<T>(clazz, this.objectLayout);
                    this.hybridLayouts.put(clazz, hybridLayout /* !! */ );
                }
                containsTypeIDSlot = false;
                hybridTypeIDSlotsField = hybridLayout /* !! */ .getTypeIDSlotsField();
                if (hybridTypeIDSlotsField != null && (typeIDSlots = NativeImageHeap.readObjectField(hybridTypeIDSlotsField, con)) != null) {
                    this.blacklist.add(typeIDSlots);
                    containsTypeIDSlot = true;
                }
                if ((hybridBitsetField = hybridLayout /* !! */ .getBitsetField()) != null && (bitSet = NativeImageHeap.readObjectField(hybridBitsetField, con)) != null) {
                    this.blacklist.add(bitSet);
                    VMError.guarantee(containsTypeIDSlot == false, "Hub cannot contain both a bitset and typeID slots.");
                }
                if ((hybridArray = NativeImageHeap.readObjectField(hybridArrayField = hybridLayout /* !! */ .getArrayField(), con)) != null) {
                    this.blacklist.add(hybridArray);
                    written = true;
                }
                size = hybridLayout /* !! */ .getTotalSize(Array.getLength(hybridArray));
            } else {
                size = LayoutEncoding.getInstanceSize(hub.getLayoutEncoding()).rawValue();
            }
            info = this.addToImageHeap(object, clazz, size, identityHashCode, reason);
            try {
                this.recursiveAddObject(hub, false, info);
                fieldsAreImmutable = object instanceof String;
                for (HostedField field : clazz.getInstanceFields(true)) {
                    if (!field.isInImageHeap() || field.equals(hybridArrayField) || field.equals(hybridBitsetField) || field.equals(hybridTypeIDSlotsField)) continue;
                    fieldRelocatable = false;
                    if (field.getJavaKind() == JavaKind.Object) {
                        if (!NativeImageHeap.$assertionsDisabled && !field.hasLocation()) {
                            throw new AssertionError();
                        }
                        fieldValueConstant = field.readValue(con);
                        if (fieldValueConstant.getJavaKind() == JavaKind.Object) {
                            fieldValue = SubstrateObjectConstant.asObject((Constant)fieldValueConstant);
                            if (NativeImageHeap.spawnIsolates()) {
                                fieldRelocatable = fieldValue instanceof RelocatedPointer;
                            }
                            this.recursiveAddObject(fieldValue, fieldsAreImmutable, info);
                            references = true;
                        }
                    }
                    relocatable = relocatable != false || fieldRelocatable != false;
                    written = written != false || field.isWritten() != false && field.isFinal() == false && fieldRelocatable == false;
                }
                if (!(hybridArray instanceof Object[])) ** GOTO lbl81
                relocatable = this.addArrayElements((Object[])hybridArray, relocatable, info);
                references = true;
            }
            catch (AnalysisError.TypeNotFoundError ex) {
                throw NativeImageHeap.reportIllegalType(ex.getType(), info);
            }
        } else if (type.isArray()) {
            clazz = (HostedArrayClass)type;
            size = this.objectLayout.getArraySize(type.getComponentType().getStorageKind(), Array.getLength(object));
            info = this.addToImageHeap(object, clazz, size, identityHashCode, reason);
            try {
                this.recursiveAddObject(hub, false, info);
                if (object instanceof Object[]) {
                    relocatable = this.addArrayElements((Object[])object, false, info);
                    references = true;
                }
                written = true;
            }
            catch (AnalysisError.TypeNotFoundError ex) {
                throw NativeImageHeap.reportIllegalType(ex.getType(), info);
            }
        } else {
            throw VMError.shouldNotReachHere();
        }
lbl81:
        // 3 sources

        if (relocatable && !this.isKnownImmutable(object)) {
            VMError.shouldNotReachHere("Object with relocatable pointers must be explicitly immutable: " + object);
        }
        this.heapLayouter.assignObjectToPartition(info, written == false || immutable != false, references, relocatable);
    }

    private static HostedType requireType(Optional<HostedType> optionalType, Object object, Object reason) {
        if (!optionalType.isPresent() || !optionalType.get().isInstantiated()) {
            throw NativeImageHeap.reportIllegalType(object, reason);
        }
        return optionalType.get();
    }

    static RuntimeException reportIllegalType(Object object, Object reason) {
        StringBuilder msg = new StringBuilder();
        msg.append("Image heap writing found a class not seen during static analysis. ");
        msg.append("Did a static field or an object referenced from a static field change during native image generation? ");
        msg.append("For example, a lazily initialized cache could have been initialized during image generation, in which case ");
        msg.append("you need to force eager initialization of the cache before static analysis or reset the cache using a field ");
        msg.append("value recomputation.").append(System.lineSeparator()).append("    ");
        if (object instanceof DynamicHub) {
            msg.append("class: ").append(((DynamicHub)object).getName());
        } else if (object instanceof ResolvedJavaType) {
            msg.append("class: ").append(((ResolvedJavaType)object).toJavaName(true));
        } else {
            msg.append("object: ").append(object).append("  of class: ").append(object.getClass().getTypeName());
        }
        msg.append(System.lineSeparator()).append("  reachable through:").append(System.lineSeparator());
        NativeImageHeap.fillReasonStack(msg, reason);
        throw UserError.abort("%s", msg);
    }

    private static StringBuilder fillReasonStack(StringBuilder msg, Object reason) {
        if (reason instanceof ObjectInfo) {
            ObjectInfo info = (ObjectInfo)reason;
            msg.append("    object: ").append(info.getObject()).append("  of class: ").append(info.getObject().getClass().getTypeName()).append(System.lineSeparator());
            return NativeImageHeap.fillReasonStack(msg, info.reason);
        }
        return msg.append("    root: ").append(reason).append(System.lineSeparator());
    }

    private boolean isKnownImmutable(Object obj) {
        if (obj instanceof String) {
            return obj.hashCode() != 0;
        }
        return UniverseBuilder.isKnownImmutableType(obj.getClass()) || this.knownImmutableObjects.contains(obj);
    }

    private ObjectInfo addToImageHeap(Object object, HostedClass clazz, long size, int identityHashCode, Object reason) {
        ObjectInfo info = new ObjectInfo(object, size, clazz, identityHashCode, reason);
        assert (!this.objects.containsKey(object));
        this.objects.put(object, info);
        return info;
    }

    @Override
    public ObjectInfo addLateToImageHeap(Object object, String reason) {
        assert (!(object instanceof DynamicHub)) : "needs a different identity hashcode";
        assert (!(object instanceof String)) : "needs String interning";
        Optional<HostedType> optionalType = this.getMetaAccess().optionalLookupJavaType(object.getClass());
        HostedType type = NativeImageHeap.requireType(optionalType, object, reason);
        return this.addToImageHeap(object, (HostedClass)type, this.getSize(object, type), System.identityHashCode(object), reason);
    }

    private long getSize(Object object, HostedType type) {
        if (type.isInstanceClass()) {
            HostedInstanceClass clazz = (HostedInstanceClass)type;
            assert (!HybridLayout.isHybrid(clazz));
            return LayoutEncoding.getInstanceSize(clazz.getHub().getLayoutEncoding()).rawValue();
        }
        if (type.isArray()) {
            return this.objectLayout.getArraySize(type.getComponentType().getStorageKind(), Array.getLength(object));
        }
        throw VMError.shouldNotReachHere();
    }

    private boolean addArrayElements(Object[] array, boolean otherFieldsRelocatable, Object reason) {
        boolean relocatable = otherFieldsRelocatable;
        for (Object element : array) {
            Object value = this.aUniverse.replaceObject(element);
            if (NativeImageHeap.spawnIsolates()) {
                relocatable = relocatable || value instanceof RelocatedPointer;
            }
            this.recursiveAddObject(value, false, reason);
        }
        return relocatable;
    }

    private void recursiveAddObject(Object original, boolean immutableFromParent, Object reason) {
        if (original != null) {
            this.addObjectWorklist.push(new AddObjectData(original, immutableFromParent, reason));
        }
    }

    private void processAddObjectWorklist() {
        while (!this.addObjectWorklist.isEmpty()) {
            AddObjectData data = this.addObjectWorklist.pop();
            this.addObject(data.original, data.immutableFromParent, data.reason);
        }
    }

    protected static final class Phase {
        private PhaseValue value = PhaseValue.BEFORE;

        public static Phase factory() {
            return new Phase();
        }

        public boolean isBefore() {
            return this.value == PhaseValue.BEFORE;
        }

        public void allow() {
            assert (this.value == PhaseValue.BEFORE) : "Can not allow while in phase " + this.value.toString();
            this.value = PhaseValue.ALLOWED;
        }

        void disallow() {
            assert (this.value == PhaseValue.ALLOWED) : "Can not disallow while in phase " + this.value.toString();
            this.value = PhaseValue.AFTER;
        }

        public boolean isAllowed() {
            return this.value == PhaseValue.ALLOWED;
        }

        public String toString() {
            return this.value.toString();
        }

        protected Phase() {
        }

        private static enum PhaseValue {
            BEFORE,
            ALLOWED,
            AFTER;

        }
    }

    public static final class ObjectInfo
    implements ImageHeapObject {
        private final Object object;
        private final HostedClass clazz;
        private final long size;
        private final int identityHashCode;
        private ImageHeapPartition partition;
        private long offsetInPartition;
        final Object reason;

        ObjectInfo(Object object, long size, HostedClass clazz, int identityHashCode, Object reason) {
            this.object = object;
            this.clazz = clazz;
            this.partition = null;
            this.offsetInPartition = -1L;
            this.size = size;
            this.identityHashCode = identityHashCode;
            this.reason = reason;
        }

        @Override
        public Object getObject() {
            return this.object;
        }

        public HostedClass getClazz() {
            return this.clazz;
        }

        @Override
        public long getOffset() {
            assert (this.offsetInPartition >= 0L);
            assert (this.partition != null);
            return this.partition.getStartOffset() + this.offsetInPartition;
        }

        @Override
        public void setOffsetInPartition(long value) {
            assert (this.offsetInPartition == -1L && value >= 0L);
            this.offsetInPartition = value;
        }

        @Override
        public ImageHeapPartition getPartition() {
            return this.partition;
        }

        @Override
        public void setHeapPartition(ImageHeapPartition value) {
            assert (this.partition == null);
            this.partition = value;
        }

        public int getIndexInBuffer(long index) {
            long result = this.getOffset() + index;
            return NumUtil.safeToInt((long)result);
        }

        public long getAddress() {
            return (long)Heap.getHeap().getImageHeapOffsetInAddressSpace() + this.getOffset();
        }

        public long getAddress(long delta) {
            assert (delta >= 0L && delta < this.getSize()) : "Index: " + delta + " out of bounds: [0 .. " + this.getSize() + ").";
            return this.getAddress() + delta;
        }

        @Override
        public long getSize() {
            return this.size;
        }

        int getIdentityHashCode() {
            return this.identityHashCode;
        }

        public String toString() {
            StringBuilder result = new StringBuilder(this.getObject().getClass().getName()).append(" -> ");
            Object cur = this.reason;
            Object prev = null;
            boolean skipped = false;
            while (cur instanceof ObjectInfo) {
                skipped = prev != null;
                prev = cur;
                cur = ((ObjectInfo)cur).reason;
            }
            if (skipped) {
                result.append("... -> ");
            }
            if (prev != null) {
                result.append(prev);
            } else {
                result.append(cur);
            }
            return result.toString();
        }
    }

    static class AddObjectData {
        final Object original;
        final boolean immutableFromParent;
        final Object reason;

        AddObjectData(Object original, boolean immutableFromParent, Object reason) {
            this.original = original;
            this.immutableFromParent = immutableFromParent;
            this.reason = reason;
        }
    }
}

