/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.svm.hosted.image;

import com.oracle.graal.pointsto.infrastructure.OriginalClassProvider;
import com.oracle.graal.pointsto.meta.AnalysisType;
import com.oracle.objectfile.debuginfo.DebugInfoProvider;
import com.oracle.svm.core.SubstrateOptions;
import com.oracle.svm.core.graal.code.SubstrateBackend;
import com.oracle.svm.hosted.image.NativeBootImage;
import com.oracle.svm.hosted.image.NativeImageCodeCache;
import com.oracle.svm.hosted.image.NativeImageHeap;
import com.oracle.svm.hosted.image.sources.SourceManager;
import com.oracle.svm.hosted.meta.HostedMethod;
import com.oracle.svm.hosted.meta.HostedType;
import java.nio.file.Path;
import java.util.LinkedList;
import java.util.List;
import java.util.function.Consumer;
import java.util.stream.Stream;
import jdk.vm.ci.meta.LineNumberTable;
import jdk.vm.ci.meta.ResolvedJavaMethod;
import jdk.vm.ci.meta.ResolvedJavaType;
import org.graalvm.compiler.code.CompilationResult;
import org.graalvm.compiler.code.SourceMapping;
import org.graalvm.compiler.debug.DebugContext;
import org.graalvm.compiler.graph.NodeSourcePosition;
import org.graalvm.nativeimage.ImageSingletons;

class NativeImageDebugInfoProvider
implements DebugInfoProvider {
    private final DebugContext debugContext;
    private final NativeImageCodeCache codeCache;
    private final NativeImageHeap heap;

    NativeImageDebugInfoProvider(DebugContext debugContext, NativeImageCodeCache codeCache, NativeImageHeap heap) {
        this.debugContext = debugContext;
        this.codeCache = codeCache;
        this.heap = heap;
    }

    public Stream<DebugInfoProvider.DebugTypeInfo> typeInfoProvider() {
        return Stream.empty();
    }

    public Stream<DebugInfoProvider.DebugCodeInfo> codeInfoProvider() {
        return this.codeCache.compilations.entrySet().stream().map(entry -> new NativeImageDebugCodeInfo((HostedMethod)entry.getKey(), (CompilationResult)entry.getValue()));
    }

    public Stream<DebugInfoProvider.DebugDataInfo> dataInfoProvider() {
        return Stream.empty();
    }

    private class NativeImageDebugFrameSizeChange
    implements DebugInfoProvider.DebugFrameSizeChange {
        private int offset;
        private DebugInfoProvider.DebugFrameSizeChange.Type type;

        NativeImageDebugFrameSizeChange(int offset, DebugInfoProvider.DebugFrameSizeChange.Type type) {
            this.offset = offset;
            this.type = type;
        }

        public int getOffset() {
            return this.offset;
        }

        public DebugInfoProvider.DebugFrameSizeChange.Type getType() {
            return this.type;
        }
    }

    private class NativeImageDebugLineInfo
    implements DebugInfoProvider.DebugLineInfo {
        private final int bci;
        private final ResolvedJavaMethod method;
        private final int lo;
        private final int hi;
        private Path cachePath;
        private Path fullFilePath;

        NativeImageDebugLineInfo(SourceMapping sourceMapping) {
            NodeSourcePosition position = sourceMapping.getSourcePosition();
            int posbci = position.getBCI();
            this.bci = posbci >= 0 ? posbci : 0;
            this.method = position.getMethod();
            this.lo = sourceMapping.getStartOffset();
            this.hi = sourceMapping.getEndOffset();
            this.cachePath = SubstrateOptions.getDebugInfoSourceCacheRoot();
            this.computeFullFilePath();
        }

        public String fileName() {
            Path fileName;
            if (this.fullFilePath != null && (fileName = this.fullFilePath.getFileName()) != null) {
                return fileName.toString();
            }
            return null;
        }

        public Path filePath() {
            if (this.fullFilePath != null) {
                return this.fullFilePath.getParent();
            }
            return null;
        }

        public Path cachePath() {
            return this.cachePath;
        }

        public String className() {
            return this.method.format("%H");
        }

        public String methodName() {
            return this.method.format("%n");
        }

        public String symbolNameForMethod() {
            return NativeBootImage.localSymbolNameForMethod(this.method);
        }

        public int addressLo() {
            return this.lo;
        }

        public int addressHi() {
            return this.hi;
        }

        public int line() {
            LineNumberTable lineNumberTable = this.method.getLineNumberTable();
            if (lineNumberTable != null) {
                return lineNumberTable.getLineNumber(this.bci);
            }
            return -1;
        }

        private void computeFullFilePath() {
            ResolvedJavaType declaringClass = this.method.getDeclaringClass();
            Class clazz = null;
            if (declaringClass instanceof OriginalClassProvider) {
                clazz = ((OriginalClassProvider)declaringClass).getJavaClass();
            }
            if (declaringClass instanceof HostedType) {
                declaringClass = ((HostedType)declaringClass).getWrapped();
            }
            if (declaringClass instanceof AnalysisType) {
                declaringClass = ((AnalysisType)declaringClass).getWrapped();
            }
            SourceManager sourceManager = (SourceManager)ImageSingletons.lookup(SourceManager.class);
            try (DebugContext.Scope s = NativeImageDebugInfoProvider.this.debugContext.scope((Object)"DebugCodeInfo", (Object)declaringClass);){
                this.fullFilePath = sourceManager.findAndCacheSource(declaringClass, clazz, NativeImageDebugInfoProvider.this.debugContext);
            }
            catch (Throwable e) {
                throw NativeImageDebugInfoProvider.this.debugContext.handle(e);
            }
        }
    }

    private class NativeImageDebugCodeInfo
    implements DebugInfoProvider.DebugCodeInfo {
        private final HostedMethod method;
        private final ResolvedJavaType javaType;
        private final CompilationResult compilation;
        private Path fullFilePath;
        private final Path cachePath;

        NativeImageDebugCodeInfo(HostedMethod method, CompilationResult compilation) {
            this.method = method;
            HostedType declaringClass = method.getDeclaringClass();
            Class<?> clazz = declaringClass.getJavaClass();
            this.javaType = declaringClass.getWrapped().getWrapped();
            this.compilation = compilation;
            this.cachePath = SubstrateOptions.getDebugInfoSourceCacheRoot();
            SourceManager sourceManager = (SourceManager)ImageSingletons.lookup(SourceManager.class);
            try (DebugContext.Scope s = NativeImageDebugInfoProvider.this.debugContext.scope((Object)"DebugCodeInfo", (Object)declaringClass);){
                this.fullFilePath = sourceManager.findAndCacheSource(this.javaType, clazz, NativeImageDebugInfoProvider.this.debugContext);
            }
            catch (Throwable e) {
                throw NativeImageDebugInfoProvider.this.debugContext.handle(e);
            }
        }

        public void debugContext(Consumer<DebugContext> action) {
            try (DebugContext.Scope s = NativeImageDebugInfoProvider.this.debugContext.scope((Object)"DebugCodeInfo", (Object)this.method);){
                action.accept(NativeImageDebugInfoProvider.this.debugContext);
            }
            catch (Throwable e) {
                throw NativeImageDebugInfoProvider.this.debugContext.handle(e);
            }
        }

        public String fileName() {
            Path filename;
            if (this.fullFilePath != null && (filename = this.fullFilePath.getFileName()) != null) {
                return filename.toString();
            }
            return "";
        }

        public Path filePath() {
            if (this.fullFilePath != null) {
                return this.fullFilePath.getParent();
            }
            return null;
        }

        public Path cachePath() {
            return this.cachePath;
        }

        public String className() {
            return this.javaType.toClassName();
        }

        public String methodName() {
            return this.method.format("%n");
        }

        public String symbolNameForMethod() {
            return NativeBootImage.localSymbolNameForMethod(this.method);
        }

        public String paramNames() {
            return this.method.format("%P");
        }

        public String returnTypeName() {
            return this.method.format("%R");
        }

        public int addressLo() {
            return this.method.getCodeAddressOffset();
        }

        public int addressHi() {
            return this.method.getCodeAddressOffset() + this.compilation.getTargetCodeSize();
        }

        public int line() {
            LineNumberTable lineNumberTable = this.method.getLineNumberTable();
            if (lineNumberTable != null) {
                return lineNumberTable.getLineNumber(0);
            }
            return -1;
        }

        public Stream<DebugInfoProvider.DebugLineInfo> lineInfoProvider() {
            if (this.fileName().length() == 0) {
                return Stream.empty();
            }
            return this.compilation.getSourceMappings().stream().map(sourceMapping -> new NativeImageDebugLineInfo((SourceMapping)sourceMapping));
        }

        public int getFrameSize() {
            return this.compilation.getTotalFrameSize();
        }

        public List<DebugInfoProvider.DebugFrameSizeChange> getFrameSizeChanges() {
            LinkedList<DebugInfoProvider.DebugFrameSizeChange> frameSizeChanges = new LinkedList<DebugInfoProvider.DebugFrameSizeChange>();
            for (CompilationResult.CodeMark mark : this.compilation.getMarks()) {
                NativeImageDebugFrameSizeChange sizeChange;
                if (mark.id.equals((Object)SubstrateBackend.SubstrateMarkId.PROLOGUE_DECD_RSP)) {
                    sizeChange = new NativeImageDebugFrameSizeChange(mark.pcOffset, DebugInfoProvider.DebugFrameSizeChange.Type.EXTEND);
                    frameSizeChanges.add(sizeChange);
                    continue;
                }
                if (mark.id.equals((Object)SubstrateBackend.SubstrateMarkId.EPILOGUE_INCD_RSP)) {
                    sizeChange = new NativeImageDebugFrameSizeChange(mark.pcOffset, DebugInfoProvider.DebugFrameSizeChange.Type.CONTRACT);
                    frameSizeChanges.add(sizeChange);
                    continue;
                }
                if (!mark.id.equals((Object)SubstrateBackend.SubstrateMarkId.EPILOGUE_END) || mark.pcOffset >= this.compilation.getTargetCodeSize()) continue;
                sizeChange = new NativeImageDebugFrameSizeChange(mark.pcOffset, DebugInfoProvider.DebugFrameSizeChange.Type.EXTEND);
                frameSizeChanges.add(sizeChange);
            }
            return frameSizeChanges;
        }

        public boolean isDeoptTarget() {
            return this.methodName().endsWith("**");
        }
    }
}

