/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.svm.hosted.dashboard;

import com.oracle.svm.hosted.FeatureImpl;
import com.oracle.svm.hosted.code.CompileQueue;
import com.oracle.svm.hosted.dashboard.ToJson;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Stream;
import org.graalvm.nativeimage.hosted.Feature;

class CodeBreakdownJsonObject
extends ToJson.JsonObject {
    private boolean built = false;
    private Feature.AfterCompilationAccess access;
    private final Map<String, Integer> data = new HashMap<String, Integer>();

    CodeBreakdownJsonObject(Feature.AfterCompilationAccess access) {
        this.access = access;
    }

    public Map<String, Integer> getData() {
        return this.data;
    }

    @Override
    Stream<String> getNames() {
        return Arrays.asList("code-size").stream();
    }

    @Override
    ToJson.JsonValue getValue(String name) {
        return ToJson.JsonArray.get(this.data.entrySet().stream().map(MethodJsonObject::new));
    }

    @Override
    protected void build() {
        if (this.built) {
            return;
        }
        for (CompileQueue.CompileTask task : ((FeatureImpl.AfterCompilationAccessImpl)this.access).getCompilationTasks()) {
            this.data.merge(task.method.format("%H.%n(%p) %r"), task.result.getTargetCodeSize(), Integer::sum);
        }
        this.access = null;
        this.built = true;
    }

    private static class MethodJsonObject
    extends ToJson.JsonObject {
        private static final String INFO_NAME = "name";
        private static final List<String> NAMES = Arrays.asList("name", "size");
        private final String methodName;
        private final int methodSize;

        MethodJsonObject(Map.Entry<String, Integer> entry) {
            this(entry.getKey(), entry.getValue());
        }

        MethodJsonObject(String name, int size) {
            this.methodName = name;
            this.methodSize = size;
        }

        @Override
        Stream<String> getNames() {
            return NAMES.stream();
        }

        @Override
        ToJson.JsonValue getValue(String name) {
            return INFO_NAME.equals(name) ? ToJson.JsonString.get(this.methodName) : ToJson.JsonNumber.get(this.methodSize);
        }
    }
}

