/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.svm.hosted;

import com.oracle.svm.core.util.UserError;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import org.graalvm.nativeimage.impl.ImageSingletonsSupport;

public final class ImageSingletonsSupportImpl
extends ImageSingletonsSupport {
    public <T> void add(Class<T> key, T value) {
        HostedManagement.getAndAssertExists().doAdd(key, value);
    }

    public <T> T lookup(Class<T> key) {
        return HostedManagement.getAndAssertExists().doLookup(key);
    }

    public boolean contains(Class<?> key) {
        HostedManagement hm = HostedManagement.get();
        if (hm == null) {
            return false;
        }
        return hm.doContains(key);
    }

    public static final class HostedManagement {
        private static final ThreadLocal<HostedManagement> hostedVMConfig;
        private final Map<Class<?>, Object> configObjects = new ConcurrentHashMap();

        public static HostedManagement getAndAssertExists() {
            HostedManagement result = HostedManagement.get();
            assert (result != null);
            return result;
        }

        public static HostedManagement get() {
            return hostedVMConfig.get();
        }

        public static void installInThread(HostedManagement vmConfig) {
            assert (hostedVMConfig.get() == null);
            hostedVMConfig.set(vmConfig);
        }

        public static void clearInThread() {
            assert (hostedVMConfig.get() != null);
            hostedVMConfig.set(null);
        }

        <T> void doAdd(Class<T> key, T value) {
            HostedManagement.checkKey(key);
            if (value == null) {
                throw UserError.abort("ImageSingletons do not allow null value for key %s", key.getTypeName());
            }
            Object prevValue = this.configObjects.putIfAbsent(key, value);
            if (prevValue != null) {
                throw UserError.abort("ImageSingletons.add must not overwrite existing key %s%nExisting value: %s%nNew value: %s", key.getTypeName(), prevValue, value);
            }
        }

        <T> T doLookup(Class<T> key) {
            HostedManagement.checkKey(key);
            Object result = this.configObjects.get(key);
            if (result == null) {
                throw UserError.abort("ImageSingletons do not contain key %s", key.getTypeName());
            }
            return key.cast(result);
        }

        boolean doContains(Class<?> key) {
            HostedManagement.checkKey(key);
            return this.configObjects.containsKey(key);
        }

        private static void checkKey(Class<?> key) {
            if (key == null) {
                throw UserError.abort("ImageSingletons do not allow null keys", new Object[0]);
            }
        }

        static {
            ImageSingletonsSupportImpl.installSupport((ImageSingletonsSupport)new ImageSingletonsSupportImpl());
            hostedVMConfig = new ThreadLocal();
        }
    }
}

