/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.svm.core.jdk;

import com.oracle.svm.core.annotate.Substitute;
import com.oracle.svm.core.annotate.TargetClass;
import com.oracle.svm.core.jdk.LocalizationSupport;
import com.oracle.svm.core.util.VMError;
import java.util.Locale;
import java.util.spi.LocaleServiceProvider;
import org.graalvm.nativeimage.ImageSingletons;
import sun.util.locale.provider.LocaleProviderAdapter;

@TargetClass(value=LocaleProviderAdapter.class)
final class Target_sun_util_locale_provider_LocaleProviderAdapter {
    Target_sun_util_locale_provider_LocaleProviderAdapter() {
    }

    @Substitute
    public static LocaleProviderAdapter getAdapter(Class<? extends LocaleServiceProvider> providerClass, Locale locale) {
        LocaleProviderAdapter result = ((LocalizationSupport)ImageSingletons.lookup(LocalizationSupport.class)).adaptersByClass.get(providerClass);
        if (result != null) {
            return result;
        }
        throw VMError.unsupportedFeature("LocaleProviderAdapter.getAdapter:  providerClass: " + providerClass.getName());
    }

    @Substitute
    public static LocaleProviderAdapter forType(LocaleProviderAdapter.Type type) {
        LocaleProviderAdapter result = ((LocalizationSupport)ImageSingletons.lookup(LocalizationSupport.class)).adaptersByType.get((Object)type);
        if (result != null) {
            return result;
        }
        throw VMError.unsupportedFeature("LocaleProviderAdapter.forType:  type: " + type.toString());
    }
}

