/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.svm.core.jdk;

import com.oracle.svm.core.annotate.Alias;
import com.oracle.svm.core.annotate.RecomputeFieldValue;
import com.oracle.svm.core.annotate.Substitute;
import com.oracle.svm.core.annotate.TargetClass;
import com.oracle.svm.core.annotate.TargetElement;
import com.oracle.svm.core.jdk.IsMultiThreaded;
import com.oracle.svm.core.jdk.IsSingleThreaded;
import com.oracle.svm.core.jdk.Util_java_lang_ApplicationShutdownHooks;
import com.oracle.svm.core.log.Log;
import java.util.ArrayList;
import java.util.IdentityHashMap;
import java.util.Set;

@TargetClass(className="java.lang.ApplicationShutdownHooks")
final class Target_java_lang_ApplicationShutdownHooks {
    @Alias
    @RecomputeFieldValue(kind=RecomputeFieldValue.Kind.NewInstance, declClass=IdentityHashMap.class)
    private static IdentityHashMap<Thread, Thread> hooks;

    Target_java_lang_ApplicationShutdownHooks() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Substitute
    @TargetElement(name="runHooks", onlyWith={IsSingleThreaded.class})
    static void runHooksSingleThreaded() {
        Class<Target_java_lang_ApplicationShutdownHooks> clazz = Target_java_lang_ApplicationShutdownHooks.class;
        synchronized (Target_java_lang_ApplicationShutdownHooks.class) {
            Set<Thread> threads = hooks.keySet();
            hooks = null;
            // ** MonitorExit[var1] (shouldn't be in output)
            ArrayList<Throwable> hookExceptions = new ArrayList<Throwable>();
            for (Thread hook : threads) {
                try {
                    Util_java_lang_ApplicationShutdownHooks.callRunnableOfThread(hook);
                }
                catch (Throwable ex) {
                    hookExceptions.add(ex);
                }
            }
            if (hookExceptions.size() > 0) {
                for (Throwable ex : hookExceptions) {
                    ex.printStackTrace(Log.logStream());
                }
            }
            return;
        }
    }

    @Alias
    @TargetElement(name="runHooks", onlyWith={IsMultiThreaded.class})
    static native void runHooksMultiThreaded();

    @Substitute
    static synchronized void add(Thread hook) {
        Util_java_lang_ApplicationShutdownHooks.initializeOnce();
        if (hooks == null) {
            throw new IllegalStateException("Shutdown in progress");
        }
        if (hook.isAlive()) {
            throw new IllegalArgumentException("Hook already running");
        }
        if (hooks.containsKey(hook)) {
            throw new IllegalArgumentException("Hook previously registered");
        }
        hooks.put(hook, hook);
    }
}

