/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.svm.core.c.function;

import com.oracle.svm.core.SubstrateOptions;
import com.oracle.svm.core.c.function.CEntryPointSetup;
import java.lang.annotation.ElementType;
import java.lang.annotation.Retention;
import java.lang.annotation.RetentionPolicy;
import java.lang.annotation.Target;
import java.util.function.BooleanSupplier;
import java.util.function.Function;

@Retention(value=RetentionPolicy.RUNTIME)
@Target(value={ElementType.METHOD})
public @interface CEntryPointOptions {
    public Class<? extends Function<String, String>> nameTransformation() default DefaultNameTransformation.class;

    public Class<? extends BooleanSupplier> include() default AlwaysIncluded.class;

    public Class<?> prologue() default AutomaticPrologue.class;

    public Class<?> epilogue() default CEntryPointSetup.LeaveEpilogue.class;

    public Publish publishAs() default Publish.SymbolAndHeader;

    public static enum Publish {
        NotPublished,
        SymbolOnly,
        SymbolAndHeader;

    }

    public static final class NoEpilogue {
    }

    public static final class NoPrologue {
    }

    public static final class AutomaticPrologue {
    }

    public static class NotIncludedAutomatically
    implements BooleanSupplier {
        @Override
        public boolean getAsBoolean() {
            return false;
        }
    }

    public static class AlwaysIncluded
    implements BooleanSupplier {
        @Override
        public boolean getAsBoolean() {
            return true;
        }
    }

    public static final class UnchangedNameTransformation
    implements Function<String, String> {
        @Override
        public String apply(String name) {
            return name;
        }
    }

    public static final class DefaultNameTransformation
    implements Function<String, String> {
        @Override
        public String apply(String name) {
            return SubstrateOptions.EntryPointNamePrefix.getValue() + name;
        }
    }
}

